# astro_api

AstroApi - JavaScript client for astro_api
Professional astrology API for natal charts, transits, synastry, and interpretations
This SDK is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 25.12.4
- Package version: 25.12.4
- Generator version: 7.17.0
- Build package: org.openapitools.codegen.languages.JavascriptClientCodegen

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/), please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install astro_api --save
```

Finally, you need to build the module:

```shell
npm run build
```

##### Local development

To use the library locally without publishing to a remote npm registry, first install the dependencies by changing into the directory containing `package.json` (and this README). Let's call this `JAVASCRIPT_CLIENT_DIR`. Then run:

```shell
npm install
```

Next, [link](https://docs.npmjs.com/cli/link) it globally in npm with the following, also from `JAVASCRIPT_CLIENT_DIR`:

```shell
npm link
```

To use the link you just defined in your project, switch to the directory you want to use your astro_api from, and run:

```shell
npm link /path/to/<JAVASCRIPT_CLIENT_DIR>
```

Finally, you need to build the module:

```shell
npm run build
```

#### git

If the library is hosted at a git repository, e.g.https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var AstroApi = require('astro_api');

var defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
var ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = "YOUR API KEY"
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix['X-Api-Key'] = "Token"

var api = new AstroApi.APIKeysApi()
var id = "id_example"; // {String} 
api.deleteApiKey(id).then(function() {
  console.log('API called successfully.');
}, function(error) {
  console.error(error);
});


```

## Documentation for API Endpoints

All URIs are relative to *https://api.astroapi.cloud*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AstroApi.APIKeysApi* | [**deleteApiKey**](docs/APIKeysApi.md#deleteApiKey) | **DELETE** /api/api-keys/{id} | Delete API Key
*AstroApi.APIKeysApi* | [**getApiApiKeys**](docs/APIKeysApi.md#getApiApiKeys) | **GET** /api/api-keys | List API Keys
*AstroApi.APIKeysApi* | [**getApiApiKeysAvailableOptions**](docs/APIKeysApi.md#getApiApiKeysAvailableOptions) | **GET** /api/api-keys/available-options | Available Options
*AstroApi.APIKeysApi* | [**getApiKey**](docs/APIKeysApi.md#getApiKey) | **GET** /api/api-keys/{id} | Get API Key
*AstroApi.APIKeysApi* | [**postApiApiKeys**](docs/APIKeysApi.md#postApiApiKeys) | **POST** /api/api-keys | Create API Key
*AstroApi.APIKeysApi* | [**updateApiKey**](docs/APIKeysApi.md#updateApiKey) | **PATCH** /api/api-keys/{id} | Update API Key
*AstroApi.CalculationsApi* | [**postApiCalcChineseForecast**](docs/CalculationsApi.md#postApiCalcChineseForecast) | **POST** /api/calc/chinese-forecast | Chinese Zodiac Forecast
*AstroApi.CalculationsApi* | [**postApiCalcChineseHoroscope**](docs/CalculationsApi.md#postApiCalcChineseHoroscope) | **POST** /api/calc/chinese-horoscope | Chinese Zodiac Sign
*AstroApi.CalculationsApi* | [**postApiCalcCompatibility**](docs/CalculationsApi.md#postApiCalcCompatibility) | **POST** /api/calc/compatibility | Compatibility Analysis
*AstroApi.CalculationsApi* | [**postApiCalcComposite**](docs/CalculationsApi.md#postApiCalcComposite) | **POST** /api/calc/composite | Composite Chart
*AstroApi.CalculationsApi* | [**postApiCalcLunarReturn**](docs/CalculationsApi.md#postApiCalcLunarReturn) | **POST** /api/calc/lunar-return | Lunar Return
*AstroApi.CalculationsApi* | [**postApiCalcMoonSun**](docs/CalculationsApi.md#postApiCalcMoonSun) | **POST** /api/calc/moon-sun | Moon &amp; Sun Info
*AstroApi.CalculationsApi* | [**postApiCalcNatal**](docs/CalculationsApi.md#postApiCalcNatal) | **POST** /api/calc/natal | Natal Chart
*AstroApi.CalculationsApi* | [**postApiCalcProgressions**](docs/CalculationsApi.md#postApiCalcProgressions) | **POST** /api/calc/progressions | Secondary Progressions
*AstroApi.CalculationsApi* | [**postApiCalcSolarReturn**](docs/CalculationsApi.md#postApiCalcSolarReturn) | **POST** /api/calc/solar-return | Solar Return
*AstroApi.CalculationsApi* | [**postApiCalcSynastry**](docs/CalculationsApi.md#postApiCalcSynastry) | **POST** /api/calc/synastry | Synastry Chart
*AstroApi.CalculationsApi* | [**postApiCalcTransit**](docs/CalculationsApi.md#postApiCalcTransit) | **POST** /api/calc/transit | Transit Chart
*AstroApi.ChatApi* | [**chat**](docs/ChatApi.md#chat) | **POST** /api/chat/{chatbotId} | Chat with Chatbot
*AstroApi.ChatApi* | [**chatDirect**](docs/ChatApi.md#chatDirect) | **POST** /api/chat/{chatbotId}/direct | Chat with Birth Data
*AstroApi.ChatApi* | [**chatWithProfile**](docs/ChatApi.md#chatWithProfile) | **POST** /api/chat/{chatbotId}/profile/{profileId} | Chat with Profile
*AstroApi.ChatApi* | [**deleteConversation**](docs/ChatApi.md#deleteConversation) | **DELETE** /api/chat/{chatbotId}/conversation/{conversationId} | Delete Conversation
*AstroApi.ChatApi* | [**getConversation**](docs/ChatApi.md#getConversation) | **GET** /api/chat/{chatbotId}/conversation/{conversationId} | Get Conversation
*AstroApi.ChatbotApi* | [**createChatProfile**](docs/ChatbotApi.md#createChatProfile) | **POST** /api/chatbots/{id}/profiles | Create Chat Profile
*AstroApi.ChatbotApi* | [**createChatbot**](docs/ChatbotApi.md#createChatbot) | **POST** /api/chatbots | Create Chatbot
*AstroApi.ChatbotApi* | [**deleteChatProfile**](docs/ChatbotApi.md#deleteChatProfile) | **DELETE** /api/chatbots/{id}/profiles/{profileId} | Delete Chat Profile
*AstroApi.ChatbotApi* | [**deleteChatbot**](docs/ChatbotApi.md#deleteChatbot) | **DELETE** /api/chatbots/{id} | Delete Chatbot
*AstroApi.ChatbotApi* | [**getChatbot**](docs/ChatbotApi.md#getChatbot) | **GET** /api/chatbots/{id} | Get Chatbot
*AstroApi.ChatbotApi* | [**getChatbotUsage**](docs/ChatbotApi.md#getChatbotUsage) | **GET** /api/chatbots/usage | Get Chatbot Usage
*AstroApi.ChatbotApi* | [**listChatProfiles**](docs/ChatbotApi.md#listChatProfiles) | **GET** /api/chatbots/{id}/profiles | List Chat Profiles
*AstroApi.ChatbotApi* | [**listChatbotPlugins**](docs/ChatbotApi.md#listChatbotPlugins) | **GET** /api/chatbots/plugins | List Available Plugins
*AstroApi.ChatbotApi* | [**listChatbots**](docs/ChatbotApi.md#listChatbots) | **GET** /api/chatbots | List Chatbots
*AstroApi.ChatbotApi* | [**updateChatbot**](docs/ChatbotApi.md#updateChatbot) | **PATCH** /api/chatbots/{id} | Update Chatbot
*AstroApi.ContentApi* | [**createContent**](docs/ContentApi.md#createContent) | **POST** /api/content/{horoscopeType}/{contentType} | Create Content
*AstroApi.ContentApi* | [**createContentCustomCopy**](docs/ContentApi.md#createContentCustomCopy) | **POST** /api/content/{id}/create-custom-copy | Create Custom Copy
*AstroApi.ContentApi* | [**deleteContent**](docs/ContentApi.md#deleteContent) | **DELETE** /api/content/{horoscopeType}/{contentType}/{id} | Delete Content
*AstroApi.ContentApi* | [**deleteContentById**](docs/ContentApi.md#deleteContentById) | **DELETE** /api/content/{id} | Delete Content by ID
*AstroApi.ContentApi* | [**getContent**](docs/ContentApi.md#getContent) | **GET** /api/content/{horoscopeType}/{contentType}/{id} | Get Content
*AstroApi.ContentApi* | [**listContent**](docs/ContentApi.md#listContent) | **GET** /api/content/{horoscopeType}/{contentType} | List Content
*AstroApi.ContentApi* | [**restoreContent**](docs/ContentApi.md#restoreContent) | **POST** /api/content/{id}/restore | Restore Content
*AstroApi.HoroscopeApi* | [**getDailyHoroscopes**](docs/HoroscopeApi.md#getDailyHoroscopes) | **GET** /api/horoscope/daily/{date} | Get Daily Horoscopes
*AstroApi.HoroscopeApi* | [**getWeeklyHoroscope**](docs/HoroscopeApi.md#getWeeklyHoroscope) | **GET** /api/horoscope/weekly/{year}/{week}/{zodiacSign} | Get Weekly Horoscope Report
*AstroApi.HoroscopeApi* | [**getYearlyAscendantHoroscope**](docs/HoroscopeApi.md#getYearlyAscendantHoroscope) | **GET** /api/horoscope/yearly-ascendant/{year}/{zodiacSign} | Get Yearly Ascendant Horoscope Report
*AstroApi.HoroscopeApi* | [**getYearlyHoroscope**](docs/HoroscopeApi.md#getYearlyHoroscope) | **GET** /api/horoscope/yearly/{year}/{zodiacSign} | Get Yearly Horoscope Report
*AstroApi.ModulesApi* | [**getApiModules**](docs/ModulesApi.md#getApiModules) | **GET** /api/modules | List Modules
*AstroApi.ModulesApi* | [**getApiModulesCheckModuleId**](docs/ModulesApi.md#getApiModulesCheckModuleId) | **GET** /api/modules/check/{moduleId} | Check Module Access
*AstroApi.ModulesApi* | [**getApiModulesOrganization**](docs/ModulesApi.md#getApiModulesOrganization) | **GET** /api/modules/organization | Organization Modules
*AstroApi.ModulesApi* | [**getApiModulesPlans**](docs/ModulesApi.md#getApiModulesPlans) | **GET** /api/modules/plans | Subscription Plans
*AstroApi.NumerologyApi* | [**postApiNumerologyBirthday**](docs/NumerologyApi.md#postApiNumerologyBirthday) | **POST** /api/numerology/birthday | Birthday Number
*AstroApi.NumerologyApi* | [**postApiNumerologyCompatibility**](docs/NumerologyApi.md#postApiNumerologyCompatibility) | **POST** /api/numerology/compatibility | Numerology Compatibility
*AstroApi.NumerologyApi* | [**postApiNumerologyExpression**](docs/NumerologyApi.md#postApiNumerologyExpression) | **POST** /api/numerology/expression | Expression Number
*AstroApi.NumerologyApi* | [**postApiNumerologyLifePath**](docs/NumerologyApi.md#postApiNumerologyLifePath) | **POST** /api/numerology/life-path | Life Path Number
*AstroApi.NumerologyApi* | [**postApiNumerologyPersonalCycles**](docs/NumerologyApi.md#postApiNumerologyPersonalCycles) | **POST** /api/numerology/personal-cycles | Personal Cycles
*AstroApi.NumerologyApi* | [**postApiNumerologyPersonality**](docs/NumerologyApi.md#postApiNumerologyPersonality) | **POST** /api/numerology/personality | Personality Number
*AstroApi.NumerologyApi* | [**postApiNumerologyProfile**](docs/NumerologyApi.md#postApiNumerologyProfile) | **POST** /api/numerology/profile | Full Numerology Profile
*AstroApi.NumerologyApi* | [**postApiNumerologySoulUrge**](docs/NumerologyApi.md#postApiNumerologySoulUrge) | **POST** /api/numerology/soul-urge | Soul Urge Number
*AstroApi.OrganizationsApi* | [**deleteApiOrgUsersMemberId**](docs/OrganizationsApi.md#deleteApiOrgUsersMemberId) | **DELETE** /api/org/users/{memberId} | Remove Member
*AstroApi.OrganizationsApi* | [**getApiOrgUsers**](docs/OrganizationsApi.md#getApiOrgUsers) | **GET** /api/org/users | List Members
*AstroApi.OrganizationsApi* | [**patchApiOrgUsersMemberId**](docs/OrganizationsApi.md#patchApiOrgUsersMemberId) | **PATCH** /api/org/users/{memberId} | Update Member
*AstroApi.OrganizationsApi* | [**postApiOrg**](docs/OrganizationsApi.md#postApiOrg) | **POST** /api/org | Create Organization
*AstroApi.OrganizationsApi* | [**postApiOrgUsers**](docs/OrganizationsApi.md#postApiOrgUsers) | **POST** /api/org/users | Add Member
*AstroApi.WidgetApi* | [**getWidgetConfig**](docs/WidgetApi.md#getWidgetConfig) | **GET** /widget/config/{chatbotId} | Get Widget Configuration
*AstroApi.WidgetApi* | [**widgetChat**](docs/WidgetApi.md#widgetChat) | **POST** /widget/chat/{chatbotId} | Widget Chat
*AstroApi.WidgetApi* | [**widgetChatWithUser**](docs/WidgetApi.md#widgetChatWithUser) | **POST** /widget/chat/{chatbotId}/user/{externalUserId} | Widget Chat with User Profile


## Documentation for Models

 - [AstroApi.ApiKey](docs/ApiKey.md)
 - [AstroApi.ApiKey1](docs/ApiKey1.md)
 - [AstroApi.ApiKeyCreated](docs/ApiKeyCreated.md)
 - [AstroApi.ApiKeyModule](docs/ApiKeyModule.md)
 - [AstroApi.ApiKeyOptions](docs/ApiKeyOptions.md)
 - [AstroApi.Aspect](docs/Aspect.md)
 - [AstroApi.Aspect1](docs/Aspect1.md)
 - [AstroApi.CelestialPoint](docs/CelestialPoint.md)
 - [AstroApi.CelestialPoint1](docs/CelestialPoint1.md)
 - [AstroApi.Chart](docs/Chart.md)
 - [AstroApi.ChartEntry](docs/ChartEntry.md)
 - [AstroApi.ChartEntry1](docs/ChartEntry1.md)
 - [AstroApi.ChatDirectRequest](docs/ChatDirectRequest.md)
 - [AstroApi.ChatDirectRequestBirthData](docs/ChatDirectRequestBirthData.md)
 - [AstroApi.ChatRequest](docs/ChatRequest.md)
 - [AstroApi.ChineseForecastData](docs/ChineseForecastData.md)
 - [AstroApi.ChineseForecastRequest](docs/ChineseForecastRequest.md)
 - [AstroApi.ChineseForecastResponse](docs/ChineseForecastResponse.md)
 - [AstroApi.ChineseHoroscopeData](docs/ChineseHoroscopeData.md)
 - [AstroApi.ChineseHoroscopeRequest](docs/ChineseHoroscopeRequest.md)
 - [AstroApi.ChineseHoroscopeResponse](docs/ChineseHoroscopeResponse.md)
 - [AstroApi.CompatibilityData](docs/CompatibilityData.md)
 - [AstroApi.CompatibilityRequest](docs/CompatibilityRequest.md)
 - [AstroApi.CompatibilityResponse](docs/CompatibilityResponse.md)
 - [AstroApi.CompositeData](docs/CompositeData.md)
 - [AstroApi.CompositeRequest](docs/CompositeRequest.md)
 - [AstroApi.CompositeResponse](docs/CompositeResponse.md)
 - [AstroApi.Content](docs/Content.md)
 - [AstroApi.ContentAttributes](docs/ContentAttributes.md)
 - [AstroApi.ContentLinks](docs/ContentLinks.md)
 - [AstroApi.ContentResponse](docs/ContentResponse.md)
 - [AstroApi.CreateApiKeyRequest](docs/CreateApiKeyRequest.md)
 - [AstroApi.CreateChatProfileRequest](docs/CreateChatProfileRequest.md)
 - [AstroApi.CreateChatProfileRequestData](docs/CreateChatProfileRequestData.md)
 - [AstroApi.CreateChatProfileRequestDataAttributes](docs/CreateChatProfileRequestDataAttributes.md)
 - [AstroApi.CreateChatbotRequest](docs/CreateChatbotRequest.md)
 - [AstroApi.CreateChatbotRequestData](docs/CreateChatbotRequestData.md)
 - [AstroApi.CreateChatbotRequestDataAttributes](docs/CreateChatbotRequestDataAttributes.md)
 - [AstroApi.DailyHoroscopeAttributes](docs/DailyHoroscopeAttributes.md)
 - [AstroApi.DailyHoroscopeItem](docs/DailyHoroscopeItem.md)
 - [AstroApi.DailyHoroscopeResponse](docs/DailyHoroscopeResponse.md)
 - [AstroApi.DailyHoroscopeResponseData](docs/DailyHoroscopeResponseData.md)
 - [AstroApi.GetApiApiKeys200Response](docs/GetApiApiKeys200Response.md)
 - [AstroApi.GetApiKey200Response](docs/GetApiKey200Response.md)
 - [AstroApi.GetApiModules200Response](docs/GetApiModules200Response.md)
 - [AstroApi.GetApiModulesOrganization200Response](docs/GetApiModulesOrganization200Response.md)
 - [AstroApi.GetApiModulesPlans200Response](docs/GetApiModulesPlans200Response.md)
 - [AstroApi.GetApiOrgUsers200Response](docs/GetApiOrgUsers200Response.md)
 - [AstroApi.GetApiOrgUsers200ResponseDataInner](docs/GetApiOrgUsers200ResponseDataInner.md)
 - [AstroApi.GetApiOrgUsers200ResponseDataInnerAttributes](docs/GetApiOrgUsers200ResponseDataInnerAttributes.md)
 - [AstroApi.GetApiOrgUsers200ResponseLinks](docs/GetApiOrgUsers200ResponseLinks.md)
 - [AstroApi.GetApiOrgUsers200ResponseMeta](docs/GetApiOrgUsers200ResponseMeta.md)
 - [AstroApi.HoroscopeReportAttributes](docs/HoroscopeReportAttributes.md)
 - [AstroApi.HoroscopeReportResponse](docs/HoroscopeReportResponse.md)
 - [AstroApi.HoroscopeReportResponseData](docs/HoroscopeReportResponseData.md)
 - [AstroApi.Houses](docs/Houses.md)
 - [AstroApi.Location](docs/Location.md)
 - [AstroApi.LunarReturnData](docs/LunarReturnData.md)
 - [AstroApi.LunarReturnRequest](docs/LunarReturnRequest.md)
 - [AstroApi.LunarReturnResponse](docs/LunarReturnResponse.md)
 - [AstroApi.Module](docs/Module.md)
 - [AstroApi.ModuleAccessCheck](docs/ModuleAccessCheck.md)
 - [AstroApi.MoonInfo](docs/MoonInfo.md)
 - [AstroApi.MoonSunData](docs/MoonSunData.md)
 - [AstroApi.MoonSunRequest](docs/MoonSunRequest.md)
 - [AstroApi.MoonSunResponse](docs/MoonSunResponse.md)
 - [AstroApi.NatalData](docs/NatalData.md)
 - [AstroApi.NatalRequest](docs/NatalRequest.md)
 - [AstroApi.NatalResponse](docs/NatalResponse.md)
 - [AstroApi.NumerologyBirthdayRequest](docs/NumerologyBirthdayRequest.md)
 - [AstroApi.NumerologyBirthdayResponse](docs/NumerologyBirthdayResponse.md)
 - [AstroApi.NumerologyCompatibility](docs/NumerologyCompatibility.md)
 - [AstroApi.NumerologyCompatibilityRequest](docs/NumerologyCompatibilityRequest.md)
 - [AstroApi.NumerologyCompatibilityResponse](docs/NumerologyCompatibilityResponse.md)
 - [AstroApi.NumerologyExpressionRequest](docs/NumerologyExpressionRequest.md)
 - [AstroApi.NumerologyExpressionResponse](docs/NumerologyExpressionResponse.md)
 - [AstroApi.NumerologyLifePathRequest](docs/NumerologyLifePathRequest.md)
 - [AstroApi.NumerologyLifePathResponse](docs/NumerologyLifePathResponse.md)
 - [AstroApi.NumerologyNumber](docs/NumerologyNumber.md)
 - [AstroApi.NumerologyNumber1](docs/NumerologyNumber1.md)
 - [AstroApi.NumerologyPersonalCycles](docs/NumerologyPersonalCycles.md)
 - [AstroApi.NumerologyPersonalCyclesRequest](docs/NumerologyPersonalCyclesRequest.md)
 - [AstroApi.NumerologyPersonalCyclesResponse](docs/NumerologyPersonalCyclesResponse.md)
 - [AstroApi.NumerologyPersonalityRequest](docs/NumerologyPersonalityRequest.md)
 - [AstroApi.NumerologyPersonalityResponse](docs/NumerologyPersonalityResponse.md)
 - [AstroApi.NumerologyProfile](docs/NumerologyProfile.md)
 - [AstroApi.NumerologyProfileRequest](docs/NumerologyProfileRequest.md)
 - [AstroApi.NumerologyProfileResponse](docs/NumerologyProfileResponse.md)
 - [AstroApi.NumerologySoulUrgeRequest](docs/NumerologySoulUrgeRequest.md)
 - [AstroApi.NumerologySoulUrgeResponse](docs/NumerologySoulUrgeResponse.md)
 - [AstroApi.PatchApiOrgUsersMemberId200Response](docs/PatchApiOrgUsersMemberId200Response.md)
 - [AstroApi.PatchApiOrgUsersMemberId200ResponseData](docs/PatchApiOrgUsersMemberId200ResponseData.md)
 - [AstroApi.PatchApiOrgUsersMemberIdRequest](docs/PatchApiOrgUsersMemberIdRequest.md)
 - [AstroApi.Permission](docs/Permission.md)
 - [AstroApi.PostApiApiKeys201Response](docs/PostApiApiKeys201Response.md)
 - [AstroApi.PostApiOrgUsers201Response](docs/PostApiOrgUsers201Response.md)
 - [AstroApi.PostApiOrgUsers201ResponseData](docs/PostApiOrgUsers201ResponseData.md)
 - [AstroApi.PostApiOrgUsersRequest](docs/PostApiOrgUsersRequest.md)
 - [AstroApi.ProgressionsData](docs/ProgressionsData.md)
 - [AstroApi.ProgressionsRequest](docs/ProgressionsRequest.md)
 - [AstroApi.ProgressionsResponse](docs/ProgressionsResponse.md)
 - [AstroApi.ReportPeriod](docs/ReportPeriod.md)
 - [AstroApi.SolarReturnData](docs/SolarReturnData.md)
 - [AstroApi.SolarReturnRequest](docs/SolarReturnRequest.md)
 - [AstroApi.SolarReturnResponse](docs/SolarReturnResponse.md)
 - [AstroApi.SubscriptionPlan](docs/SubscriptionPlan.md)
 - [AstroApi.SunInfo](docs/SunInfo.md)
 - [AstroApi.SynastryData](docs/SynastryData.md)
 - [AstroApi.SynastryRequest](docs/SynastryRequest.md)
 - [AstroApi.SynastryResponse](docs/SynastryResponse.md)
 - [AstroApi.TransitData](docs/TransitData.md)
 - [AstroApi.TransitRequest](docs/TransitRequest.md)
 - [AstroApi.TransitResponse](docs/TransitResponse.md)
 - [AstroApi.Twilight](docs/Twilight.md)
 - [AstroApi.TwilightTimes](docs/TwilightTimes.md)
 - [AstroApi.UpdateApiKeyRequest](docs/UpdateApiKeyRequest.md)
 - [AstroApi.UpdateChatbotRequest](docs/UpdateChatbotRequest.md)
 - [AstroApi.UpdateChatbotRequestData](docs/UpdateChatbotRequestData.md)
 - [AstroApi.UpdateChatbotRequestDataAttributes](docs/UpdateChatbotRequestDataAttributes.md)
 - [AstroApi.WidgetChatRequest](docs/WidgetChatRequest.md)
 - [AstroApi.WidgetChatRequestBirthData](docs/WidgetChatRequestBirthData.md)
 - [AstroApi.WidgetChatWithUserRequest](docs/WidgetChatWithUserRequest.md)


## Documentation for Authorization


Authentication schemes defined for the API:
### ApiKeyAuth


- **Type**: API key
- **API key parameter name**: X-Api-Key
- **Location**: HTTP header

