# AstroApi.CalculationsApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**postApiCalcChineseForecast**](CalculationsApi.md#postApiCalcChineseForecast) | **POST** /api/calc/chinese-forecast | Chinese Zodiac Forecast
[**postApiCalcChineseHoroscope**](CalculationsApi.md#postApiCalcChineseHoroscope) | **POST** /api/calc/chinese-horoscope | Chinese Zodiac Sign
[**postApiCalcCompatibility**](CalculationsApi.md#postApiCalcCompatibility) | **POST** /api/calc/compatibility | Compatibility Analysis
[**postApiCalcComposite**](CalculationsApi.md#postApiCalcComposite) | **POST** /api/calc/composite | Composite Chart
[**postApiCalcLunarReturn**](CalculationsApi.md#postApiCalcLunarReturn) | **POST** /api/calc/lunar-return | Lunar Return
[**postApiCalcMoonSun**](CalculationsApi.md#postApiCalcMoonSun) | **POST** /api/calc/moon-sun | Moon &amp; Sun Info
[**postApiCalcNatal**](CalculationsApi.md#postApiCalcNatal) | **POST** /api/calc/natal | Natal Chart
[**postApiCalcProgressions**](CalculationsApi.md#postApiCalcProgressions) | **POST** /api/calc/progressions | Secondary Progressions
[**postApiCalcSolarReturn**](CalculationsApi.md#postApiCalcSolarReturn) | **POST** /api/calc/solar-return | Solar Return
[**postApiCalcSynastry**](CalculationsApi.md#postApiCalcSynastry) | **POST** /api/calc/synastry | Synastry Chart
[**postApiCalcTransit**](CalculationsApi.md#postApiCalcTransit) | **POST** /api/calc/transit | Transit Chart



## postApiCalcChineseForecast

> ChineseForecastResponse postApiCalcChineseForecast(opts)

Chinese Zodiac Forecast

Get Chinese zodiac forecast for a specific year with category breakdowns.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.CalculationsApi();
let opts = {
  'chineseForecastRequest': new AstroApi.ChineseForecastRequest() // ChineseForecastRequest | 
};
apiInstance.postApiCalcChineseForecast(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chineseForecastRequest** | [**ChineseForecastRequest**](ChineseForecastRequest.md)|  | [optional] 

### Return type

[**ChineseForecastResponse**](ChineseForecastResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiCalcChineseHoroscope

> ChineseHoroscopeResponse postApiCalcChineseHoroscope(opts)

Chinese Zodiac Sign

Calculate the Chinese zodiac sign and element based on birth year.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.CalculationsApi();
let opts = {
  'chineseHoroscopeRequest': new AstroApi.ChineseHoroscopeRequest() // ChineseHoroscopeRequest | 
};
apiInstance.postApiCalcChineseHoroscope(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chineseHoroscopeRequest** | [**ChineseHoroscopeRequest**](ChineseHoroscopeRequest.md)|  | [optional] 

### Return type

[**ChineseHoroscopeResponse**](ChineseHoroscopeResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiCalcCompatibility

> CompatibilityResponse postApiCalcCompatibility(opts)

Compatibility Analysis

Calculate sun sign compatibility between two people with interpretation text.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.CalculationsApi();
let opts = {
  'compatibilityRequest': new AstroApi.CompatibilityRequest() // CompatibilityRequest | 
};
apiInstance.postApiCalcCompatibility(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **compatibilityRequest** | [**CompatibilityRequest**](CompatibilityRequest.md)|  | [optional] 

### Return type

[**CompatibilityResponse**](CompatibilityResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiCalcComposite

> CompositeResponse postApiCalcComposite(opts)

Composite Chart

Calculate a composite chart by combining midpoints of two birth charts.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.CalculationsApi();
let opts = {
  'compositeRequest': new AstroApi.CompositeRequest() // CompositeRequest | 
};
apiInstance.postApiCalcComposite(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **compositeRequest** | [**CompositeRequest**](CompositeRequest.md)|  | [optional] 

### Return type

[**CompositeResponse**](CompositeResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiCalcLunarReturn

> LunarReturnResponse postApiCalcLunarReturn(opts)

Lunar Return

Calculate the lunar return chart when the Moon returns to its natal position.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.CalculationsApi();
let opts = {
  'lunarReturnRequest': new AstroApi.LunarReturnRequest() // LunarReturnRequest | 
};
apiInstance.postApiCalcLunarReturn(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **lunarReturnRequest** | [**LunarReturnRequest**](LunarReturnRequest.md)|  | [optional] 

### Return type

[**LunarReturnResponse**](LunarReturnResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiCalcMoonSun

> MoonSunResponse postApiCalcMoonSun(opts)

Moon &amp; Sun Info

Get Moon and Sun information for a specific place and time. Includes moon phase, illumination, distance, and sun rise/set/twilight times.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.CalculationsApi();
let opts = {
  'moonSunRequest': new AstroApi.MoonSunRequest() // MoonSunRequest | 
};
apiInstance.postApiCalcMoonSun(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **moonSunRequest** | [**MoonSunRequest**](MoonSunRequest.md)|  | [optional] 

### Return type

[**MoonSunResponse**](MoonSunResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiCalcNatal

> NatalResponse postApiCalcNatal(opts)

Natal Chart

Calculate a natal (birth) chart with planetary positions, house cusps, and aspects.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.CalculationsApi();
let opts = {
  'natalRequest': new AstroApi.NatalRequest() // NatalRequest | 
};
apiInstance.postApiCalcNatal(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **natalRequest** | [**NatalRequest**](NatalRequest.md)|  | [optional] 

### Return type

[**NatalResponse**](NatalResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiCalcProgressions

> ProgressionsResponse postApiCalcProgressions(opts)

Secondary Progressions

Calculate secondary progressions chart using the day-for-a-year method. Returns progressed planet positions and aspects to both progressed and natal planets.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.CalculationsApi();
let opts = {
  'progressionsRequest': new AstroApi.ProgressionsRequest() // ProgressionsRequest | 
};
apiInstance.postApiCalcProgressions(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **progressionsRequest** | [**ProgressionsRequest**](ProgressionsRequest.md)|  | [optional] 

### Return type

[**ProgressionsResponse**](ProgressionsResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiCalcSolarReturn

> SolarReturnResponse postApiCalcSolarReturn(opts)

Solar Return

Calculate the solar return chart for a specific year (birthday chart).

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.CalculationsApi();
let opts = {
  'solarReturnRequest': new AstroApi.SolarReturnRequest() // SolarReturnRequest | 
};
apiInstance.postApiCalcSolarReturn(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **solarReturnRequest** | [**SolarReturnRequest**](SolarReturnRequest.md)|  | [optional] 

### Return type

[**SolarReturnResponse**](SolarReturnResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiCalcSynastry

> SynastryResponse postApiCalcSynastry(opts)

Synastry Chart

Calculate synastry aspects between two birth charts for relationship analysis.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.CalculationsApi();
let opts = {
  'synastryRequest': new AstroApi.SynastryRequest() // SynastryRequest | 
};
apiInstance.postApiCalcSynastry(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **synastryRequest** | [**SynastryRequest**](SynastryRequest.md)|  | [optional] 

### Return type

[**SynastryResponse**](SynastryResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiCalcTransit

> TransitResponse postApiCalcTransit(opts)

Transit Chart

Calculate planetary transits over a natal chart for a specified time period.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.CalculationsApi();
let opts = {
  'transitRequest': new AstroApi.TransitRequest() // TransitRequest | 
};
apiInstance.postApiCalcTransit(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transitRequest** | [**TransitRequest**](TransitRequest.md)|  | [optional] 

### Return type

[**TransitResponse**](TransitResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json

