# AstroApi.ChatApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**chat**](ChatApi.md#chat) | **POST** /api/chat/{chatbotId} | Chat with Chatbot
[**chatDirect**](ChatApi.md#chatDirect) | **POST** /api/chat/{chatbotId}/direct | Chat with Birth Data
[**chatWithProfile**](ChatApi.md#chatWithProfile) | **POST** /api/chat/{chatbotId}/profile/{profileId} | Chat with Profile
[**deleteConversation**](ChatApi.md#deleteConversation) | **DELETE** /api/chat/{chatbotId}/conversation/{conversationId} | Delete Conversation
[**getConversation**](ChatApi.md#getConversation) | **GET** /api/chat/{chatbotId}/conversation/{conversationId} | Get Conversation



## chat

> Object chat(chatbotId, opts)

Chat with Chatbot

Send a message to a chatbot and receive a streaming response via SSE

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatApi();
let chatbotId = "chatbotId_example"; // String | 
let opts = {
  'chatRequest': new AstroApi.ChatRequest() // ChatRequest | 
};
apiInstance.chat(chatbotId, opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbotId** | **String**|  | 
 **chatRequest** | [**ChatRequest**](ChatRequest.md)|  | [optional] 

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: text/event-stream


## chatDirect

> Object chatDirect(chatbotId, opts)

Chat with Birth Data

Send a message with inline birth data (no profile needed)

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatApi();
let chatbotId = "chatbotId_example"; // String | 
let opts = {
  'chatDirectRequest': new AstroApi.ChatDirectRequest() // ChatDirectRequest | 
};
apiInstance.chatDirect(chatbotId, opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbotId** | **String**|  | 
 **chatDirectRequest** | [**ChatDirectRequest**](ChatDirectRequest.md)|  | [optional] 

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: text/event-stream


## chatWithProfile

> Object chatWithProfile(chatbotId, profileId, opts)

Chat with Profile

Send a message using a pre-configured user profile

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatApi();
let chatbotId = "chatbotId_example"; // String | 
let profileId = "profileId_example"; // String | 
let opts = {
  'chatRequest': new AstroApi.ChatRequest() // ChatRequest | 
};
apiInstance.chatWithProfile(chatbotId, profileId, opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbotId** | **String**|  | 
 **profileId** | **String**|  | 
 **chatRequest** | [**ChatRequest**](ChatRequest.md)|  | [optional] 

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: text/event-stream


## deleteConversation

> deleteConversation(chatbotId, conversationId)

Delete Conversation

Delete a conversation and its history

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatApi();
let chatbotId = "chatbotId_example"; // String | 
let conversationId = "conversationId_example"; // String | 
apiInstance.deleteConversation(chatbotId, conversationId).then(() => {
  console.log('API called successfully.');
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbotId** | **String**|  | 
 **conversationId** | **String**|  | 

### Return type

null (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getConversation

> getConversation(chatbotId, conversationId)

Get Conversation

Retrieve conversation history

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatApi();
let chatbotId = "chatbotId_example"; // String | 
let conversationId = "conversationId_example"; // String | 
apiInstance.getConversation(chatbotId, conversationId).then(() => {
  console.log('API called successfully.');
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbotId** | **String**|  | 
 **conversationId** | **String**|  | 

### Return type

null (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

