# AstroApi.ChatbotApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createChatProfile**](ChatbotApi.md#createChatProfile) | **POST** /api/chatbots/{id}/profiles | Create Chat Profile
[**createChatbot**](ChatbotApi.md#createChatbot) | **POST** /api/chatbots | Create Chatbot
[**deleteChatProfile**](ChatbotApi.md#deleteChatProfile) | **DELETE** /api/chatbots/{id}/profiles/{profileId} | Delete Chat Profile
[**deleteChatbot**](ChatbotApi.md#deleteChatbot) | **DELETE** /api/chatbots/{id} | Delete Chatbot
[**getChatbot**](ChatbotApi.md#getChatbot) | **GET** /api/chatbots/{id} | Get Chatbot
[**getChatbotUsage**](ChatbotApi.md#getChatbotUsage) | **GET** /api/chatbots/usage | Get Chatbot Usage
[**listChatProfiles**](ChatbotApi.md#listChatProfiles) | **GET** /api/chatbots/{id}/profiles | List Chat Profiles
[**listChatbotPlugins**](ChatbotApi.md#listChatbotPlugins) | **GET** /api/chatbots/plugins | List Available Plugins
[**listChatbots**](ChatbotApi.md#listChatbots) | **GET** /api/chatbots | List Chatbots
[**updateChatbot**](ChatbotApi.md#updateChatbot) | **PATCH** /api/chatbots/{id} | Update Chatbot



## createChatProfile

> Object createChatProfile(id, opts)

Create Chat Profile

Create a pre-configured chat profile with birth data

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatbotApi();
let id = "id_example"; // String | 
let opts = {
  'createChatProfileRequest': new AstroApi.CreateChatProfileRequest() // CreateChatProfileRequest | 
};
apiInstance.createChatProfile(id, opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**|  | 
 **createChatProfileRequest** | [**CreateChatProfileRequest**](CreateChatProfileRequest.md)|  | [optional] 

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## createChatbot

> Object createChatbot(opts)

Create Chatbot

Create a new chatbot for the organization

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatbotApi();
let opts = {
  'createChatbotRequest': new AstroApi.CreateChatbotRequest() // CreateChatbotRequest | 
};
apiInstance.createChatbot(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **createChatbotRequest** | [**CreateChatbotRequest**](CreateChatbotRequest.md)|  | [optional] 

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## deleteChatProfile

> deleteChatProfile(id, profileId)

Delete Chat Profile

Delete a chat profile

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatbotApi();
let id = "id_example"; // String | 
let profileId = "profileId_example"; // String | 
apiInstance.deleteChatProfile(id, profileId).then(() => {
  console.log('API called successfully.');
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**|  | 
 **profileId** | **String**|  | 

### Return type

null (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## deleteChatbot

> deleteChatbot(id)

Delete Chatbot

Delete a chatbot

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatbotApi();
let id = "id_example"; // String | 
apiInstance.deleteChatbot(id).then(() => {
  console.log('API called successfully.');
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**|  | 

### Return type

null (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getChatbot

> Object getChatbot(id)

Get Chatbot

Get a specific chatbot by ID

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatbotApi();
let id = "id_example"; // String | 
apiInstance.getChatbot(id).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**|  | 

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## getChatbotUsage

> Object getChatbotUsage()

Get Chatbot Usage

Get chatbot usage statistics for the current organization

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatbotApi();
apiInstance.getChatbotUsage().then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters

This endpoint does not need any parameter.

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## listChatProfiles

> Object listChatProfiles(id)

List Chat Profiles

List all chat profiles for a chatbot

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatbotApi();
let id = "id_example"; // String | 
apiInstance.listChatProfiles(id).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**|  | 

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## listChatbotPlugins

> Object listChatbotPlugins()

List Available Plugins

List all available chatbot plugins

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatbotApi();
apiInstance.listChatbotPlugins().then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters

This endpoint does not need any parameter.

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## listChatbots

> Object listChatbots()

List Chatbots

List all chatbots for the current organization

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatbotApi();
apiInstance.listChatbots().then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters

This endpoint does not need any parameter.

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## updateChatbot

> Object updateChatbot(id, opts)

Update Chatbot

Update an existing chatbot

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ChatbotApi();
let id = "id_example"; // String | 
let opts = {
  'updateChatbotRequest': new AstroApi.UpdateChatbotRequest() // UpdateChatbotRequest | 
};
apiInstance.updateChatbot(id, opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**|  | 
 **updateChatbotRequest** | [**UpdateChatbotRequest**](UpdateChatbotRequest.md)|  | [optional] 

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json

