# AstroApi.ContentApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createContent**](ContentApi.md#createContent) | **POST** /api/content/{horoscopeType}/{contentType} | Create Content
[**createContentCustomCopy**](ContentApi.md#createContentCustomCopy) | **POST** /api/content/{id}/create-custom-copy | Create Custom Copy
[**deleteContent**](ContentApi.md#deleteContent) | **DELETE** /api/content/{horoscopeType}/{contentType}/{id} | Delete Content
[**deleteContentById**](ContentApi.md#deleteContentById) | **DELETE** /api/content/{id} | Delete Content by ID
[**getContent**](ContentApi.md#getContent) | **GET** /api/content/{horoscopeType}/{contentType}/{id} | Get Content
[**listContent**](ContentApi.md#listContent) | **GET** /api/content/{horoscopeType}/{contentType} | List Content
[**restoreContent**](ContentApi.md#restoreContent) | **POST** /api/content/{id}/restore | Restore Content



## createContent

> ContentResponse createContent(horoscopeType, contentType)

Create Content

Create a new content item for a specific horoscope and content type.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ContentApi();
let horoscopeType = "horoscopeType_example"; // String | 
let contentType = "contentType_example"; // String | 
apiInstance.createContent(horoscopeType, contentType).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **horoscopeType** | **String**|  | 
 **contentType** | **String**|  | 

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## createContentCustomCopy

> ContentResponse createContentCustomCopy(id)

Create Custom Copy

Create an organization-specific copy of system content for customization.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ContentApi();
let id = "id_example"; // String | 
apiInstance.createContentCustomCopy(id).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**|  | 

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## deleteContent

> deleteContent(id, horoscopeType, contentType)

Delete Content

Delete a content item by horoscope type, content type, and ID.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ContentApi();
let id = "id_example"; // String | 
let horoscopeType = "horoscopeType_example"; // String | 
let contentType = "contentType_example"; // String | 
apiInstance.deleteContent(id, horoscopeType, contentType).then(() => {
  console.log('API called successfully.');
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**|  | 
 **horoscopeType** | **String**|  | 
 **contentType** | **String**|  | 

### Return type

null (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## deleteContentById

> ContentResponse deleteContentById(id)

Delete Content by ID

Delete a content item by its ID.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ContentApi();
let id = "id_example"; // String | 
apiInstance.deleteContentById(id).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**|  | 

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## getContent

> ContentResponse getContent(id, horoscopeType, contentType)

Get Content

Retrieve a single content item by its ID.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ContentApi();
let id = "id_example"; // String | 
let horoscopeType = "horoscopeType_example"; // String | 
let contentType = "contentType_example"; // String | 
apiInstance.getContent(id, horoscopeType, contentType).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**|  | 
 **horoscopeType** | **String**|  | 
 **contentType** | **String**|  | 

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## listContent

> ContentResponse listContent(horoscopeType, contentType)

List Content

Retrieve a paginated list of content items filtered by horoscope and content type.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ContentApi();
let horoscopeType = "horoscopeType_example"; // String | 
let contentType = "contentType_example"; // String | 
apiInstance.listContent(horoscopeType, contentType).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **horoscopeType** | **String**|  | 
 **contentType** | **String**|  | 

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## restoreContent

> ContentResponse restoreContent(id)

Restore Content

Restore custom content to match the original system content.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ContentApi();
let id = "id_example"; // String | 
apiInstance.restoreContent(id).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**|  | 

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json

