# AstroApi.HoroscopeApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getDailyHoroscopes**](HoroscopeApi.md#getDailyHoroscopes) | **GET** /api/horoscope/daily/{date} | Get Daily Horoscopes
[**getWeeklyHoroscope**](HoroscopeApi.md#getWeeklyHoroscope) | **GET** /api/horoscope/weekly/{year}/{week}/{zodiacSign} | Get Weekly Horoscope Report
[**getYearlyAscendantHoroscope**](HoroscopeApi.md#getYearlyAscendantHoroscope) | **GET** /api/horoscope/yearly-ascendant/{year}/{zodiacSign} | Get Yearly Ascendant Horoscope Report
[**getYearlyHoroscope**](HoroscopeApi.md#getYearlyHoroscope) | **GET** /api/horoscope/yearly/{year}/{zodiacSign} | Get Yearly Horoscope Report



## getDailyHoroscopes

> DailyHoroscopeResponse getDailyHoroscopes(date)

Get Daily Horoscopes

Retrieve daily horoscopes for all zodiac signs for a specific date.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.HoroscopeApi();
let date = "date_example"; // String | 
apiInstance.getDailyHoroscopes(date).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **date** | **String**|  | 

### Return type

[**DailyHoroscopeResponse**](DailyHoroscopeResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## getWeeklyHoroscope

> HoroscopeReportResponse getWeeklyHoroscope(year, week, zodiacSign)

Get Weekly Horoscope Report

Retrieve weekly horoscope report for a specific zodiac sign and week.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.HoroscopeApi();
let year = "year_example"; // String | 
let week = "week_example"; // String | 
let zodiacSign = "zodiacSign_example"; // String | 
apiInstance.getWeeklyHoroscope(year, week, zodiacSign).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **year** | **String**|  | 
 **week** | **String**|  | 
 **zodiacSign** | **String**|  | 

### Return type

[**HoroscopeReportResponse**](HoroscopeReportResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## getYearlyAscendantHoroscope

> HoroscopeReportResponse getYearlyAscendantHoroscope(year, zodiacSign)

Get Yearly Ascendant Horoscope Report

Retrieve yearly horoscope report for a specific ascendant sign and year.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.HoroscopeApi();
let year = "year_example"; // String | 
let zodiacSign = "zodiacSign_example"; // String | 
apiInstance.getYearlyAscendantHoroscope(year, zodiacSign).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **year** | **String**|  | 
 **zodiacSign** | **String**|  | 

### Return type

[**HoroscopeReportResponse**](HoroscopeReportResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## getYearlyHoroscope

> HoroscopeReportResponse getYearlyHoroscope(year, zodiacSign)

Get Yearly Horoscope Report

Retrieve yearly horoscope report for a specific zodiac sign and year.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.HoroscopeApi();
let year = "year_example"; // String | 
let zodiacSign = "zodiacSign_example"; // String | 
apiInstance.getYearlyHoroscope(year, zodiacSign).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **year** | **String**|  | 
 **zodiacSign** | **String**|  | 

### Return type

[**HoroscopeReportResponse**](HoroscopeReportResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json

