# AstroApi.ModulesApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getApiModules**](ModulesApi.md#getApiModules) | **GET** /api/modules | List Modules
[**getApiModulesCheckModuleId**](ModulesApi.md#getApiModulesCheckModuleId) | **GET** /api/modules/check/{moduleId} | Check Module Access
[**getApiModulesOrganization**](ModulesApi.md#getApiModulesOrganization) | **GET** /api/modules/organization | Organization Modules
[**getApiModulesPlans**](ModulesApi.md#getApiModulesPlans) | **GET** /api/modules/plans | Subscription Plans



## getApiModules

> GetApiModules200Response getApiModules()

List Modules

Get all available modules with pricing information.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ModulesApi();
apiInstance.getApiModules().then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiModules200Response**](GetApiModules200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getApiModulesCheckModuleId

> ModuleAccessCheck getApiModulesCheckModuleId(moduleId)

Check Module Access

Check if the current organization has access to a specific module.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ModulesApi();
let moduleId = "moduleId_example"; // String | 
apiInstance.getApiModulesCheckModuleId(moduleId).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **moduleId** | **String**|  | 

### Return type

[**ModuleAccessCheck**](ModuleAccessCheck.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getApiModulesOrganization

> GetApiModulesOrganization200Response getApiModulesOrganization()

Organization Modules

Get the list of modules the current organization has access to.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ModulesApi();
apiInstance.getApiModulesOrganization().then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiModulesOrganization200Response**](GetApiModulesOrganization200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getApiModulesPlans

> GetApiModulesPlans200Response getApiModulesPlans()

Subscription Plans

Get all available subscription plans with included modules and pricing.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.ModulesApi();
apiInstance.getApiModulesPlans().then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiModulesPlans200Response**](GetApiModulesPlans200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

