# AstroApi.NumerologyApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**postApiNumerologyBirthday**](NumerologyApi.md#postApiNumerologyBirthday) | **POST** /api/numerology/birthday | Birthday Number
[**postApiNumerologyCompatibility**](NumerologyApi.md#postApiNumerologyCompatibility) | **POST** /api/numerology/compatibility | Numerology Compatibility
[**postApiNumerologyExpression**](NumerologyApi.md#postApiNumerologyExpression) | **POST** /api/numerology/expression | Expression Number
[**postApiNumerologyLifePath**](NumerologyApi.md#postApiNumerologyLifePath) | **POST** /api/numerology/life-path | Life Path Number
[**postApiNumerologyPersonalCycles**](NumerologyApi.md#postApiNumerologyPersonalCycles) | **POST** /api/numerology/personal-cycles | Personal Cycles
[**postApiNumerologyPersonality**](NumerologyApi.md#postApiNumerologyPersonality) | **POST** /api/numerology/personality | Personality Number
[**postApiNumerologyProfile**](NumerologyApi.md#postApiNumerologyProfile) | **POST** /api/numerology/profile | Full Numerology Profile
[**postApiNumerologySoulUrge**](NumerologyApi.md#postApiNumerologySoulUrge) | **POST** /api/numerology/soul-urge | Soul Urge Number



## postApiNumerologyBirthday

> NumerologyBirthdayResponse postApiNumerologyBirthday(opts)

Birthday Number

Calculate the Birthday Number from the day of birth. This number represents a special talent you possess.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.NumerologyApi();
let opts = {
  'numerologyBirthdayRequest': new AstroApi.NumerologyBirthdayRequest() // NumerologyBirthdayRequest | 
};
apiInstance.postApiNumerologyBirthday(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerologyBirthdayRequest** | [**NumerologyBirthdayRequest**](NumerologyBirthdayRequest.md)|  | [optional] 

### Return type

[**NumerologyBirthdayResponse**](NumerologyBirthdayResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiNumerologyCompatibility

> NumerologyCompatibilityResponse postApiNumerologyCompatibility(opts)

Numerology Compatibility

Calculate compatibility between two people based on their Life Path numbers.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.NumerologyApi();
let opts = {
  'numerologyCompatibilityRequest': new AstroApi.NumerologyCompatibilityRequest() // NumerologyCompatibilityRequest | 
};
apiInstance.postApiNumerologyCompatibility(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerologyCompatibilityRequest** | [**NumerologyCompatibilityRequest**](NumerologyCompatibilityRequest.md)|  | [optional] 

### Return type

[**NumerologyCompatibilityResponse**](NumerologyCompatibilityResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiNumerologyExpression

> NumerologyExpressionResponse postApiNumerologyExpression(opts)

Expression Number

Calculate the Expression (Destiny) Number from full name. This number reveals your natural talents and abilities.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.NumerologyApi();
let opts = {
  'numerologyExpressionRequest': new AstroApi.NumerologyExpressionRequest() // NumerologyExpressionRequest | 
};
apiInstance.postApiNumerologyExpression(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerologyExpressionRequest** | [**NumerologyExpressionRequest**](NumerologyExpressionRequest.md)|  | [optional] 

### Return type

[**NumerologyExpressionResponse**](NumerologyExpressionResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiNumerologyLifePath

> NumerologyLifePathResponse postApiNumerologyLifePath(opts)

Life Path Number

Calculate the Life Path Number from birth date. This is the most important number in numerology, representing your life&#39;s purpose.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.NumerologyApi();
let opts = {
  'numerologyLifePathRequest': new AstroApi.NumerologyLifePathRequest() // NumerologyLifePathRequest | 
};
apiInstance.postApiNumerologyLifePath(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerologyLifePathRequest** | [**NumerologyLifePathRequest**](NumerologyLifePathRequest.md)|  | [optional] 

### Return type

[**NumerologyLifePathResponse**](NumerologyLifePathResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiNumerologyPersonalCycles

> NumerologyPersonalCyclesResponse postApiNumerologyPersonalCycles(opts)

Personal Cycles

Calculate Personal Year, Month, and Day numbers. These reveal the current energetic influences in your life.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.NumerologyApi();
let opts = {
  'numerologyPersonalCyclesRequest': new AstroApi.NumerologyPersonalCyclesRequest() // NumerologyPersonalCyclesRequest | 
};
apiInstance.postApiNumerologyPersonalCycles(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerologyPersonalCyclesRequest** | [**NumerologyPersonalCyclesRequest**](NumerologyPersonalCyclesRequest.md)|  | [optional] 

### Return type

[**NumerologyPersonalCyclesResponse**](NumerologyPersonalCyclesResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiNumerologyPersonality

> NumerologyPersonalityResponse postApiNumerologyPersonality(opts)

Personality Number

Calculate the Personality Number from consonants in the name. This number reveals how others perceive you.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.NumerologyApi();
let opts = {
  'numerologyPersonalityRequest': new AstroApi.NumerologyPersonalityRequest() // NumerologyPersonalityRequest | 
};
apiInstance.postApiNumerologyPersonality(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerologyPersonalityRequest** | [**NumerologyPersonalityRequest**](NumerologyPersonalityRequest.md)|  | [optional] 

### Return type

[**NumerologyPersonalityResponse**](NumerologyPersonalityResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiNumerologyProfile

> NumerologyProfileResponse postApiNumerologyProfile(opts)

Full Numerology Profile

Calculate a complete numerology profile including Life Path, Expression, Soul Urge, Personality, Birthday numbers, Personal Cycles, and identify Master/Karmic numbers.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.NumerologyApi();
let opts = {
  'numerologyProfileRequest': new AstroApi.NumerologyProfileRequest() // NumerologyProfileRequest | 
};
apiInstance.postApiNumerologyProfile(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerologyProfileRequest** | [**NumerologyProfileRequest**](NumerologyProfileRequest.md)|  | [optional] 

### Return type

[**NumerologyProfileResponse**](NumerologyProfileResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiNumerologySoulUrge

> NumerologySoulUrgeResponse postApiNumerologySoulUrge(opts)

Soul Urge Number

Calculate the Soul Urge (Heart&#39;s Desire) Number from vowels in the name. This number reveals your inner motivations.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.NumerologyApi();
let opts = {
  'numerologySoulUrgeRequest': new AstroApi.NumerologySoulUrgeRequest() // NumerologySoulUrgeRequest | 
};
apiInstance.postApiNumerologySoulUrge(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerologySoulUrgeRequest** | [**NumerologySoulUrgeRequest**](NumerologySoulUrgeRequest.md)|  | [optional] 

### Return type

[**NumerologySoulUrgeResponse**](NumerologySoulUrgeResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json

