# AstroApi.OrganizationsApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteApiOrgUsersMemberId**](OrganizationsApi.md#deleteApiOrgUsersMemberId) | **DELETE** /api/org/users/{memberId} | Remove Member
[**getApiOrgUsers**](OrganizationsApi.md#getApiOrgUsers) | **GET** /api/org/users | List Members
[**patchApiOrgUsersMemberId**](OrganizationsApi.md#patchApiOrgUsersMemberId) | **PATCH** /api/org/users/{memberId} | Update Member
[**postApiOrg**](OrganizationsApi.md#postApiOrg) | **POST** /api/org | Create Organization
[**postApiOrgUsers**](OrganizationsApi.md#postApiOrgUsers) | **POST** /api/org/users | Add Member



## deleteApiOrgUsersMemberId

> deleteApiOrgUsersMemberId(memberId)

Remove Member

Remove a member from the organization.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.OrganizationsApi();
let memberId = "memberId_example"; // String | 
apiInstance.deleteApiOrgUsersMemberId(memberId).then(() => {
  console.log('API called successfully.');
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **memberId** | **String**|  | 

### Return type

null (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getApiOrgUsers

> GetApiOrgUsers200Response getApiOrgUsers()

List Members

Get a paginated list of organization members.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.OrganizationsApi();
apiInstance.getApiOrgUsers().then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiOrgUsers200Response**](GetApiOrgUsers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## patchApiOrgUsersMemberId

> PatchApiOrgUsersMemberId200Response patchApiOrgUsersMemberId(memberId, opts)

Update Member

Update an organization member&#39;s role.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.OrganizationsApi();
let memberId = "memberId_example"; // String | 
let opts = {
  'patchApiOrgUsersMemberIdRequest': new AstroApi.PatchApiOrgUsersMemberIdRequest() // PatchApiOrgUsersMemberIdRequest | 
};
apiInstance.patchApiOrgUsersMemberId(memberId, opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **memberId** | **String**|  | 
 **patchApiOrgUsersMemberIdRequest** | [**PatchApiOrgUsersMemberIdRequest**](PatchApiOrgUsersMemberIdRequest.md)|  | [optional] 

### Return type

[**PatchApiOrgUsersMemberId200Response**](PatchApiOrgUsersMemberId200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json


## postApiOrg

> Object postApiOrg()

Create Organization

Create a new organization with Stripe billing setup.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.OrganizationsApi();
apiInstance.postApiOrg().then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters

This endpoint does not need any parameter.

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/vnd.api+json


## postApiOrgUsers

> PostApiOrgUsers201Response postApiOrgUsers(opts)

Add Member

Add or invite a new member to the organization.

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.OrganizationsApi();
let opts = {
  'postApiOrgUsersRequest': new AstroApi.PostApiOrgUsersRequest() // PostApiOrgUsersRequest | 
};
apiInstance.postApiOrgUsers(opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **postApiOrgUsersRequest** | [**PostApiOrgUsersRequest**](PostApiOrgUsersRequest.md)|  | [optional] 

### Return type

[**PostApiOrgUsers201Response**](PostApiOrgUsers201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/vnd.api+json

