# AstroApi.WidgetApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getWidgetConfig**](WidgetApi.md#getWidgetConfig) | **GET** /widget/config/{chatbotId} | Get Widget Configuration
[**widgetChat**](WidgetApi.md#widgetChat) | **POST** /widget/chat/{chatbotId} | Widget Chat
[**widgetChatWithUser**](WidgetApi.md#widgetChatWithUser) | **POST** /widget/chat/{chatbotId}/user/{externalUserId} | Widget Chat with User Profile



## getWidgetConfig

> getWidgetConfig(chatbotId)

Get Widget Configuration

Get the widget configuration for embedding

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.WidgetApi();
let chatbotId = "chatbotId_example"; // String | 
apiInstance.getWidgetConfig(chatbotId).then(() => {
  console.log('API called successfully.');
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbotId** | **String**|  | 

### Return type

null (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## widgetChat

> Object widgetChat(chatbotId, opts)

Widget Chat

Send a message via widget (SSE streaming response)

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.WidgetApi();
let chatbotId = "chatbotId_example"; // String | 
let opts = {
  'widgetChatRequest': new AstroApi.WidgetChatRequest() // WidgetChatRequest | 
};
apiInstance.widgetChat(chatbotId, opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbotId** | **String**|  | 
 **widgetChatRequest** | [**WidgetChatRequest**](WidgetChatRequest.md)|  | [optional] 

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: text/event-stream


## widgetChatWithUser

> Object widgetChatWithUser(chatbotId, externalUserId, opts)

Widget Chat with User Profile

Chat using an external user ID (creates profile on first use)

### Example

```javascript
import AstroApi from 'astro_api';
let defaultClient = AstroApi.ApiClient.instance;
// Configure API key authorization: ApiKeyAuth
let ApiKeyAuth = defaultClient.authentications['ApiKeyAuth'];
ApiKeyAuth.apiKey = 'YOUR API KEY';
// Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
//ApiKeyAuth.apiKeyPrefix = 'Token';

let apiInstance = new AstroApi.WidgetApi();
let chatbotId = "chatbotId_example"; // String | 
let externalUserId = "externalUserId_example"; // String | 
let opts = {
  'widgetChatWithUserRequest': new AstroApi.WidgetChatWithUserRequest() // WidgetChatWithUserRequest | 
};
apiInstance.widgetChatWithUser(chatbotId, externalUserId, opts).then((data) => {
  console.log('API called successfully. Returned data: ' + data);
}, (error) => {
  console.error(error);
});

```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbotId** | **String**|  | 
 **externalUserId** | **String**|  | 
 **widgetChatWithUserRequest** | [**WidgetChatWithUserRequest**](WidgetChatWithUserRequest.md)|  | [optional] 

### Return type

**Object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: text/event-stream

