/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import ApiKeyOptions from '../model/ApiKeyOptions';
import CreateApiKeyRequest from '../model/CreateApiKeyRequest';
import GetApiApiKeys200Response from '../model/GetApiApiKeys200Response';
import GetApiKey200Response from '../model/GetApiKey200Response';
import PostApiApiKeys201Response from '../model/PostApiApiKeys201Response';
import UpdateApiKeyRequest from '../model/UpdateApiKeyRequest';

/**
* APIKeys service.
* @module api/APIKeysApi
* @version 25.12.4
*/
export default class APIKeysApi {

    /**
    * Constructs a new APIKeysApi. 
    * @alias module:api/APIKeysApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }



    /**
     * Delete API Key
     * Permanently delete an API key.
     * @param {String} id 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing HTTP response
     */
    deleteApiKeyWithHttpInfo(id) {
      let postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling deleteApiKey");
      }

      let pathParams = {
        'id': id
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/api-keys/{id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Delete API Key
     * Permanently delete an API key.
     * @param {String} id 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}
     */
    deleteApiKey(id) {
      return this.deleteApiKeyWithHttpInfo(id)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * List API Keys
     * Get all API keys owned by the current user.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/GetApiApiKeys200Response} and HTTP response
     */
    getApiApiKeysWithHttpInfo() {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = GetApiApiKeys200Response;
      return this.apiClient.callApi(
        '/api/api-keys', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * List API Keys
     * Get all API keys owned by the current user.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/GetApiApiKeys200Response}
     */
    getApiApiKeys() {
      return this.getApiApiKeysWithHttpInfo()
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Available Options
     * Get available permissions and modules for configuring API keys.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/ApiKeyOptions} and HTTP response
     */
    getApiApiKeysAvailableOptionsWithHttpInfo() {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ApiKeyOptions;
      return this.apiClient.callApi(
        '/api/api-keys/available-options', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Available Options
     * Get available permissions and modules for configuring API keys.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/ApiKeyOptions}
     */
    getApiApiKeysAvailableOptions() {
      return this.getApiApiKeysAvailableOptionsWithHttpInfo()
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Get API Key
     * Get details of a specific API key.
     * @param {String} id 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/GetApiKey200Response} and HTTP response
     */
    getApiKeyWithHttpInfo(id) {
      let postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling getApiKey");
      }

      let pathParams = {
        'id': id
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = GetApiKey200Response;
      return this.apiClient.callApi(
        '/api/api-keys/{id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Get API Key
     * Get details of a specific API key.
     * @param {String} id 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/GetApiKey200Response}
     */
    getApiKey(id) {
      return this.getApiKeyWithHttpInfo(id)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Create API Key
     * Create a new API key with optional permission and module restrictions.
     * @param {Object} opts Optional parameters
     * @param {module:model/CreateApiKeyRequest} [createApiKeyRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/PostApiApiKeys201Response} and HTTP response
     */
    postApiApiKeysWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['createApiKeyRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = PostApiApiKeys201Response;
      return this.apiClient.callApi(
        '/api/api-keys', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Create API Key
     * Create a new API key with optional permission and module restrictions.
     * @param {Object} opts Optional parameters
     * @param {module:model/CreateApiKeyRequest} opts.createApiKeyRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/PostApiApiKeys201Response}
     */
    postApiApiKeys(opts) {
      return this.postApiApiKeysWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Update API Key
     * Update an API key's name, status, permissions, or modules.
     * @param {String} id 
     * @param {Object} opts Optional parameters
     * @param {module:model/UpdateApiKeyRequest} [updateApiKeyRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/GetApiKey200Response} and HTTP response
     */
    updateApiKeyWithHttpInfo(id, opts) {
      opts = opts || {};
      let postBody = opts['updateApiKeyRequest'];
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling updateApiKey");
      }

      let pathParams = {
        'id': id
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = GetApiKey200Response;
      return this.apiClient.callApi(
        '/api/api-keys/{id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Update API Key
     * Update an API key's name, status, permissions, or modules.
     * @param {String} id 
     * @param {Object} opts Optional parameters
     * @param {module:model/UpdateApiKeyRequest} opts.updateApiKeyRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/GetApiKey200Response}
     */
    updateApiKey(id, opts) {
      return this.updateApiKeyWithHttpInfo(id, opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


}
