/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import ChineseForecastRequest from '../model/ChineseForecastRequest';
import ChineseForecastResponse from '../model/ChineseForecastResponse';
import ChineseHoroscopeRequest from '../model/ChineseHoroscopeRequest';
import ChineseHoroscopeResponse from '../model/ChineseHoroscopeResponse';
import CompatibilityRequest from '../model/CompatibilityRequest';
import CompatibilityResponse from '../model/CompatibilityResponse';
import CompositeRequest from '../model/CompositeRequest';
import CompositeResponse from '../model/CompositeResponse';
import LunarReturnRequest from '../model/LunarReturnRequest';
import LunarReturnResponse from '../model/LunarReturnResponse';
import MoonSunRequest from '../model/MoonSunRequest';
import MoonSunResponse from '../model/MoonSunResponse';
import NatalRequest from '../model/NatalRequest';
import NatalResponse from '../model/NatalResponse';
import ProgressionsRequest from '../model/ProgressionsRequest';
import ProgressionsResponse from '../model/ProgressionsResponse';
import SolarReturnRequest from '../model/SolarReturnRequest';
import SolarReturnResponse from '../model/SolarReturnResponse';
import SynastryRequest from '../model/SynastryRequest';
import SynastryResponse from '../model/SynastryResponse';
import TransitRequest from '../model/TransitRequest';
import TransitResponse from '../model/TransitResponse';

/**
* Calculations service.
* @module api/CalculationsApi
* @version 25.12.4
*/
export default class CalculationsApi {

    /**
    * Constructs a new CalculationsApi. 
    * @alias module:api/CalculationsApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }



    /**
     * Chinese Zodiac Forecast
     * Get Chinese zodiac forecast for a specific year with category breakdowns.
     * @param {Object} opts Optional parameters
     * @param {module:model/ChineseForecastRequest} [chineseForecastRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/ChineseForecastResponse} and HTTP response
     */
    postApiCalcChineseForecastWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['chineseForecastRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = ChineseForecastResponse;
      return this.apiClient.callApi(
        '/api/calc/chinese-forecast', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Chinese Zodiac Forecast
     * Get Chinese zodiac forecast for a specific year with category breakdowns.
     * @param {Object} opts Optional parameters
     * @param {module:model/ChineseForecastRequest} opts.chineseForecastRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/ChineseForecastResponse}
     */
    postApiCalcChineseForecast(opts) {
      return this.postApiCalcChineseForecastWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Chinese Zodiac Sign
     * Calculate the Chinese zodiac sign and element based on birth year.
     * @param {Object} opts Optional parameters
     * @param {module:model/ChineseHoroscopeRequest} [chineseHoroscopeRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/ChineseHoroscopeResponse} and HTTP response
     */
    postApiCalcChineseHoroscopeWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['chineseHoroscopeRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = ChineseHoroscopeResponse;
      return this.apiClient.callApi(
        '/api/calc/chinese-horoscope', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Chinese Zodiac Sign
     * Calculate the Chinese zodiac sign and element based on birth year.
     * @param {Object} opts Optional parameters
     * @param {module:model/ChineseHoroscopeRequest} opts.chineseHoroscopeRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/ChineseHoroscopeResponse}
     */
    postApiCalcChineseHoroscope(opts) {
      return this.postApiCalcChineseHoroscopeWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Compatibility Analysis
     * Calculate sun sign compatibility between two people with interpretation text.
     * @param {Object} opts Optional parameters
     * @param {module:model/CompatibilityRequest} [compatibilityRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/CompatibilityResponse} and HTTP response
     */
    postApiCalcCompatibilityWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['compatibilityRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = CompatibilityResponse;
      return this.apiClient.callApi(
        '/api/calc/compatibility', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Compatibility Analysis
     * Calculate sun sign compatibility between two people with interpretation text.
     * @param {Object} opts Optional parameters
     * @param {module:model/CompatibilityRequest} opts.compatibilityRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/CompatibilityResponse}
     */
    postApiCalcCompatibility(opts) {
      return this.postApiCalcCompatibilityWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Composite Chart
     * Calculate a composite chart by combining midpoints of two birth charts.
     * @param {Object} opts Optional parameters
     * @param {module:model/CompositeRequest} [compositeRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/CompositeResponse} and HTTP response
     */
    postApiCalcCompositeWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['compositeRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = CompositeResponse;
      return this.apiClient.callApi(
        '/api/calc/composite', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Composite Chart
     * Calculate a composite chart by combining midpoints of two birth charts.
     * @param {Object} opts Optional parameters
     * @param {module:model/CompositeRequest} opts.compositeRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/CompositeResponse}
     */
    postApiCalcComposite(opts) {
      return this.postApiCalcCompositeWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Lunar Return
     * Calculate the lunar return chart when the Moon returns to its natal position.
     * @param {Object} opts Optional parameters
     * @param {module:model/LunarReturnRequest} [lunarReturnRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/LunarReturnResponse} and HTTP response
     */
    postApiCalcLunarReturnWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['lunarReturnRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = LunarReturnResponse;
      return this.apiClient.callApi(
        '/api/calc/lunar-return', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Lunar Return
     * Calculate the lunar return chart when the Moon returns to its natal position.
     * @param {Object} opts Optional parameters
     * @param {module:model/LunarReturnRequest} opts.lunarReturnRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/LunarReturnResponse}
     */
    postApiCalcLunarReturn(opts) {
      return this.postApiCalcLunarReturnWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Moon & Sun Info
     * Get Moon and Sun information for a specific place and time. Includes moon phase, illumination, distance, and sun rise/set/twilight times.
     * @param {Object} opts Optional parameters
     * @param {module:model/MoonSunRequest} [moonSunRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/MoonSunResponse} and HTTP response
     */
    postApiCalcMoonSunWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['moonSunRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = MoonSunResponse;
      return this.apiClient.callApi(
        '/api/calc/moon-sun', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Moon & Sun Info
     * Get Moon and Sun information for a specific place and time. Includes moon phase, illumination, distance, and sun rise/set/twilight times.
     * @param {Object} opts Optional parameters
     * @param {module:model/MoonSunRequest} opts.moonSunRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/MoonSunResponse}
     */
    postApiCalcMoonSun(opts) {
      return this.postApiCalcMoonSunWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Natal Chart
     * Calculate a natal (birth) chart with planetary positions, house cusps, and aspects.
     * @param {Object} opts Optional parameters
     * @param {module:model/NatalRequest} [natalRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/NatalResponse} and HTTP response
     */
    postApiCalcNatalWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['natalRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = NatalResponse;
      return this.apiClient.callApi(
        '/api/calc/natal', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Natal Chart
     * Calculate a natal (birth) chart with planetary positions, house cusps, and aspects.
     * @param {Object} opts Optional parameters
     * @param {module:model/NatalRequest} opts.natalRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/NatalResponse}
     */
    postApiCalcNatal(opts) {
      return this.postApiCalcNatalWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Secondary Progressions
     * Calculate secondary progressions chart using the day-for-a-year method. Returns progressed planet positions and aspects to both progressed and natal planets.
     * @param {Object} opts Optional parameters
     * @param {module:model/ProgressionsRequest} [progressionsRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/ProgressionsResponse} and HTTP response
     */
    postApiCalcProgressionsWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['progressionsRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = ProgressionsResponse;
      return this.apiClient.callApi(
        '/api/calc/progressions', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Secondary Progressions
     * Calculate secondary progressions chart using the day-for-a-year method. Returns progressed planet positions and aspects to both progressed and natal planets.
     * @param {Object} opts Optional parameters
     * @param {module:model/ProgressionsRequest} opts.progressionsRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/ProgressionsResponse}
     */
    postApiCalcProgressions(opts) {
      return this.postApiCalcProgressionsWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Solar Return
     * Calculate the solar return chart for a specific year (birthday chart).
     * @param {Object} opts Optional parameters
     * @param {module:model/SolarReturnRequest} [solarReturnRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/SolarReturnResponse} and HTTP response
     */
    postApiCalcSolarReturnWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['solarReturnRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = SolarReturnResponse;
      return this.apiClient.callApi(
        '/api/calc/solar-return', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Solar Return
     * Calculate the solar return chart for a specific year (birthday chart).
     * @param {Object} opts Optional parameters
     * @param {module:model/SolarReturnRequest} opts.solarReturnRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/SolarReturnResponse}
     */
    postApiCalcSolarReturn(opts) {
      return this.postApiCalcSolarReturnWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Synastry Chart
     * Calculate synastry aspects between two birth charts for relationship analysis.
     * @param {Object} opts Optional parameters
     * @param {module:model/SynastryRequest} [synastryRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/SynastryResponse} and HTTP response
     */
    postApiCalcSynastryWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['synastryRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = SynastryResponse;
      return this.apiClient.callApi(
        '/api/calc/synastry', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Synastry Chart
     * Calculate synastry aspects between two birth charts for relationship analysis.
     * @param {Object} opts Optional parameters
     * @param {module:model/SynastryRequest} opts.synastryRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/SynastryResponse}
     */
    postApiCalcSynastry(opts) {
      return this.postApiCalcSynastryWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Transit Chart
     * Calculate planetary transits over a natal chart for a specified time period.
     * @param {Object} opts Optional parameters
     * @param {module:model/TransitRequest} [transitRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/TransitResponse} and HTTP response
     */
    postApiCalcTransitWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['transitRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = TransitResponse;
      return this.apiClient.callApi(
        '/api/calc/transit', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Transit Chart
     * Calculate planetary transits over a natal chart for a specified time period.
     * @param {Object} opts Optional parameters
     * @param {module:model/TransitRequest} opts.transitRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/TransitResponse}
     */
    postApiCalcTransit(opts) {
      return this.postApiCalcTransitWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


}
