/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import ChatDirectRequest from '../model/ChatDirectRequest';
import ChatRequest from '../model/ChatRequest';

/**
* Chat service.
* @module api/ChatApi
* @version 25.12.4
*/
export default class ChatApi {

    /**
    * Constructs a new ChatApi. 
    * @alias module:api/ChatApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }



    /**
     * Chat with Chatbot
     * Send a message to a chatbot and receive a streaming response via SSE
     * @param {String} chatbotId 
     * @param {Object} opts Optional parameters
     * @param {module:model/ChatRequest} [chatRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link Object} and HTTP response
     */
    chatWithHttpInfo(chatbotId, opts) {
      opts = opts || {};
      let postBody = opts['chatRequest'];
      // verify the required parameter 'chatbotId' is set
      if (chatbotId === undefined || chatbotId === null) {
        throw new Error("Missing the required parameter 'chatbotId' when calling chat");
      }

      let pathParams = {
        'chatbotId': chatbotId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['text/event-stream'];
      let returnType = Object;
      return this.apiClient.callApi(
        '/api/chat/{chatbotId}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Chat with Chatbot
     * Send a message to a chatbot and receive a streaming response via SSE
     * @param {String} chatbotId 
     * @param {Object} opts Optional parameters
     * @param {module:model/ChatRequest} opts.chatRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link Object}
     */
    chat(chatbotId, opts) {
      return this.chatWithHttpInfo(chatbotId, opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Chat with Birth Data
     * Send a message with inline birth data (no profile needed)
     * @param {String} chatbotId 
     * @param {Object} opts Optional parameters
     * @param {module:model/ChatDirectRequest} [chatDirectRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link Object} and HTTP response
     */
    chatDirectWithHttpInfo(chatbotId, opts) {
      opts = opts || {};
      let postBody = opts['chatDirectRequest'];
      // verify the required parameter 'chatbotId' is set
      if (chatbotId === undefined || chatbotId === null) {
        throw new Error("Missing the required parameter 'chatbotId' when calling chatDirect");
      }

      let pathParams = {
        'chatbotId': chatbotId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['text/event-stream'];
      let returnType = Object;
      return this.apiClient.callApi(
        '/api/chat/{chatbotId}/direct', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Chat with Birth Data
     * Send a message with inline birth data (no profile needed)
     * @param {String} chatbotId 
     * @param {Object} opts Optional parameters
     * @param {module:model/ChatDirectRequest} opts.chatDirectRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link Object}
     */
    chatDirect(chatbotId, opts) {
      return this.chatDirectWithHttpInfo(chatbotId, opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Chat with Profile
     * Send a message using a pre-configured user profile
     * @param {String} chatbotId 
     * @param {String} profileId 
     * @param {Object} opts Optional parameters
     * @param {module:model/ChatRequest} [chatRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link Object} and HTTP response
     */
    chatWithProfileWithHttpInfo(chatbotId, profileId, opts) {
      opts = opts || {};
      let postBody = opts['chatRequest'];
      // verify the required parameter 'chatbotId' is set
      if (chatbotId === undefined || chatbotId === null) {
        throw new Error("Missing the required parameter 'chatbotId' when calling chatWithProfile");
      }
      // verify the required parameter 'profileId' is set
      if (profileId === undefined || profileId === null) {
        throw new Error("Missing the required parameter 'profileId' when calling chatWithProfile");
      }

      let pathParams = {
        'chatbotId': chatbotId,
        'profileId': profileId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['text/event-stream'];
      let returnType = Object;
      return this.apiClient.callApi(
        '/api/chat/{chatbotId}/profile/{profileId}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Chat with Profile
     * Send a message using a pre-configured user profile
     * @param {String} chatbotId 
     * @param {String} profileId 
     * @param {Object} opts Optional parameters
     * @param {module:model/ChatRequest} opts.chatRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link Object}
     */
    chatWithProfile(chatbotId, profileId, opts) {
      return this.chatWithProfileWithHttpInfo(chatbotId, profileId, opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Delete Conversation
     * Delete a conversation and its history
     * @param {String} chatbotId 
     * @param {String} conversationId 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing HTTP response
     */
    deleteConversationWithHttpInfo(chatbotId, conversationId) {
      let postBody = null;
      // verify the required parameter 'chatbotId' is set
      if (chatbotId === undefined || chatbotId === null) {
        throw new Error("Missing the required parameter 'chatbotId' when calling deleteConversation");
      }
      // verify the required parameter 'conversationId' is set
      if (conversationId === undefined || conversationId === null) {
        throw new Error("Missing the required parameter 'conversationId' when calling deleteConversation");
      }

      let pathParams = {
        'chatbotId': chatbotId,
        'conversationId': conversationId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/chat/{chatbotId}/conversation/{conversationId}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Delete Conversation
     * Delete a conversation and its history
     * @param {String} chatbotId 
     * @param {String} conversationId 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}
     */
    deleteConversation(chatbotId, conversationId) {
      return this.deleteConversationWithHttpInfo(chatbotId, conversationId)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Get Conversation
     * Retrieve conversation history
     * @param {String} chatbotId 
     * @param {String} conversationId 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing HTTP response
     */
    getConversationWithHttpInfo(chatbotId, conversationId) {
      let postBody = null;
      // verify the required parameter 'chatbotId' is set
      if (chatbotId === undefined || chatbotId === null) {
        throw new Error("Missing the required parameter 'chatbotId' when calling getConversation");
      }
      // verify the required parameter 'conversationId' is set
      if (conversationId === undefined || conversationId === null) {
        throw new Error("Missing the required parameter 'conversationId' when calling getConversation");
      }

      let pathParams = {
        'chatbotId': chatbotId,
        'conversationId': conversationId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/chat/{chatbotId}/conversation/{conversationId}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Get Conversation
     * Retrieve conversation history
     * @param {String} chatbotId 
     * @param {String} conversationId 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}
     */
    getConversation(chatbotId, conversationId) {
      return this.getConversationWithHttpInfo(chatbotId, conversationId)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


}
