/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import ContentResponse from '../model/ContentResponse';

/**
* Content service.
* @module api/ContentApi
* @version 25.12.4
*/
export default class ContentApi {

    /**
    * Constructs a new ContentApi. 
    * @alias module:api/ContentApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }



    /**
     * Create Content
     * Create a new content item for a specific horoscope and content type.
     * @param {String} horoscopeType 
     * @param {String} contentType 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/ContentResponse} and HTTP response
     */
    createContentWithHttpInfo(horoscopeType, contentType) {
      let postBody = null;
      // verify the required parameter 'horoscopeType' is set
      if (horoscopeType === undefined || horoscopeType === null) {
        throw new Error("Missing the required parameter 'horoscopeType' when calling createContent");
      }
      // verify the required parameter 'contentType' is set
      if (contentType === undefined || contentType === null) {
        throw new Error("Missing the required parameter 'contentType' when calling createContent");
      }

      let pathParams = {
        'horoscopeType': horoscopeType,
        'contentType': contentType
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/vnd.api+json'];
      let returnType = ContentResponse;
      return this.apiClient.callApi(
        '/api/content/{horoscopeType}/{contentType}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Create Content
     * Create a new content item for a specific horoscope and content type.
     * @param {String} horoscopeType 
     * @param {String} contentType 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/ContentResponse}
     */
    createContent(horoscopeType, contentType) {
      return this.createContentWithHttpInfo(horoscopeType, contentType)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Create Custom Copy
     * Create an organization-specific copy of system content for customization.
     * @param {String} id 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/ContentResponse} and HTTP response
     */
    createContentCustomCopyWithHttpInfo(id) {
      let postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling createContentCustomCopy");
      }

      let pathParams = {
        'id': id
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/vnd.api+json'];
      let returnType = ContentResponse;
      return this.apiClient.callApi(
        '/api/content/{id}/create-custom-copy', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Create Custom Copy
     * Create an organization-specific copy of system content for customization.
     * @param {String} id 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/ContentResponse}
     */
    createContentCustomCopy(id) {
      return this.createContentCustomCopyWithHttpInfo(id)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Delete Content
     * Delete a content item by horoscope type, content type, and ID.
     * @param {String} id 
     * @param {String} horoscopeType 
     * @param {String} contentType 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing HTTP response
     */
    deleteContentWithHttpInfo(id, horoscopeType, contentType) {
      let postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling deleteContent");
      }
      // verify the required parameter 'horoscopeType' is set
      if (horoscopeType === undefined || horoscopeType === null) {
        throw new Error("Missing the required parameter 'horoscopeType' when calling deleteContent");
      }
      // verify the required parameter 'contentType' is set
      if (contentType === undefined || contentType === null) {
        throw new Error("Missing the required parameter 'contentType' when calling deleteContent");
      }

      let pathParams = {
        'id': id,
        'horoscopeType': horoscopeType,
        'contentType': contentType
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/content/{horoscopeType}/{contentType}/{id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Delete Content
     * Delete a content item by horoscope type, content type, and ID.
     * @param {String} id 
     * @param {String} horoscopeType 
     * @param {String} contentType 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}
     */
    deleteContent(id, horoscopeType, contentType) {
      return this.deleteContentWithHttpInfo(id, horoscopeType, contentType)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Delete Content by ID
     * Delete a content item by its ID.
     * @param {String} id 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/ContentResponse} and HTTP response
     */
    deleteContentByIdWithHttpInfo(id) {
      let postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling deleteContentById");
      }

      let pathParams = {
        'id': id
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/vnd.api+json'];
      let returnType = ContentResponse;
      return this.apiClient.callApi(
        '/api/content/{id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Delete Content by ID
     * Delete a content item by its ID.
     * @param {String} id 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/ContentResponse}
     */
    deleteContentById(id) {
      return this.deleteContentByIdWithHttpInfo(id)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Get Content
     * Retrieve a single content item by its ID.
     * @param {String} id 
     * @param {String} horoscopeType 
     * @param {String} contentType 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/ContentResponse} and HTTP response
     */
    getContentWithHttpInfo(id, horoscopeType, contentType) {
      let postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling getContent");
      }
      // verify the required parameter 'horoscopeType' is set
      if (horoscopeType === undefined || horoscopeType === null) {
        throw new Error("Missing the required parameter 'horoscopeType' when calling getContent");
      }
      // verify the required parameter 'contentType' is set
      if (contentType === undefined || contentType === null) {
        throw new Error("Missing the required parameter 'contentType' when calling getContent");
      }

      let pathParams = {
        'id': id,
        'horoscopeType': horoscopeType,
        'contentType': contentType
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/vnd.api+json'];
      let returnType = ContentResponse;
      return this.apiClient.callApi(
        '/api/content/{horoscopeType}/{contentType}/{id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Get Content
     * Retrieve a single content item by its ID.
     * @param {String} id 
     * @param {String} horoscopeType 
     * @param {String} contentType 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/ContentResponse}
     */
    getContent(id, horoscopeType, contentType) {
      return this.getContentWithHttpInfo(id, horoscopeType, contentType)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * List Content
     * Retrieve a paginated list of content items filtered by horoscope and content type.
     * @param {String} horoscopeType 
     * @param {String} contentType 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/ContentResponse} and HTTP response
     */
    listContentWithHttpInfo(horoscopeType, contentType) {
      let postBody = null;
      // verify the required parameter 'horoscopeType' is set
      if (horoscopeType === undefined || horoscopeType === null) {
        throw new Error("Missing the required parameter 'horoscopeType' when calling listContent");
      }
      // verify the required parameter 'contentType' is set
      if (contentType === undefined || contentType === null) {
        throw new Error("Missing the required parameter 'contentType' when calling listContent");
      }

      let pathParams = {
        'horoscopeType': horoscopeType,
        'contentType': contentType
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/vnd.api+json'];
      let returnType = ContentResponse;
      return this.apiClient.callApi(
        '/api/content/{horoscopeType}/{contentType}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * List Content
     * Retrieve a paginated list of content items filtered by horoscope and content type.
     * @param {String} horoscopeType 
     * @param {String} contentType 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/ContentResponse}
     */
    listContent(horoscopeType, contentType) {
      return this.listContentWithHttpInfo(horoscopeType, contentType)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Restore Content
     * Restore custom content to match the original system content.
     * @param {String} id 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/ContentResponse} and HTTP response
     */
    restoreContentWithHttpInfo(id) {
      let postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling restoreContent");
      }

      let pathParams = {
        'id': id
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/vnd.api+json'];
      let returnType = ContentResponse;
      return this.apiClient.callApi(
        '/api/content/{id}/restore', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Restore Content
     * Restore custom content to match the original system content.
     * @param {String} id 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/ContentResponse}
     */
    restoreContent(id) {
      return this.restoreContentWithHttpInfo(id)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


}
