/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import DailyHoroscopeResponse from '../model/DailyHoroscopeResponse';
import HoroscopeReportResponse from '../model/HoroscopeReportResponse';

/**
* Horoscope service.
* @module api/HoroscopeApi
* @version 25.12.4
*/
export default class HoroscopeApi {

    /**
    * Constructs a new HoroscopeApi. 
    * @alias module:api/HoroscopeApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }



    /**
     * Get Daily Horoscopes
     * Retrieve daily horoscopes for all zodiac signs for a specific date.
     * @param {String} date 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/DailyHoroscopeResponse} and HTTP response
     */
    getDailyHoroscopesWithHttpInfo(date) {
      let postBody = null;
      // verify the required parameter 'date' is set
      if (date === undefined || date === null) {
        throw new Error("Missing the required parameter 'date' when calling getDailyHoroscopes");
      }

      let pathParams = {
        'date': date
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/vnd.api+json'];
      let returnType = DailyHoroscopeResponse;
      return this.apiClient.callApi(
        '/api/horoscope/daily/{date}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Get Daily Horoscopes
     * Retrieve daily horoscopes for all zodiac signs for a specific date.
     * @param {String} date 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/DailyHoroscopeResponse}
     */
    getDailyHoroscopes(date) {
      return this.getDailyHoroscopesWithHttpInfo(date)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Get Weekly Horoscope Report
     * Retrieve weekly horoscope report for a specific zodiac sign and week.
     * @param {String} year 
     * @param {String} week 
     * @param {String} zodiacSign 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/HoroscopeReportResponse} and HTTP response
     */
    getWeeklyHoroscopeWithHttpInfo(year, week, zodiacSign) {
      let postBody = null;
      // verify the required parameter 'year' is set
      if (year === undefined || year === null) {
        throw new Error("Missing the required parameter 'year' when calling getWeeklyHoroscope");
      }
      // verify the required parameter 'week' is set
      if (week === undefined || week === null) {
        throw new Error("Missing the required parameter 'week' when calling getWeeklyHoroscope");
      }
      // verify the required parameter 'zodiacSign' is set
      if (zodiacSign === undefined || zodiacSign === null) {
        throw new Error("Missing the required parameter 'zodiacSign' when calling getWeeklyHoroscope");
      }

      let pathParams = {
        'year': year,
        'week': week,
        'zodiacSign': zodiacSign
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/vnd.api+json'];
      let returnType = HoroscopeReportResponse;
      return this.apiClient.callApi(
        '/api/horoscope/weekly/{year}/{week}/{zodiacSign}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Get Weekly Horoscope Report
     * Retrieve weekly horoscope report for a specific zodiac sign and week.
     * @param {String} year 
     * @param {String} week 
     * @param {String} zodiacSign 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/HoroscopeReportResponse}
     */
    getWeeklyHoroscope(year, week, zodiacSign) {
      return this.getWeeklyHoroscopeWithHttpInfo(year, week, zodiacSign)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Get Yearly Ascendant Horoscope Report
     * Retrieve yearly horoscope report for a specific ascendant sign and year.
     * @param {String} year 
     * @param {String} zodiacSign 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/HoroscopeReportResponse} and HTTP response
     */
    getYearlyAscendantHoroscopeWithHttpInfo(year, zodiacSign) {
      let postBody = null;
      // verify the required parameter 'year' is set
      if (year === undefined || year === null) {
        throw new Error("Missing the required parameter 'year' when calling getYearlyAscendantHoroscope");
      }
      // verify the required parameter 'zodiacSign' is set
      if (zodiacSign === undefined || zodiacSign === null) {
        throw new Error("Missing the required parameter 'zodiacSign' when calling getYearlyAscendantHoroscope");
      }

      let pathParams = {
        'year': year,
        'zodiacSign': zodiacSign
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/vnd.api+json'];
      let returnType = HoroscopeReportResponse;
      return this.apiClient.callApi(
        '/api/horoscope/yearly-ascendant/{year}/{zodiacSign}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Get Yearly Ascendant Horoscope Report
     * Retrieve yearly horoscope report for a specific ascendant sign and year.
     * @param {String} year 
     * @param {String} zodiacSign 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/HoroscopeReportResponse}
     */
    getYearlyAscendantHoroscope(year, zodiacSign) {
      return this.getYearlyAscendantHoroscopeWithHttpInfo(year, zodiacSign)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Get Yearly Horoscope Report
     * Retrieve yearly horoscope report for a specific zodiac sign and year.
     * @param {String} year 
     * @param {String} zodiacSign 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/HoroscopeReportResponse} and HTTP response
     */
    getYearlyHoroscopeWithHttpInfo(year, zodiacSign) {
      let postBody = null;
      // verify the required parameter 'year' is set
      if (year === undefined || year === null) {
        throw new Error("Missing the required parameter 'year' when calling getYearlyHoroscope");
      }
      // verify the required parameter 'zodiacSign' is set
      if (zodiacSign === undefined || zodiacSign === null) {
        throw new Error("Missing the required parameter 'zodiacSign' when calling getYearlyHoroscope");
      }

      let pathParams = {
        'year': year,
        'zodiacSign': zodiacSign
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/vnd.api+json'];
      let returnType = HoroscopeReportResponse;
      return this.apiClient.callApi(
        '/api/horoscope/yearly/{year}/{zodiacSign}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Get Yearly Horoscope Report
     * Retrieve yearly horoscope report for a specific zodiac sign and year.
     * @param {String} year 
     * @param {String} zodiacSign 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/HoroscopeReportResponse}
     */
    getYearlyHoroscope(year, zodiacSign) {
      return this.getYearlyHoroscopeWithHttpInfo(year, zodiacSign)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


}
