/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import GetApiModules200Response from '../model/GetApiModules200Response';
import GetApiModulesOrganization200Response from '../model/GetApiModulesOrganization200Response';
import GetApiModulesPlans200Response from '../model/GetApiModulesPlans200Response';
import ModuleAccessCheck from '../model/ModuleAccessCheck';

/**
* Modules service.
* @module api/ModulesApi
* @version 25.12.4
*/
export default class ModulesApi {

    /**
    * Constructs a new ModulesApi. 
    * @alias module:api/ModulesApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }



    /**
     * List Modules
     * Get all available modules with pricing information.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/GetApiModules200Response} and HTTP response
     */
    getApiModulesWithHttpInfo() {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = GetApiModules200Response;
      return this.apiClient.callApi(
        '/api/modules', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * List Modules
     * Get all available modules with pricing information.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/GetApiModules200Response}
     */
    getApiModules() {
      return this.getApiModulesWithHttpInfo()
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Check Module Access
     * Check if the current organization has access to a specific module.
     * @param {String} moduleId 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/ModuleAccessCheck} and HTTP response
     */
    getApiModulesCheckModuleIdWithHttpInfo(moduleId) {
      let postBody = null;
      // verify the required parameter 'moduleId' is set
      if (moduleId === undefined || moduleId === null) {
        throw new Error("Missing the required parameter 'moduleId' when calling getApiModulesCheckModuleId");
      }

      let pathParams = {
        'moduleId': moduleId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ModuleAccessCheck;
      return this.apiClient.callApi(
        '/api/modules/check/{moduleId}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Check Module Access
     * Check if the current organization has access to a specific module.
     * @param {String} moduleId 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/ModuleAccessCheck}
     */
    getApiModulesCheckModuleId(moduleId) {
      return this.getApiModulesCheckModuleIdWithHttpInfo(moduleId)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Organization Modules
     * Get the list of modules the current organization has access to.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/GetApiModulesOrganization200Response} and HTTP response
     */
    getApiModulesOrganizationWithHttpInfo() {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = GetApiModulesOrganization200Response;
      return this.apiClient.callApi(
        '/api/modules/organization', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Organization Modules
     * Get the list of modules the current organization has access to.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/GetApiModulesOrganization200Response}
     */
    getApiModulesOrganization() {
      return this.getApiModulesOrganizationWithHttpInfo()
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Subscription Plans
     * Get all available subscription plans with included modules and pricing.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/GetApiModulesPlans200Response} and HTTP response
     */
    getApiModulesPlansWithHttpInfo() {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = GetApiModulesPlans200Response;
      return this.apiClient.callApi(
        '/api/modules/plans', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Subscription Plans
     * Get all available subscription plans with included modules and pricing.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/GetApiModulesPlans200Response}
     */
    getApiModulesPlans() {
      return this.getApiModulesPlansWithHttpInfo()
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


}
