/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import NumerologyBirthdayRequest from '../model/NumerologyBirthdayRequest';
import NumerologyBirthdayResponse from '../model/NumerologyBirthdayResponse';
import NumerologyCompatibilityRequest from '../model/NumerologyCompatibilityRequest';
import NumerologyCompatibilityResponse from '../model/NumerologyCompatibilityResponse';
import NumerologyExpressionRequest from '../model/NumerologyExpressionRequest';
import NumerologyExpressionResponse from '../model/NumerologyExpressionResponse';
import NumerologyLifePathRequest from '../model/NumerologyLifePathRequest';
import NumerologyLifePathResponse from '../model/NumerologyLifePathResponse';
import NumerologyPersonalCyclesRequest from '../model/NumerologyPersonalCyclesRequest';
import NumerologyPersonalCyclesResponse from '../model/NumerologyPersonalCyclesResponse';
import NumerologyPersonalityRequest from '../model/NumerologyPersonalityRequest';
import NumerologyPersonalityResponse from '../model/NumerologyPersonalityResponse';
import NumerologyProfileRequest from '../model/NumerologyProfileRequest';
import NumerologyProfileResponse from '../model/NumerologyProfileResponse';
import NumerologySoulUrgeRequest from '../model/NumerologySoulUrgeRequest';
import NumerologySoulUrgeResponse from '../model/NumerologySoulUrgeResponse';

/**
* Numerology service.
* @module api/NumerologyApi
* @version 25.12.4
*/
export default class NumerologyApi {

    /**
    * Constructs a new NumerologyApi. 
    * @alias module:api/NumerologyApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }



    /**
     * Birthday Number
     * Calculate the Birthday Number from the day of birth. This number represents a special talent you possess.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyBirthdayRequest} [numerologyBirthdayRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/NumerologyBirthdayResponse} and HTTP response
     */
    postApiNumerologyBirthdayWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['numerologyBirthdayRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = NumerologyBirthdayResponse;
      return this.apiClient.callApi(
        '/api/numerology/birthday', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Birthday Number
     * Calculate the Birthday Number from the day of birth. This number represents a special talent you possess.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyBirthdayRequest} opts.numerologyBirthdayRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/NumerologyBirthdayResponse}
     */
    postApiNumerologyBirthday(opts) {
      return this.postApiNumerologyBirthdayWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Numerology Compatibility
     * Calculate compatibility between two people based on their Life Path numbers.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyCompatibilityRequest} [numerologyCompatibilityRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/NumerologyCompatibilityResponse} and HTTP response
     */
    postApiNumerologyCompatibilityWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['numerologyCompatibilityRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = NumerologyCompatibilityResponse;
      return this.apiClient.callApi(
        '/api/numerology/compatibility', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Numerology Compatibility
     * Calculate compatibility between two people based on their Life Path numbers.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyCompatibilityRequest} opts.numerologyCompatibilityRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/NumerologyCompatibilityResponse}
     */
    postApiNumerologyCompatibility(opts) {
      return this.postApiNumerologyCompatibilityWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Expression Number
     * Calculate the Expression (Destiny) Number from full name. This number reveals your natural talents and abilities.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyExpressionRequest} [numerologyExpressionRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/NumerologyExpressionResponse} and HTTP response
     */
    postApiNumerologyExpressionWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['numerologyExpressionRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = NumerologyExpressionResponse;
      return this.apiClient.callApi(
        '/api/numerology/expression', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Expression Number
     * Calculate the Expression (Destiny) Number from full name. This number reveals your natural talents and abilities.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyExpressionRequest} opts.numerologyExpressionRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/NumerologyExpressionResponse}
     */
    postApiNumerologyExpression(opts) {
      return this.postApiNumerologyExpressionWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Life Path Number
     * Calculate the Life Path Number from birth date. This is the most important number in numerology, representing your life's purpose.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyLifePathRequest} [numerologyLifePathRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/NumerologyLifePathResponse} and HTTP response
     */
    postApiNumerologyLifePathWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['numerologyLifePathRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = NumerologyLifePathResponse;
      return this.apiClient.callApi(
        '/api/numerology/life-path', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Life Path Number
     * Calculate the Life Path Number from birth date. This is the most important number in numerology, representing your life's purpose.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyLifePathRequest} opts.numerologyLifePathRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/NumerologyLifePathResponse}
     */
    postApiNumerologyLifePath(opts) {
      return this.postApiNumerologyLifePathWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Personal Cycles
     * Calculate Personal Year, Month, and Day numbers. These reveal the current energetic influences in your life.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyPersonalCyclesRequest} [numerologyPersonalCyclesRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/NumerologyPersonalCyclesResponse} and HTTP response
     */
    postApiNumerologyPersonalCyclesWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['numerologyPersonalCyclesRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = NumerologyPersonalCyclesResponse;
      return this.apiClient.callApi(
        '/api/numerology/personal-cycles', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Personal Cycles
     * Calculate Personal Year, Month, and Day numbers. These reveal the current energetic influences in your life.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyPersonalCyclesRequest} opts.numerologyPersonalCyclesRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/NumerologyPersonalCyclesResponse}
     */
    postApiNumerologyPersonalCycles(opts) {
      return this.postApiNumerologyPersonalCyclesWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Personality Number
     * Calculate the Personality Number from consonants in the name. This number reveals how others perceive you.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyPersonalityRequest} [numerologyPersonalityRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/NumerologyPersonalityResponse} and HTTP response
     */
    postApiNumerologyPersonalityWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['numerologyPersonalityRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = NumerologyPersonalityResponse;
      return this.apiClient.callApi(
        '/api/numerology/personality', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Personality Number
     * Calculate the Personality Number from consonants in the name. This number reveals how others perceive you.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyPersonalityRequest} opts.numerologyPersonalityRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/NumerologyPersonalityResponse}
     */
    postApiNumerologyPersonality(opts) {
      return this.postApiNumerologyPersonalityWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Full Numerology Profile
     * Calculate a complete numerology profile including Life Path, Expression, Soul Urge, Personality, Birthday numbers, Personal Cycles, and identify Master/Karmic numbers.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyProfileRequest} [numerologyProfileRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/NumerologyProfileResponse} and HTTP response
     */
    postApiNumerologyProfileWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['numerologyProfileRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = NumerologyProfileResponse;
      return this.apiClient.callApi(
        '/api/numerology/profile', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Full Numerology Profile
     * Calculate a complete numerology profile including Life Path, Expression, Soul Urge, Personality, Birthday numbers, Personal Cycles, and identify Master/Karmic numbers.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologyProfileRequest} opts.numerologyProfileRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/NumerologyProfileResponse}
     */
    postApiNumerologyProfile(opts) {
      return this.postApiNumerologyProfileWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Soul Urge Number
     * Calculate the Soul Urge (Heart's Desire) Number from vowels in the name. This number reveals your inner motivations.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologySoulUrgeRequest} [numerologySoulUrgeRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/NumerologySoulUrgeResponse} and HTTP response
     */
    postApiNumerologySoulUrgeWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['numerologySoulUrgeRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = NumerologySoulUrgeResponse;
      return this.apiClient.callApi(
        '/api/numerology/soul-urge', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Soul Urge Number
     * Calculate the Soul Urge (Heart's Desire) Number from vowels in the name. This number reveals your inner motivations.
     * @param {Object} opts Optional parameters
     * @param {module:model/NumerologySoulUrgeRequest} opts.numerologySoulUrgeRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/NumerologySoulUrgeResponse}
     */
    postApiNumerologySoulUrge(opts) {
      return this.postApiNumerologySoulUrgeWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


}
