/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import GetApiOrgUsers200Response from '../model/GetApiOrgUsers200Response';
import PatchApiOrgUsersMemberId200Response from '../model/PatchApiOrgUsersMemberId200Response';
import PatchApiOrgUsersMemberIdRequest from '../model/PatchApiOrgUsersMemberIdRequest';
import PostApiOrgUsers201Response from '../model/PostApiOrgUsers201Response';
import PostApiOrgUsersRequest from '../model/PostApiOrgUsersRequest';

/**
* Organizations service.
* @module api/OrganizationsApi
* @version 25.12.4
*/
export default class OrganizationsApi {

    /**
    * Constructs a new OrganizationsApi. 
    * @alias module:api/OrganizationsApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }



    /**
     * Remove Member
     * Remove a member from the organization.
     * @param {String} memberId 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing HTTP response
     */
    deleteApiOrgUsersMemberIdWithHttpInfo(memberId) {
      let postBody = null;
      // verify the required parameter 'memberId' is set
      if (memberId === undefined || memberId === null) {
        throw new Error("Missing the required parameter 'memberId' when calling deleteApiOrgUsersMemberId");
      }

      let pathParams = {
        'memberId': memberId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/org/users/{memberId}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Remove Member
     * Remove a member from the organization.
     * @param {String} memberId 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}
     */
    deleteApiOrgUsersMemberId(memberId) {
      return this.deleteApiOrgUsersMemberIdWithHttpInfo(memberId)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * List Members
     * Get a paginated list of organization members.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/GetApiOrgUsers200Response} and HTTP response
     */
    getApiOrgUsersWithHttpInfo() {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/vnd.api+json'];
      let returnType = GetApiOrgUsers200Response;
      return this.apiClient.callApi(
        '/api/org/users', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * List Members
     * Get a paginated list of organization members.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/GetApiOrgUsers200Response}
     */
    getApiOrgUsers() {
      return this.getApiOrgUsersWithHttpInfo()
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Update Member
     * Update an organization member's role.
     * @param {String} memberId 
     * @param {Object} opts Optional parameters
     * @param {module:model/PatchApiOrgUsersMemberIdRequest} [patchApiOrgUsersMemberIdRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/PatchApiOrgUsersMemberId200Response} and HTTP response
     */
    patchApiOrgUsersMemberIdWithHttpInfo(memberId, opts) {
      opts = opts || {};
      let postBody = opts['patchApiOrgUsersMemberIdRequest'];
      // verify the required parameter 'memberId' is set
      if (memberId === undefined || memberId === null) {
        throw new Error("Missing the required parameter 'memberId' when calling patchApiOrgUsersMemberId");
      }

      let pathParams = {
        'memberId': memberId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = PatchApiOrgUsersMemberId200Response;
      return this.apiClient.callApi(
        '/api/org/users/{memberId}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Update Member
     * Update an organization member's role.
     * @param {String} memberId 
     * @param {Object} opts Optional parameters
     * @param {module:model/PatchApiOrgUsersMemberIdRequest} opts.patchApiOrgUsersMemberIdRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/PatchApiOrgUsersMemberId200Response}
     */
    patchApiOrgUsersMemberId(memberId, opts) {
      return this.patchApiOrgUsersMemberIdWithHttpInfo(memberId, opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Create Organization
     * Create a new organization with Stripe billing setup.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link Object} and HTTP response
     */
    postApiOrgWithHttpInfo() {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = ['application/vnd.api+json'];
      let returnType = Object;
      return this.apiClient.callApi(
        '/api/org', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Create Organization
     * Create a new organization with Stripe billing setup.
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link Object}
     */
    postApiOrg() {
      return this.postApiOrgWithHttpInfo()
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Add Member
     * Add or invite a new member to the organization.
     * @param {Object} opts Optional parameters
     * @param {module:model/PostApiOrgUsersRequest} [postApiOrgUsersRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link module:model/PostApiOrgUsers201Response} and HTTP response
     */
    postApiOrgUsersWithHttpInfo(opts) {
      opts = opts || {};
      let postBody = opts['postApiOrgUsersRequest'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['application/vnd.api+json'];
      let returnType = PostApiOrgUsers201Response;
      return this.apiClient.callApi(
        '/api/org/users', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Add Member
     * Add or invite a new member to the organization.
     * @param {Object} opts Optional parameters
     * @param {module:model/PostApiOrgUsersRequest} opts.postApiOrgUsersRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link module:model/PostApiOrgUsers201Response}
     */
    postApiOrgUsers(opts) {
      return this.postApiOrgUsersWithHttpInfo(opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


}
