/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import WidgetChatRequest from '../model/WidgetChatRequest';
import WidgetChatWithUserRequest from '../model/WidgetChatWithUserRequest';

/**
* Widget service.
* @module api/WidgetApi
* @version 25.12.4
*/
export default class WidgetApi {

    /**
    * Constructs a new WidgetApi. 
    * @alias module:api/WidgetApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }



    /**
     * Get Widget Configuration
     * Get the widget configuration for embedding
     * @param {String} chatbotId 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing HTTP response
     */
    getWidgetConfigWithHttpInfo(chatbotId) {
      let postBody = null;
      // verify the required parameter 'chatbotId' is set
      if (chatbotId === undefined || chatbotId === null) {
        throw new Error("Missing the required parameter 'chatbotId' when calling getWidgetConfig");
      }

      let pathParams = {
        'chatbotId': chatbotId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/widget/config/{chatbotId}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Get Widget Configuration
     * Get the widget configuration for embedding
     * @param {String} chatbotId 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}
     */
    getWidgetConfig(chatbotId) {
      return this.getWidgetConfigWithHttpInfo(chatbotId)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Widget Chat
     * Send a message via widget (SSE streaming response)
     * @param {String} chatbotId 
     * @param {Object} opts Optional parameters
     * @param {module:model/WidgetChatRequest} [widgetChatRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link Object} and HTTP response
     */
    widgetChatWithHttpInfo(chatbotId, opts) {
      opts = opts || {};
      let postBody = opts['widgetChatRequest'];
      // verify the required parameter 'chatbotId' is set
      if (chatbotId === undefined || chatbotId === null) {
        throw new Error("Missing the required parameter 'chatbotId' when calling widgetChat");
      }

      let pathParams = {
        'chatbotId': chatbotId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['text/event-stream'];
      let returnType = Object;
      return this.apiClient.callApi(
        '/widget/chat/{chatbotId}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Widget Chat
     * Send a message via widget (SSE streaming response)
     * @param {String} chatbotId 
     * @param {Object} opts Optional parameters
     * @param {module:model/WidgetChatRequest} opts.widgetChatRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link Object}
     */
    widgetChat(chatbotId, opts) {
      return this.widgetChatWithHttpInfo(chatbotId, opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


    /**
     * Widget Chat with User Profile
     * Chat using an external user ID (creates profile on first use)
     * @param {String} chatbotId 
     * @param {String} externalUserId 
     * @param {Object} opts Optional parameters
     * @param {module:model/WidgetChatWithUserRequest} [widgetChatWithUserRequest] 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with an object containing data of type {@link Object} and HTTP response
     */
    widgetChatWithUserWithHttpInfo(chatbotId, externalUserId, opts) {
      opts = opts || {};
      let postBody = opts['widgetChatWithUserRequest'];
      // verify the required parameter 'chatbotId' is set
      if (chatbotId === undefined || chatbotId === null) {
        throw new Error("Missing the required parameter 'chatbotId' when calling widgetChatWithUser");
      }
      // verify the required parameter 'externalUserId' is set
      if (externalUserId === undefined || externalUserId === null) {
        throw new Error("Missing the required parameter 'externalUserId' when calling widgetChatWithUser");
      }

      let pathParams = {
        'chatbotId': chatbotId,
        'externalUserId': externalUserId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['ApiKeyAuth'];
      let contentTypes = ['application/json'];
      let accepts = ['text/event-stream'];
      let returnType = Object;
      return this.apiClient.callApi(
        '/widget/chat/{chatbotId}/user/{externalUserId}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null
      );
    }

    /**
     * Widget Chat with User Profile
     * Chat using an external user ID (creates profile on first use)
     * @param {String} chatbotId 
     * @param {String} externalUserId 
     * @param {Object} opts Optional parameters
     * @param {module:model/WidgetChatWithUserRequest} opts.widgetChatWithUserRequest 
     * @return {Promise} a {@link https://www.promisejs.org/|Promise}, with data of type {@link Object}
     */
    widgetChatWithUser(chatbotId, externalUserId, opts) {
      return this.widgetChatWithUserWithHttpInfo(chatbotId, externalUserId, opts)
        .then(function(response_and_data) {
          return response_and_data.data;
        });
    }


}
