/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The ApiKey model module.
 * @module model/ApiKey
 * @version 25.12.4
 */
class ApiKey {
    /**
     * Constructs a new <code>ApiKey</code>.
     * @alias module:model/ApiKey
     * @param id {String} 
     * @param name {String} 
     * @param prefix {String} 
     * @param start {String} 
     * @param organizationId {String} 
     * @param enabled {Boolean} 
     * @param permissions {Array.<String>} 
     * @param modules {Array.<String>} 
     * @param expiresAt {String} 
     * @param createdAt {String} 
     * @param updatedAt {String} 
     * @param rateLimitEnabled {Boolean} 
     * @param rateLimitTimeWindow {Number} 
     * @param rateLimitMax {Number} 
     * @param requestCount {Number} 
     * @param lastRequest {String} 
     */
    constructor(id, name, prefix, start, organizationId, enabled, permissions, modules, expiresAt, createdAt, updatedAt, rateLimitEnabled, rateLimitTimeWindow, rateLimitMax, requestCount, lastRequest) { 
        
        ApiKey.initialize(this, id, name, prefix, start, organizationId, enabled, permissions, modules, expiresAt, createdAt, updatedAt, rateLimitEnabled, rateLimitTimeWindow, rateLimitMax, requestCount, lastRequest);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, id, name, prefix, start, organizationId, enabled, permissions, modules, expiresAt, createdAt, updatedAt, rateLimitEnabled, rateLimitTimeWindow, rateLimitMax, requestCount, lastRequest) { 
        obj['id'] = id;
        obj['name'] = name;
        obj['prefix'] = prefix;
        obj['start'] = start;
        obj['organizationId'] = organizationId;
        obj['enabled'] = enabled;
        obj['permissions'] = permissions;
        obj['modules'] = modules;
        obj['expiresAt'] = expiresAt;
        obj['createdAt'] = createdAt;
        obj['updatedAt'] = updatedAt;
        obj['rateLimitEnabled'] = rateLimitEnabled;
        obj['rateLimitTimeWindow'] = rateLimitTimeWindow;
        obj['rateLimitMax'] = rateLimitMax;
        obj['requestCount'] = requestCount;
        obj['lastRequest'] = lastRequest;
    }

    /**
     * Constructs a <code>ApiKey</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ApiKey} obj Optional instance to populate.
     * @return {module:model/ApiKey} The populated <code>ApiKey</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ApiKey();

            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'String');
            }
            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('prefix')) {
                obj['prefix'] = ApiClient.convertToType(data['prefix'], 'String');
            }
            if (data.hasOwnProperty('start')) {
                obj['start'] = ApiClient.convertToType(data['start'], 'String');
            }
            if (data.hasOwnProperty('organizationId')) {
                obj['organizationId'] = ApiClient.convertToType(data['organizationId'], 'String');
            }
            if (data.hasOwnProperty('enabled')) {
                obj['enabled'] = ApiClient.convertToType(data['enabled'], 'Boolean');
            }
            if (data.hasOwnProperty('permissions')) {
                obj['permissions'] = ApiClient.convertToType(data['permissions'], ['String']);
            }
            if (data.hasOwnProperty('modules')) {
                obj['modules'] = ApiClient.convertToType(data['modules'], ['String']);
            }
            if (data.hasOwnProperty('expiresAt')) {
                obj['expiresAt'] = ApiClient.convertToType(data['expiresAt'], 'String');
            }
            if (data.hasOwnProperty('createdAt')) {
                obj['createdAt'] = ApiClient.convertToType(data['createdAt'], 'String');
            }
            if (data.hasOwnProperty('updatedAt')) {
                obj['updatedAt'] = ApiClient.convertToType(data['updatedAt'], 'String');
            }
            if (data.hasOwnProperty('rateLimitEnabled')) {
                obj['rateLimitEnabled'] = ApiClient.convertToType(data['rateLimitEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('rateLimitTimeWindow')) {
                obj['rateLimitTimeWindow'] = ApiClient.convertToType(data['rateLimitTimeWindow'], 'Number');
            }
            if (data.hasOwnProperty('rateLimitMax')) {
                obj['rateLimitMax'] = ApiClient.convertToType(data['rateLimitMax'], 'Number');
            }
            if (data.hasOwnProperty('requestCount')) {
                obj['requestCount'] = ApiClient.convertToType(data['requestCount'], 'Number');
            }
            if (data.hasOwnProperty('lastRequest')) {
                obj['lastRequest'] = ApiClient.convertToType(data['lastRequest'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ApiKey</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ApiKey</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ApiKey.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['id'] && !(typeof data['id'] === 'string' || data['id'] instanceof String)) {
            throw new Error("Expected the field `id` to be a primitive type in the JSON string but got " + data['id']);
        }
        // ensure the json data is a string
        if (data['name'] && !(typeof data['name'] === 'string' || data['name'] instanceof String)) {
            throw new Error("Expected the field `name` to be a primitive type in the JSON string but got " + data['name']);
        }
        // ensure the json data is a string
        if (data['prefix'] && !(typeof data['prefix'] === 'string' || data['prefix'] instanceof String)) {
            throw new Error("Expected the field `prefix` to be a primitive type in the JSON string but got " + data['prefix']);
        }
        // ensure the json data is a string
        if (data['start'] && !(typeof data['start'] === 'string' || data['start'] instanceof String)) {
            throw new Error("Expected the field `start` to be a primitive type in the JSON string but got " + data['start']);
        }
        // ensure the json data is a string
        if (data['organizationId'] && !(typeof data['organizationId'] === 'string' || data['organizationId'] instanceof String)) {
            throw new Error("Expected the field `organizationId` to be a primitive type in the JSON string but got " + data['organizationId']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['permissions'])) {
            throw new Error("Expected the field `permissions` to be an array in the JSON data but got " + data['permissions']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['modules'])) {
            throw new Error("Expected the field `modules` to be an array in the JSON data but got " + data['modules']);
        }
        // ensure the json data is a string
        if (data['expiresAt'] && !(typeof data['expiresAt'] === 'string' || data['expiresAt'] instanceof String)) {
            throw new Error("Expected the field `expiresAt` to be a primitive type in the JSON string but got " + data['expiresAt']);
        }
        // ensure the json data is a string
        if (data['createdAt'] && !(typeof data['createdAt'] === 'string' || data['createdAt'] instanceof String)) {
            throw new Error("Expected the field `createdAt` to be a primitive type in the JSON string but got " + data['createdAt']);
        }
        // ensure the json data is a string
        if (data['updatedAt'] && !(typeof data['updatedAt'] === 'string' || data['updatedAt'] instanceof String)) {
            throw new Error("Expected the field `updatedAt` to be a primitive type in the JSON string but got " + data['updatedAt']);
        }
        // ensure the json data is a string
        if (data['lastRequest'] && !(typeof data['lastRequest'] === 'string' || data['lastRequest'] instanceof String)) {
            throw new Error("Expected the field `lastRequest` to be a primitive type in the JSON string but got " + data['lastRequest']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getId() {
        return this.id;
    }

    /**
     * @param {String} id
     */
    setId(id) {
        this['id'] = id;
    }
/**
     * @return {String}
     */
    getName() {
        return this.name;
    }

    /**
     * @param {String} name
     */
    setName(name) {
        this['name'] = name;
    }
/**
     * @return {String}
     */
    getPrefix() {
        return this.prefix;
    }

    /**
     * @param {String} prefix
     */
    setPrefix(prefix) {
        this['prefix'] = prefix;
    }
/**
     * @return {String}
     */
    getStart() {
        return this.start;
    }

    /**
     * @param {String} start
     */
    setStart(start) {
        this['start'] = start;
    }
/**
     * @return {String}
     */
    getOrganizationId() {
        return this.organizationId;
    }

    /**
     * @param {String} organizationId
     */
    setOrganizationId(organizationId) {
        this['organizationId'] = organizationId;
    }
/**
     * @return {Boolean}
     */
    getEnabled() {
        return this.enabled;
    }

    /**
     * @param {Boolean} enabled
     */
    setEnabled(enabled) {
        this['enabled'] = enabled;
    }
/**
     * @return {Array.<String>}
     */
    getPermissions() {
        return this.permissions;
    }

    /**
     * @param {Array.<String>} permissions
     */
    setPermissions(permissions) {
        this['permissions'] = permissions;
    }
/**
     * @return {Array.<String>}
     */
    getModules() {
        return this.modules;
    }

    /**
     * @param {Array.<String>} modules
     */
    setModules(modules) {
        this['modules'] = modules;
    }
/**
     * @return {String}
     */
    getExpiresAt() {
        return this.expiresAt;
    }

    /**
     * @param {String} expiresAt
     */
    setExpiresAt(expiresAt) {
        this['expiresAt'] = expiresAt;
    }
/**
     * @return {String}
     */
    getCreatedAt() {
        return this.createdAt;
    }

    /**
     * @param {String} createdAt
     */
    setCreatedAt(createdAt) {
        this['createdAt'] = createdAt;
    }
/**
     * @return {String}
     */
    getUpdatedAt() {
        return this.updatedAt;
    }

    /**
     * @param {String} updatedAt
     */
    setUpdatedAt(updatedAt) {
        this['updatedAt'] = updatedAt;
    }
/**
     * @return {Boolean}
     */
    getRateLimitEnabled() {
        return this.rateLimitEnabled;
    }

    /**
     * @param {Boolean} rateLimitEnabled
     */
    setRateLimitEnabled(rateLimitEnabled) {
        this['rateLimitEnabled'] = rateLimitEnabled;
    }
/**
     * @return {Number}
     */
    getRateLimitTimeWindow() {
        return this.rateLimitTimeWindow;
    }

    /**
     * @param {Number} rateLimitTimeWindow
     */
    setRateLimitTimeWindow(rateLimitTimeWindow) {
        this['rateLimitTimeWindow'] = rateLimitTimeWindow;
    }
/**
     * @return {Number}
     */
    getRateLimitMax() {
        return this.rateLimitMax;
    }

    /**
     * @param {Number} rateLimitMax
     */
    setRateLimitMax(rateLimitMax) {
        this['rateLimitMax'] = rateLimitMax;
    }
/**
     * @return {Number}
     */
    getRequestCount() {
        return this.requestCount;
    }

    /**
     * @param {Number} requestCount
     */
    setRequestCount(requestCount) {
        this['requestCount'] = requestCount;
    }
/**
     * @return {String}
     */
    getLastRequest() {
        return this.lastRequest;
    }

    /**
     * @param {String} lastRequest
     */
    setLastRequest(lastRequest) {
        this['lastRequest'] = lastRequest;
    }

}

ApiKey.RequiredProperties = ["id", "name", "prefix", "start", "organizationId", "enabled", "permissions", "modules", "expiresAt", "createdAt", "updatedAt", "rateLimitEnabled", "rateLimitTimeWindow", "rateLimitMax", "requestCount", "lastRequest"];

/**
 * @member {String} id
 */
ApiKey.prototype['id'] = undefined;

/**
 * @member {String} name
 */
ApiKey.prototype['name'] = undefined;

/**
 * @member {String} prefix
 */
ApiKey.prototype['prefix'] = undefined;

/**
 * @member {String} start
 */
ApiKey.prototype['start'] = undefined;

/**
 * @member {String} organizationId
 */
ApiKey.prototype['organizationId'] = undefined;

/**
 * @member {Boolean} enabled
 */
ApiKey.prototype['enabled'] = undefined;

/**
 * @member {Array.<String>} permissions
 */
ApiKey.prototype['permissions'] = undefined;

/**
 * @member {Array.<String>} modules
 */
ApiKey.prototype['modules'] = undefined;

/**
 * @member {String} expiresAt
 */
ApiKey.prototype['expiresAt'] = undefined;

/**
 * @member {String} createdAt
 */
ApiKey.prototype['createdAt'] = undefined;

/**
 * @member {String} updatedAt
 */
ApiKey.prototype['updatedAt'] = undefined;

/**
 * @member {Boolean} rateLimitEnabled
 */
ApiKey.prototype['rateLimitEnabled'] = undefined;

/**
 * @member {Number} rateLimitTimeWindow
 */
ApiKey.prototype['rateLimitTimeWindow'] = undefined;

/**
 * @member {Number} rateLimitMax
 */
ApiKey.prototype['rateLimitMax'] = undefined;

/**
 * @member {Number} requestCount
 */
ApiKey.prototype['requestCount'] = undefined;

/**
 * @member {String} lastRequest
 */
ApiKey.prototype['lastRequest'] = undefined;






export default ApiKey;

