/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The ApiKeyCreated model module.
 * @module model/ApiKeyCreated
 * @version 25.12.4
 */
class ApiKeyCreated {
    /**
     * Constructs a new <code>ApiKeyCreated</code>.
     * @alias module:model/ApiKeyCreated
     * @param id {String} 
     * @param key {String} 
     * @param name {String} 
     * @param prefix {String} 
     * @param organizationId {String} 
     * @param permissions {Array.<String>} 
     * @param modules {Array.<String>} 
     * @param expiresAt {String} 
     */
    constructor(id, key, name, prefix, organizationId, permissions, modules, expiresAt) { 
        
        ApiKeyCreated.initialize(this, id, key, name, prefix, organizationId, permissions, modules, expiresAt);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, id, key, name, prefix, organizationId, permissions, modules, expiresAt) { 
        obj['id'] = id;
        obj['key'] = key;
        obj['name'] = name;
        obj['prefix'] = prefix;
        obj['organizationId'] = organizationId;
        obj['permissions'] = permissions;
        obj['modules'] = modules;
        obj['expiresAt'] = expiresAt;
    }

    /**
     * Constructs a <code>ApiKeyCreated</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ApiKeyCreated} obj Optional instance to populate.
     * @return {module:model/ApiKeyCreated} The populated <code>ApiKeyCreated</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ApiKeyCreated();

            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'String');
            }
            if (data.hasOwnProperty('key')) {
                obj['key'] = ApiClient.convertToType(data['key'], 'String');
            }
            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('prefix')) {
                obj['prefix'] = ApiClient.convertToType(data['prefix'], 'String');
            }
            if (data.hasOwnProperty('organizationId')) {
                obj['organizationId'] = ApiClient.convertToType(data['organizationId'], 'String');
            }
            if (data.hasOwnProperty('permissions')) {
                obj['permissions'] = ApiClient.convertToType(data['permissions'], ['String']);
            }
            if (data.hasOwnProperty('modules')) {
                obj['modules'] = ApiClient.convertToType(data['modules'], ['String']);
            }
            if (data.hasOwnProperty('expiresAt')) {
                obj['expiresAt'] = ApiClient.convertToType(data['expiresAt'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ApiKeyCreated</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ApiKeyCreated</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ApiKeyCreated.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['id'] && !(typeof data['id'] === 'string' || data['id'] instanceof String)) {
            throw new Error("Expected the field `id` to be a primitive type in the JSON string but got " + data['id']);
        }
        // ensure the json data is a string
        if (data['key'] && !(typeof data['key'] === 'string' || data['key'] instanceof String)) {
            throw new Error("Expected the field `key` to be a primitive type in the JSON string but got " + data['key']);
        }
        // ensure the json data is a string
        if (data['name'] && !(typeof data['name'] === 'string' || data['name'] instanceof String)) {
            throw new Error("Expected the field `name` to be a primitive type in the JSON string but got " + data['name']);
        }
        // ensure the json data is a string
        if (data['prefix'] && !(typeof data['prefix'] === 'string' || data['prefix'] instanceof String)) {
            throw new Error("Expected the field `prefix` to be a primitive type in the JSON string but got " + data['prefix']);
        }
        // ensure the json data is a string
        if (data['organizationId'] && !(typeof data['organizationId'] === 'string' || data['organizationId'] instanceof String)) {
            throw new Error("Expected the field `organizationId` to be a primitive type in the JSON string but got " + data['organizationId']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['permissions'])) {
            throw new Error("Expected the field `permissions` to be an array in the JSON data but got " + data['permissions']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['modules'])) {
            throw new Error("Expected the field `modules` to be an array in the JSON data but got " + data['modules']);
        }
        // ensure the json data is a string
        if (data['expiresAt'] && !(typeof data['expiresAt'] === 'string' || data['expiresAt'] instanceof String)) {
            throw new Error("Expected the field `expiresAt` to be a primitive type in the JSON string but got " + data['expiresAt']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getId() {
        return this.id;
    }

    /**
     * @param {String} id
     */
    setId(id) {
        this['id'] = id;
    }
/**
     * @return {String}
     */
    getKey() {
        return this.key;
    }

    /**
     * @param {String} key
     */
    setKey(key) {
        this['key'] = key;
    }
/**
     * @return {String}
     */
    getName() {
        return this.name;
    }

    /**
     * @param {String} name
     */
    setName(name) {
        this['name'] = name;
    }
/**
     * @return {String}
     */
    getPrefix() {
        return this.prefix;
    }

    /**
     * @param {String} prefix
     */
    setPrefix(prefix) {
        this['prefix'] = prefix;
    }
/**
     * @return {String}
     */
    getOrganizationId() {
        return this.organizationId;
    }

    /**
     * @param {String} organizationId
     */
    setOrganizationId(organizationId) {
        this['organizationId'] = organizationId;
    }
/**
     * @return {Array.<String>}
     */
    getPermissions() {
        return this.permissions;
    }

    /**
     * @param {Array.<String>} permissions
     */
    setPermissions(permissions) {
        this['permissions'] = permissions;
    }
/**
     * @return {Array.<String>}
     */
    getModules() {
        return this.modules;
    }

    /**
     * @param {Array.<String>} modules
     */
    setModules(modules) {
        this['modules'] = modules;
    }
/**
     * @return {String}
     */
    getExpiresAt() {
        return this.expiresAt;
    }

    /**
     * @param {String} expiresAt
     */
    setExpiresAt(expiresAt) {
        this['expiresAt'] = expiresAt;
    }

}

ApiKeyCreated.RequiredProperties = ["id", "key", "name", "prefix", "organizationId", "permissions", "modules", "expiresAt"];

/**
 * @member {String} id
 */
ApiKeyCreated.prototype['id'] = undefined;

/**
 * @member {String} key
 */
ApiKeyCreated.prototype['key'] = undefined;

/**
 * @member {String} name
 */
ApiKeyCreated.prototype['name'] = undefined;

/**
 * @member {String} prefix
 */
ApiKeyCreated.prototype['prefix'] = undefined;

/**
 * @member {String} organizationId
 */
ApiKeyCreated.prototype['organizationId'] = undefined;

/**
 * @member {Array.<String>} permissions
 */
ApiKeyCreated.prototype['permissions'] = undefined;

/**
 * @member {Array.<String>} modules
 */
ApiKeyCreated.prototype['modules'] = undefined;

/**
 * @member {String} expiresAt
 */
ApiKeyCreated.prototype['expiresAt'] = undefined;






export default ApiKeyCreated;

