/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import ApiKeyModule from './ApiKeyModule';
import Permission from './Permission';

/**
 * The ApiKeyOptions model module.
 * @module model/ApiKeyOptions
 * @version 25.12.4
 */
class ApiKeyOptions {
    /**
     * Constructs a new <code>ApiKeyOptions</code>.
     * @alias module:model/ApiKeyOptions
     * @param permissions {Array.<module:model/Permission>} 
     * @param modules {Array.<module:model/ApiKeyModule>} 
     * @param userRole {String} 
     * @param rolePermissions {Array.<String>} 
     */
    constructor(permissions, modules, userRole, rolePermissions) { 
        
        ApiKeyOptions.initialize(this, permissions, modules, userRole, rolePermissions);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, permissions, modules, userRole, rolePermissions) { 
        obj['permissions'] = permissions;
        obj['modules'] = modules;
        obj['userRole'] = userRole;
        obj['rolePermissions'] = rolePermissions;
    }

    /**
     * Constructs a <code>ApiKeyOptions</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ApiKeyOptions} obj Optional instance to populate.
     * @return {module:model/ApiKeyOptions} The populated <code>ApiKeyOptions</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ApiKeyOptions();

            if (data.hasOwnProperty('permissions')) {
                obj['permissions'] = ApiClient.convertToType(data['permissions'], [Permission]);
            }
            if (data.hasOwnProperty('modules')) {
                obj['modules'] = ApiClient.convertToType(data['modules'], [ApiKeyModule]);
            }
            if (data.hasOwnProperty('userRole')) {
                obj['userRole'] = ApiClient.convertToType(data['userRole'], 'String');
            }
            if (data.hasOwnProperty('rolePermissions')) {
                obj['rolePermissions'] = ApiClient.convertToType(data['rolePermissions'], ['String']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ApiKeyOptions</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ApiKeyOptions</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ApiKeyOptions.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        if (data['permissions']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['permissions'])) {
                throw new Error("Expected the field `permissions` to be an array in the JSON data but got " + data['permissions']);
            }
            // validate the optional field `permissions` (array)
            for (const item of data['permissions']) {
                Permission.validateJSON(item);
            };
        }
        if (data['modules']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['modules'])) {
                throw new Error("Expected the field `modules` to be an array in the JSON data but got " + data['modules']);
            }
            // validate the optional field `modules` (array)
            for (const item of data['modules']) {
                ApiKeyModule.validateJSON(item);
            };
        }
        // ensure the json data is a string
        if (data['userRole'] && !(typeof data['userRole'] === 'string' || data['userRole'] instanceof String)) {
            throw new Error("Expected the field `userRole` to be a primitive type in the JSON string but got " + data['userRole']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['rolePermissions'])) {
            throw new Error("Expected the field `rolePermissions` to be an array in the JSON data but got " + data['rolePermissions']);
        }

        return true;
    }

/**
     * @return {Array.<module:model/Permission>}
     */
    getPermissions() {
        return this.permissions;
    }

    /**
     * @param {Array.<module:model/Permission>} permissions
     */
    setPermissions(permissions) {
        this['permissions'] = permissions;
    }
/**
     * @return {Array.<module:model/ApiKeyModule>}
     */
    getModules() {
        return this.modules;
    }

    /**
     * @param {Array.<module:model/ApiKeyModule>} modules
     */
    setModules(modules) {
        this['modules'] = modules;
    }
/**
     * @return {String}
     */
    getUserRole() {
        return this.userRole;
    }

    /**
     * @param {String} userRole
     */
    setUserRole(userRole) {
        this['userRole'] = userRole;
    }
/**
     * @return {Array.<String>}
     */
    getRolePermissions() {
        return this.rolePermissions;
    }

    /**
     * @param {Array.<String>} rolePermissions
     */
    setRolePermissions(rolePermissions) {
        this['rolePermissions'] = rolePermissions;
    }

}

ApiKeyOptions.RequiredProperties = ["permissions", "modules", "userRole", "rolePermissions"];

/**
 * @member {Array.<module:model/Permission>} permissions
 */
ApiKeyOptions.prototype['permissions'] = undefined;

/**
 * @member {Array.<module:model/ApiKeyModule>} modules
 */
ApiKeyOptions.prototype['modules'] = undefined;

/**
 * @member {String} userRole
 */
ApiKeyOptions.prototype['userRole'] = undefined;

/**
 * @member {Array.<String>} rolePermissions
 */
ApiKeyOptions.prototype['rolePermissions'] = undefined;






export default ApiKeyOptions;

