/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The Aspect1 model module.
 * @module model/Aspect1
 * @version 25.12.4
 */
class Aspect1 {
    /**
     * Constructs a new <code>Aspect1</code>.
     * @alias module:model/Aspect1
     * @param pointA {String} 
     * @param pointB {String} 
     * @param aspect {String} 
     * @param angle {Number} 
     * @param orb {Number} 
     * @param applying {Boolean} 
     */
    constructor(pointA, pointB, aspect, angle, orb, applying) { 
        
        Aspect1.initialize(this, pointA, pointB, aspect, angle, orb, applying);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, pointA, pointB, aspect, angle, orb, applying) { 
        obj['pointA'] = pointA;
        obj['pointB'] = pointB;
        obj['aspect'] = aspect;
        obj['angle'] = angle;
        obj['orb'] = orb;
        obj['applying'] = applying;
    }

    /**
     * Constructs a <code>Aspect1</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/Aspect1} obj Optional instance to populate.
     * @return {module:model/Aspect1} The populated <code>Aspect1</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new Aspect1();

            if (data.hasOwnProperty('pointA')) {
                obj['pointA'] = ApiClient.convertToType(data['pointA'], 'String');
            }
            if (data.hasOwnProperty('pointB')) {
                obj['pointB'] = ApiClient.convertToType(data['pointB'], 'String');
            }
            if (data.hasOwnProperty('aspect')) {
                obj['aspect'] = ApiClient.convertToType(data['aspect'], 'String');
            }
            if (data.hasOwnProperty('angle')) {
                obj['angle'] = ApiClient.convertToType(data['angle'], 'Number');
            }
            if (data.hasOwnProperty('orb')) {
                obj['orb'] = ApiClient.convertToType(data['orb'], 'Number');
            }
            if (data.hasOwnProperty('applying')) {
                obj['applying'] = ApiClient.convertToType(data['applying'], 'Boolean');
            }
            if (data.hasOwnProperty('text')) {
                obj['text'] = ApiClient.convertToType(data['text'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>Aspect1</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>Aspect1</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of Aspect1.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['pointA'] && !(typeof data['pointA'] === 'string' || data['pointA'] instanceof String)) {
            throw new Error("Expected the field `pointA` to be a primitive type in the JSON string but got " + data['pointA']);
        }
        // ensure the json data is a string
        if (data['pointB'] && !(typeof data['pointB'] === 'string' || data['pointB'] instanceof String)) {
            throw new Error("Expected the field `pointB` to be a primitive type in the JSON string but got " + data['pointB']);
        }
        // ensure the json data is a string
        if (data['aspect'] && !(typeof data['aspect'] === 'string' || data['aspect'] instanceof String)) {
            throw new Error("Expected the field `aspect` to be a primitive type in the JSON string but got " + data['aspect']);
        }
        // ensure the json data is a string
        if (data['text'] && !(typeof data['text'] === 'string' || data['text'] instanceof String)) {
            throw new Error("Expected the field `text` to be a primitive type in the JSON string but got " + data['text']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getPointA() {
        return this.pointA;
    }

    /**
     * @param {String} pointA
     */
    setPointA(pointA) {
        this['pointA'] = pointA;
    }
/**
     * @return {String}
     */
    getPointB() {
        return this.pointB;
    }

    /**
     * @param {String} pointB
     */
    setPointB(pointB) {
        this['pointB'] = pointB;
    }
/**
     * @return {String}
     */
    getAspect() {
        return this.aspect;
    }

    /**
     * @param {String} aspect
     */
    setAspect(aspect) {
        this['aspect'] = aspect;
    }
/**
     * @return {Number}
     */
    getAngle() {
        return this.angle;
    }

    /**
     * @param {Number} angle
     */
    setAngle(angle) {
        this['angle'] = angle;
    }
/**
     * @return {Number}
     */
    getOrb() {
        return this.orb;
    }

    /**
     * @param {Number} orb
     */
    setOrb(orb) {
        this['orb'] = orb;
    }
/**
     * @return {Boolean}
     */
    getApplying() {
        return this.applying;
    }

    /**
     * @param {Boolean} applying
     */
    setApplying(applying) {
        this['applying'] = applying;
    }
/**
     * @return {String}
     */
    getText() {
        return this.text;
    }

    /**
     * @param {String} text
     */
    setText(text) {
        this['text'] = text;
    }

}

Aspect1.RequiredProperties = ["pointA", "pointB", "aspect", "angle", "orb", "applying"];

/**
 * @member {String} pointA
 */
Aspect1.prototype['pointA'] = undefined;

/**
 * @member {String} pointB
 */
Aspect1.prototype['pointB'] = undefined;

/**
 * @member {String} aspect
 */
Aspect1.prototype['aspect'] = undefined;

/**
 * @member {Number} angle
 */
Aspect1.prototype['angle'] = undefined;

/**
 * @member {Number} orb
 */
Aspect1.prototype['orb'] = undefined;

/**
 * @member {Boolean} applying
 */
Aspect1.prototype['applying'] = undefined;

/**
 * @member {String} text
 */
Aspect1.prototype['text'] = undefined;






export default Aspect1;

