/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The CelestialPoint1 model module.
 * @module model/CelestialPoint1
 * @version 25.12.4
 */
class CelestialPoint1 {
    /**
     * Constructs a new <code>CelestialPoint1</code>.
     * @alias module:model/CelestialPoint1
     * @param pointId {String} 
     * @param longitude {Number} 
     * @param speedLongitude {Number} 
     * @param speedLatitude {Number} 
     * @param speedDistance {Number} 
     * @param retrograde {Boolean} 
     * @param houseId {String} 
     * @param houseNumber {Number} 
     * @param degreesInSign {Number} 
     * @param degreesInSignDms {Array.<Number>} 
     * @param sign {String} 
     */
    constructor(pointId, longitude, speedLongitude, speedLatitude, speedDistance, retrograde, houseId, houseNumber, degreesInSign, degreesInSignDms, sign) { 
        
        CelestialPoint1.initialize(this, pointId, longitude, speedLongitude, speedLatitude, speedDistance, retrograde, houseId, houseNumber, degreesInSign, degreesInSignDms, sign);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, pointId, longitude, speedLongitude, speedLatitude, speedDistance, retrograde, houseId, houseNumber, degreesInSign, degreesInSignDms, sign) { 
        obj['pointId'] = pointId;
        obj['longitude'] = longitude;
        obj['speedLongitude'] = speedLongitude;
        obj['speedLatitude'] = speedLatitude;
        obj['speedDistance'] = speedDistance;
        obj['retrograde'] = retrograde;
        obj['houseId'] = houseId;
        obj['houseNumber'] = houseNumber;
        obj['degreesInSign'] = degreesInSign;
        obj['degreesInSignDms'] = degreesInSignDms;
        obj['sign'] = sign;
    }

    /**
     * Constructs a <code>CelestialPoint1</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CelestialPoint1} obj Optional instance to populate.
     * @return {module:model/CelestialPoint1} The populated <code>CelestialPoint1</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CelestialPoint1();

            if (data.hasOwnProperty('pointId')) {
                obj['pointId'] = ApiClient.convertToType(data['pointId'], 'String');
            }
            if (data.hasOwnProperty('longitude')) {
                obj['longitude'] = ApiClient.convertToType(data['longitude'], 'Number');
            }
            if (data.hasOwnProperty('speedLongitude')) {
                obj['speedLongitude'] = ApiClient.convertToType(data['speedLongitude'], 'Number');
            }
            if (data.hasOwnProperty('speedLatitude')) {
                obj['speedLatitude'] = ApiClient.convertToType(data['speedLatitude'], 'Number');
            }
            if (data.hasOwnProperty('speedDistance')) {
                obj['speedDistance'] = ApiClient.convertToType(data['speedDistance'], 'Number');
            }
            if (data.hasOwnProperty('retrograde')) {
                obj['retrograde'] = ApiClient.convertToType(data['retrograde'], 'Boolean');
            }
            if (data.hasOwnProperty('houseId')) {
                obj['houseId'] = ApiClient.convertToType(data['houseId'], 'String');
            }
            if (data.hasOwnProperty('houseNumber')) {
                obj['houseNumber'] = ApiClient.convertToType(data['houseNumber'], 'Number');
            }
            if (data.hasOwnProperty('degreesInSign')) {
                obj['degreesInSign'] = ApiClient.convertToType(data['degreesInSign'], 'Number');
            }
            if (data.hasOwnProperty('degreesInSignDms')) {
                obj['degreesInSignDms'] = ApiClient.convertToType(data['degreesInSignDms'], ['Number']);
            }
            if (data.hasOwnProperty('sign')) {
                obj['sign'] = ApiClient.convertToType(data['sign'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CelestialPoint1</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CelestialPoint1</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CelestialPoint1.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['pointId'] && !(typeof data['pointId'] === 'string' || data['pointId'] instanceof String)) {
            throw new Error("Expected the field `pointId` to be a primitive type in the JSON string but got " + data['pointId']);
        }
        // ensure the json data is a string
        if (data['houseId'] && !(typeof data['houseId'] === 'string' || data['houseId'] instanceof String)) {
            throw new Error("Expected the field `houseId` to be a primitive type in the JSON string but got " + data['houseId']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['degreesInSignDms'])) {
            throw new Error("Expected the field `degreesInSignDms` to be an array in the JSON data but got " + data['degreesInSignDms']);
        }
        // ensure the json data is a string
        if (data['sign'] && !(typeof data['sign'] === 'string' || data['sign'] instanceof String)) {
            throw new Error("Expected the field `sign` to be a primitive type in the JSON string but got " + data['sign']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getPointId() {
        return this.pointId;
    }

    /**
     * @param {String} pointId
     */
    setPointId(pointId) {
        this['pointId'] = pointId;
    }
/**
     * @return {Number}
     */
    getLongitude() {
        return this.longitude;
    }

    /**
     * @param {Number} longitude
     */
    setLongitude(longitude) {
        this['longitude'] = longitude;
    }
/**
     * @return {Number}
     */
    getSpeedLongitude() {
        return this.speedLongitude;
    }

    /**
     * @param {Number} speedLongitude
     */
    setSpeedLongitude(speedLongitude) {
        this['speedLongitude'] = speedLongitude;
    }
/**
     * @return {Number}
     */
    getSpeedLatitude() {
        return this.speedLatitude;
    }

    /**
     * @param {Number} speedLatitude
     */
    setSpeedLatitude(speedLatitude) {
        this['speedLatitude'] = speedLatitude;
    }
/**
     * @return {Number}
     */
    getSpeedDistance() {
        return this.speedDistance;
    }

    /**
     * @param {Number} speedDistance
     */
    setSpeedDistance(speedDistance) {
        this['speedDistance'] = speedDistance;
    }
/**
     * @return {Boolean}
     */
    getRetrograde() {
        return this.retrograde;
    }

    /**
     * @param {Boolean} retrograde
     */
    setRetrograde(retrograde) {
        this['retrograde'] = retrograde;
    }
/**
     * @return {String}
     */
    getHouseId() {
        return this.houseId;
    }

    /**
     * @param {String} houseId
     */
    setHouseId(houseId) {
        this['houseId'] = houseId;
    }
/**
     * @return {Number}
     */
    getHouseNumber() {
        return this.houseNumber;
    }

    /**
     * @param {Number} houseNumber
     */
    setHouseNumber(houseNumber) {
        this['houseNumber'] = houseNumber;
    }
/**
     * @return {Number}
     */
    getDegreesInSign() {
        return this.degreesInSign;
    }

    /**
     * @param {Number} degreesInSign
     */
    setDegreesInSign(degreesInSign) {
        this['degreesInSign'] = degreesInSign;
    }
/**
     * @return {Array.<Number>}
     */
    getDegreesInSignDms() {
        return this.degreesInSignDms;
    }

    /**
     * @param {Array.<Number>} degreesInSignDms
     */
    setDegreesInSignDms(degreesInSignDms) {
        this['degreesInSignDms'] = degreesInSignDms;
    }
/**
     * @return {String}
     */
    getSign() {
        return this.sign;
    }

    /**
     * @param {String} sign
     */
    setSign(sign) {
        this['sign'] = sign;
    }

}

CelestialPoint1.RequiredProperties = ["pointId", "longitude", "speedLongitude", "speedLatitude", "speedDistance", "retrograde", "houseId", "houseNumber", "degreesInSign", "degreesInSignDms", "sign"];

/**
 * @member {String} pointId
 */
CelestialPoint1.prototype['pointId'] = undefined;

/**
 * @member {Number} longitude
 */
CelestialPoint1.prototype['longitude'] = undefined;

/**
 * @member {Number} speedLongitude
 */
CelestialPoint1.prototype['speedLongitude'] = undefined;

/**
 * @member {Number} speedLatitude
 */
CelestialPoint1.prototype['speedLatitude'] = undefined;

/**
 * @member {Number} speedDistance
 */
CelestialPoint1.prototype['speedDistance'] = undefined;

/**
 * @member {Boolean} retrograde
 */
CelestialPoint1.prototype['retrograde'] = undefined;

/**
 * @member {String} houseId
 */
CelestialPoint1.prototype['houseId'] = undefined;

/**
 * @member {Number} houseNumber
 */
CelestialPoint1.prototype['houseNumber'] = undefined;

/**
 * @member {Number} degreesInSign
 */
CelestialPoint1.prototype['degreesInSign'] = undefined;

/**
 * @member {Array.<Number>} degreesInSignDms
 */
CelestialPoint1.prototype['degreesInSignDms'] = undefined;

/**
 * @member {String} sign
 */
CelestialPoint1.prototype['sign'] = undefined;






export default CelestialPoint1;

