/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import ChatDirectRequestBirthData from './ChatDirectRequestBirthData';

/**
 * The ChatDirectRequest model module.
 * @module model/ChatDirectRequest
 * @version 25.12.4
 */
class ChatDirectRequest {
    /**
     * Constructs a new <code>ChatDirectRequest</code>.
     * @alias module:model/ChatDirectRequest
     * @param message {String} 
     * @param birthData {module:model/ChatDirectRequestBirthData} 
     */
    constructor(message, birthData) { 
        
        ChatDirectRequest.initialize(this, message, birthData);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, message, birthData) { 
        obj['message'] = message;
        obj['birthData'] = birthData;
    }

    /**
     * Constructs a <code>ChatDirectRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ChatDirectRequest} obj Optional instance to populate.
     * @return {module:model/ChatDirectRequest} The populated <code>ChatDirectRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ChatDirectRequest();

            if (data.hasOwnProperty('message')) {
                obj['message'] = ApiClient.convertToType(data['message'], 'String');
            }
            if (data.hasOwnProperty('conversationId')) {
                obj['conversationId'] = ApiClient.convertToType(data['conversationId'], 'String');
            }
            if (data.hasOwnProperty('birthData')) {
                obj['birthData'] = ChatDirectRequestBirthData.constructFromObject(data['birthData']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ChatDirectRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ChatDirectRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ChatDirectRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['message'] && !(typeof data['message'] === 'string' || data['message'] instanceof String)) {
            throw new Error("Expected the field `message` to be a primitive type in the JSON string but got " + data['message']);
        }
        // ensure the json data is a string
        if (data['conversationId'] && !(typeof data['conversationId'] === 'string' || data['conversationId'] instanceof String)) {
            throw new Error("Expected the field `conversationId` to be a primitive type in the JSON string but got " + data['conversationId']);
        }
        // validate the optional field `birthData`
        if (data['birthData']) { // data not null
          ChatDirectRequestBirthData.validateJSON(data['birthData']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getMessage() {
        return this.message;
    }

    /**
     * @param {String} message
     */
    setMessage(message) {
        this['message'] = message;
    }
/**
     * @return {String}
     */
    getConversationId() {
        return this.conversationId;
    }

    /**
     * @param {String} conversationId
     */
    setConversationId(conversationId) {
        this['conversationId'] = conversationId;
    }
/**
     * @return {module:model/ChatDirectRequestBirthData}
     */
    getBirthData() {
        return this.birthData;
    }

    /**
     * @param {module:model/ChatDirectRequestBirthData} birthData
     */
    setBirthData(birthData) {
        this['birthData'] = birthData;
    }

}

ChatDirectRequest.RequiredProperties = ["message", "birthData"];

/**
 * @member {String} message
 */
ChatDirectRequest.prototype['message'] = undefined;

/**
 * @member {String} conversationId
 */
ChatDirectRequest.prototype['conversationId'] = undefined;

/**
 * @member {module:model/ChatDirectRequestBirthData} birthData
 */
ChatDirectRequest.prototype['birthData'] = undefined;






export default ChatDirectRequest;

