/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The ChatDirectRequestBirthData model module.
 * @module model/ChatDirectRequestBirthData
 * @version 25.12.4
 */
class ChatDirectRequestBirthData {
    /**
     * Constructs a new <code>ChatDirectRequestBirthData</code>.
     * @alias module:model/ChatDirectRequestBirthData
     * @param date {String} 
     * @param latitude {Number} 
     * @param longitude {Number} 
     * @param timezone {String} 
     */
    constructor(date, latitude, longitude, timezone) { 
        
        ChatDirectRequestBirthData.initialize(this, date, latitude, longitude, timezone);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, date, latitude, longitude, timezone) { 
        obj['date'] = date;
        obj['latitude'] = latitude;
        obj['longitude'] = longitude;
        obj['timezone'] = timezone;
    }

    /**
     * Constructs a <code>ChatDirectRequestBirthData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ChatDirectRequestBirthData} obj Optional instance to populate.
     * @return {module:model/ChatDirectRequestBirthData} The populated <code>ChatDirectRequestBirthData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ChatDirectRequestBirthData();

            if (data.hasOwnProperty('date')) {
                obj['date'] = ApiClient.convertToType(data['date'], 'String');
            }
            if (data.hasOwnProperty('time')) {
                obj['time'] = ApiClient.convertToType(data['time'], 'String');
            }
            if (data.hasOwnProperty('latitude')) {
                obj['latitude'] = ApiClient.convertToType(data['latitude'], 'Number');
            }
            if (data.hasOwnProperty('longitude')) {
                obj['longitude'] = ApiClient.convertToType(data['longitude'], 'Number');
            }
            if (data.hasOwnProperty('placeName')) {
                obj['placeName'] = ApiClient.convertToType(data['placeName'], 'String');
            }
            if (data.hasOwnProperty('timezone')) {
                obj['timezone'] = ApiClient.convertToType(data['timezone'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ChatDirectRequestBirthData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ChatDirectRequestBirthData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ChatDirectRequestBirthData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['date'] && !(typeof data['date'] === 'string' || data['date'] instanceof String)) {
            throw new Error("Expected the field `date` to be a primitive type in the JSON string but got " + data['date']);
        }
        // ensure the json data is a string
        if (data['time'] && !(typeof data['time'] === 'string' || data['time'] instanceof String)) {
            throw new Error("Expected the field `time` to be a primitive type in the JSON string but got " + data['time']);
        }
        // ensure the json data is a string
        if (data['placeName'] && !(typeof data['placeName'] === 'string' || data['placeName'] instanceof String)) {
            throw new Error("Expected the field `placeName` to be a primitive type in the JSON string but got " + data['placeName']);
        }
        // ensure the json data is a string
        if (data['timezone'] && !(typeof data['timezone'] === 'string' || data['timezone'] instanceof String)) {
            throw new Error("Expected the field `timezone` to be a primitive type in the JSON string but got " + data['timezone']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getDate() {
        return this.date;
    }

    /**
     * @param {String} date
     */
    setDate(date) {
        this['date'] = date;
    }
/**
     * @return {String}
     */
    getTime() {
        return this.time;
    }

    /**
     * @param {String} time
     */
    setTime(time) {
        this['time'] = time;
    }
/**
     * @return {Number}
     */
    getLatitude() {
        return this.latitude;
    }

    /**
     * @param {Number} latitude
     */
    setLatitude(latitude) {
        this['latitude'] = latitude;
    }
/**
     * @return {Number}
     */
    getLongitude() {
        return this.longitude;
    }

    /**
     * @param {Number} longitude
     */
    setLongitude(longitude) {
        this['longitude'] = longitude;
    }
/**
     * @return {String}
     */
    getPlaceName() {
        return this.placeName;
    }

    /**
     * @param {String} placeName
     */
    setPlaceName(placeName) {
        this['placeName'] = placeName;
    }
/**
     * @return {String}
     */
    getTimezone() {
        return this.timezone;
    }

    /**
     * @param {String} timezone
     */
    setTimezone(timezone) {
        this['timezone'] = timezone;
    }

}

ChatDirectRequestBirthData.RequiredProperties = ["date", "latitude", "longitude", "timezone"];

/**
 * @member {String} date
 */
ChatDirectRequestBirthData.prototype['date'] = undefined;

/**
 * @member {String} time
 */
ChatDirectRequestBirthData.prototype['time'] = undefined;

/**
 * @member {Number} latitude
 */
ChatDirectRequestBirthData.prototype['latitude'] = undefined;

/**
 * @member {Number} longitude
 */
ChatDirectRequestBirthData.prototype['longitude'] = undefined;

/**
 * @member {String} placeName
 */
ChatDirectRequestBirthData.prototype['placeName'] = undefined;

/**
 * @member {String} timezone
 */
ChatDirectRequestBirthData.prototype['timezone'] = undefined;






export default ChatDirectRequestBirthData;

