/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The ChatRequest model module.
 * @module model/ChatRequest
 * @version 25.12.4
 */
class ChatRequest {
    /**
     * Constructs a new <code>ChatRequest</code>.
     * @alias module:model/ChatRequest
     * @param message {String} 
     */
    constructor(message) { 
        
        ChatRequest.initialize(this, message);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, message) { 
        obj['message'] = message;
    }

    /**
     * Constructs a <code>ChatRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ChatRequest} obj Optional instance to populate.
     * @return {module:model/ChatRequest} The populated <code>ChatRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ChatRequest();

            if (data.hasOwnProperty('message')) {
                obj['message'] = ApiClient.convertToType(data['message'], 'String');
            }
            if (data.hasOwnProperty('conversationId')) {
                obj['conversationId'] = ApiClient.convertToType(data['conversationId'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ChatRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ChatRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ChatRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['message'] && !(typeof data['message'] === 'string' || data['message'] instanceof String)) {
            throw new Error("Expected the field `message` to be a primitive type in the JSON string but got " + data['message']);
        }
        // ensure the json data is a string
        if (data['conversationId'] && !(typeof data['conversationId'] === 'string' || data['conversationId'] instanceof String)) {
            throw new Error("Expected the field `conversationId` to be a primitive type in the JSON string but got " + data['conversationId']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getMessage() {
        return this.message;
    }

    /**
     * @param {String} message
     */
    setMessage(message) {
        this['message'] = message;
    }
/**
     * @return {String}
     */
    getConversationId() {
        return this.conversationId;
    }

    /**
     * @param {String} conversationId
     */
    setConversationId(conversationId) {
        this['conversationId'] = conversationId;
    }

}

ChatRequest.RequiredProperties = ["message"];

/**
 * @member {String} message
 */
ChatRequest.prototype['message'] = undefined;

/**
 * @member {String} conversationId
 */
ChatRequest.prototype['conversationId'] = undefined;






export default ChatRequest;

