/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The ChineseForecastData model module.
 * @module model/ChineseForecastData
 * @version 25.12.4
 */
class ChineseForecastData {
    /**
     * Constructs a new <code>ChineseForecastData</code>.
     * @alias module:model/ChineseForecastData
     * @param sign {String} 
     * @param year {Number} 
     * @param categories {Object.<String, String>} 
     */
    constructor(sign, year, categories) { 
        
        ChineseForecastData.initialize(this, sign, year, categories);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, sign, year, categories) { 
        obj['sign'] = sign;
        obj['year'] = year;
        obj['categories'] = categories;
    }

    /**
     * Constructs a <code>ChineseForecastData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ChineseForecastData} obj Optional instance to populate.
     * @return {module:model/ChineseForecastData} The populated <code>ChineseForecastData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ChineseForecastData();

            if (data.hasOwnProperty('sign')) {
                obj['sign'] = ApiClient.convertToType(data['sign'], 'String');
            }
            if (data.hasOwnProperty('year')) {
                obj['year'] = ApiClient.convertToType(data['year'], 'Number');
            }
            if (data.hasOwnProperty('text')) {
                obj['text'] = ApiClient.convertToType(data['text'], 'String');
            }
            if (data.hasOwnProperty('categories')) {
                obj['categories'] = ApiClient.convertToType(data['categories'], {'String': 'String'});
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ChineseForecastData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ChineseForecastData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ChineseForecastData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['sign'] && !(typeof data['sign'] === 'string' || data['sign'] instanceof String)) {
            throw new Error("Expected the field `sign` to be a primitive type in the JSON string but got " + data['sign']);
        }
        // ensure the json data is a string
        if (data['text'] && !(typeof data['text'] === 'string' || data['text'] instanceof String)) {
            throw new Error("Expected the field `text` to be a primitive type in the JSON string but got " + data['text']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getSign() {
        return this.sign;
    }

    /**
     * @param {String} sign
     */
    setSign(sign) {
        this['sign'] = sign;
    }
/**
     * @return {Number}
     */
    getYear() {
        return this.year;
    }

    /**
     * @param {Number} year
     */
    setYear(year) {
        this['year'] = year;
    }
/**
     * @return {String}
     */
    getText() {
        return this.text;
    }

    /**
     * @param {String} text
     */
    setText(text) {
        this['text'] = text;
    }
/**
     * @return {Object.<String, String>}
     */
    getCategories() {
        return this.categories;
    }

    /**
     * @param {Object.<String, String>} categories
     */
    setCategories(categories) {
        this['categories'] = categories;
    }

}

ChineseForecastData.RequiredProperties = ["sign", "year", "categories"];

/**
 * @member {String} sign
 */
ChineseForecastData.prototype['sign'] = undefined;

/**
 * @member {Number} year
 */
ChineseForecastData.prototype['year'] = undefined;

/**
 * @member {String} text
 */
ChineseForecastData.prototype['text'] = undefined;

/**
 * @member {Object.<String, String>} categories
 */
ChineseForecastData.prototype['categories'] = undefined;






export default ChineseForecastData;

