/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The ChineseHoroscopeData model module.
 * @module model/ChineseHoroscopeData
 * @version 25.12.4
 */
class ChineseHoroscopeData {
    /**
     * Constructs a new <code>ChineseHoroscopeData</code>.
     * @alias module:model/ChineseHoroscopeData
     * @param sign {String} 
     * @param element {String} 
     * @param year {Number} 
     */
    constructor(sign, element, year) { 
        
        ChineseHoroscopeData.initialize(this, sign, element, year);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, sign, element, year) { 
        obj['sign'] = sign;
        obj['element'] = element;
        obj['year'] = year;
    }

    /**
     * Constructs a <code>ChineseHoroscopeData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ChineseHoroscopeData} obj Optional instance to populate.
     * @return {module:model/ChineseHoroscopeData} The populated <code>ChineseHoroscopeData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ChineseHoroscopeData();

            if (data.hasOwnProperty('sign')) {
                obj['sign'] = ApiClient.convertToType(data['sign'], 'String');
            }
            if (data.hasOwnProperty('element')) {
                obj['element'] = ApiClient.convertToType(data['element'], 'String');
            }
            if (data.hasOwnProperty('year')) {
                obj['year'] = ApiClient.convertToType(data['year'], 'Number');
            }
            if (data.hasOwnProperty('text')) {
                obj['text'] = ApiClient.convertToType(data['text'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ChineseHoroscopeData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ChineseHoroscopeData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ChineseHoroscopeData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['sign'] && !(typeof data['sign'] === 'string' || data['sign'] instanceof String)) {
            throw new Error("Expected the field `sign` to be a primitive type in the JSON string but got " + data['sign']);
        }
        // ensure the json data is a string
        if (data['element'] && !(typeof data['element'] === 'string' || data['element'] instanceof String)) {
            throw new Error("Expected the field `element` to be a primitive type in the JSON string but got " + data['element']);
        }
        // ensure the json data is a string
        if (data['text'] && !(typeof data['text'] === 'string' || data['text'] instanceof String)) {
            throw new Error("Expected the field `text` to be a primitive type in the JSON string but got " + data['text']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getSign() {
        return this.sign;
    }

    /**
     * @param {String} sign
     */
    setSign(sign) {
        this['sign'] = sign;
    }
/**
     * @return {String}
     */
    getElement() {
        return this.element;
    }

    /**
     * @param {String} element
     */
    setElement(element) {
        this['element'] = element;
    }
/**
     * @return {Number}
     */
    getYear() {
        return this.year;
    }

    /**
     * @param {Number} year
     */
    setYear(year) {
        this['year'] = year;
    }
/**
     * @return {String}
     */
    getText() {
        return this.text;
    }

    /**
     * @param {String} text
     */
    setText(text) {
        this['text'] = text;
    }

}

ChineseHoroscopeData.RequiredProperties = ["sign", "element", "year"];

/**
 * @member {String} sign
 */
ChineseHoroscopeData.prototype['sign'] = undefined;

/**
 * @member {String} element
 */
ChineseHoroscopeData.prototype['element'] = undefined;

/**
 * @member {Number} year
 */
ChineseHoroscopeData.prototype['year'] = undefined;

/**
 * @member {String} text
 */
ChineseHoroscopeData.prototype['text'] = undefined;






export default ChineseHoroscopeData;

