/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The ChineseHoroscopeRequest model module.
 * @module model/ChineseHoroscopeRequest
 * @version 25.12.4
 */
class ChineseHoroscopeRequest {
    /**
     * Constructs a new <code>ChineseHoroscopeRequest</code>.
     * @alias module:model/ChineseHoroscopeRequest
     * @param birthDate {String} Birth date in YYYY-MM-DD or ISO 8601 format
     */
    constructor(birthDate) { 
        
        ChineseHoroscopeRequest.initialize(this, birthDate);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, birthDate) { 
        obj['birthDate'] = birthDate;
        obj['language'] = 'en';
        obj['includeText'] = true;
        obj['includeReadableEntities'] = false;
    }

    /**
     * Constructs a <code>ChineseHoroscopeRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ChineseHoroscopeRequest} obj Optional instance to populate.
     * @return {module:model/ChineseHoroscopeRequest} The populated <code>ChineseHoroscopeRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ChineseHoroscopeRequest();

            if (data.hasOwnProperty('birthDate')) {
                obj['birthDate'] = ApiClient.convertToType(data['birthDate'], 'String');
            }
            if (data.hasOwnProperty('language')) {
                obj['language'] = ApiClient.convertToType(data['language'], 'String');
            }
            if (data.hasOwnProperty('includeText')) {
                obj['includeText'] = ApiClient.convertToType(data['includeText'], 'Boolean');
            }
            if (data.hasOwnProperty('includeReadableEntities')) {
                obj['includeReadableEntities'] = ApiClient.convertToType(data['includeReadableEntities'], 'Boolean');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ChineseHoroscopeRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ChineseHoroscopeRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ChineseHoroscopeRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['birthDate'] && !(typeof data['birthDate'] === 'string' || data['birthDate'] instanceof String)) {
            throw new Error("Expected the field `birthDate` to be a primitive type in the JSON string but got " + data['birthDate']);
        }
        // ensure the json data is a string
        if (data['language'] && !(typeof data['language'] === 'string' || data['language'] instanceof String)) {
            throw new Error("Expected the field `language` to be a primitive type in the JSON string but got " + data['language']);
        }

        return true;
    }

/**
     * Returns Birth date in YYYY-MM-DD or ISO 8601 format
     * @return {String}
     */
    getBirthDate() {
        return this.birthDate;
    }

    /**
     * Sets Birth date in YYYY-MM-DD or ISO 8601 format
     * @param {String} birthDate Birth date in YYYY-MM-DD or ISO 8601 format
     */
    setBirthDate(birthDate) {
        this['birthDate'] = birthDate;
    }
/**
     * Returns Language code for text content
     * @return {String}
     */
    getLanguage() {
        return this.language;
    }

    /**
     * Sets Language code for text content
     * @param {String} language Language code for text content
     */
    setLanguage(language) {
        this['language'] = language;
    }
/**
     * Returns Include interpretation text
     * @return {Boolean}
     */
    getIncludeText() {
        return this.includeText;
    }

    /**
     * Sets Include interpretation text
     * @param {Boolean} includeText Include interpretation text
     */
    setIncludeText(includeText) {
        this['includeText'] = includeText;
    }
/**
     * Returns Include human-readable entity titles
     * @return {Boolean}
     */
    getIncludeReadableEntities() {
        return this.includeReadableEntities;
    }

    /**
     * Sets Include human-readable entity titles
     * @param {Boolean} includeReadableEntities Include human-readable entity titles
     */
    setIncludeReadableEntities(includeReadableEntities) {
        this['includeReadableEntities'] = includeReadableEntities;
    }

}

ChineseHoroscopeRequest.RequiredProperties = ["birthDate"];

/**
 * Birth date in YYYY-MM-DD or ISO 8601 format
 * @member {String} birthDate
 */
ChineseHoroscopeRequest.prototype['birthDate'] = undefined;

/**
 * Language code for text content
 * @member {String} language
 * @default 'en'
 */
ChineseHoroscopeRequest.prototype['language'] = 'en';

/**
 * Include interpretation text
 * @member {Boolean} includeText
 * @default true
 */
ChineseHoroscopeRequest.prototype['includeText'] = true;

/**
 * Include human-readable entity titles
 * @member {Boolean} includeReadableEntities
 * @default false
 */
ChineseHoroscopeRequest.prototype['includeReadableEntities'] = false;






export default ChineseHoroscopeRequest;

