/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The CompatibilityData model module.
 * @module model/CompatibilityData
 * @version 25.12.4
 */
class CompatibilityData {
    /**
     * Constructs a new <code>CompatibilityData</code>.
     * @alias module:model/CompatibilityData
     * @param sign1 {String} 
     * @param sign2 {String} 
     * @param scoreBasedOnElement {Number} 
     * @param scoreBasedOnSunAspect {Number} 
     */
    constructor(sign1, sign2, scoreBasedOnElement, scoreBasedOnSunAspect) { 
        
        CompatibilityData.initialize(this, sign1, sign2, scoreBasedOnElement, scoreBasedOnSunAspect);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, sign1, sign2, scoreBasedOnElement, scoreBasedOnSunAspect) { 
        obj['sign1'] = sign1;
        obj['sign2'] = sign2;
        obj['scoreBasedOnElement'] = scoreBasedOnElement;
        obj['scoreBasedOnSunAspect'] = scoreBasedOnSunAspect;
    }

    /**
     * Constructs a <code>CompatibilityData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CompatibilityData} obj Optional instance to populate.
     * @return {module:model/CompatibilityData} The populated <code>CompatibilityData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CompatibilityData();

            if (data.hasOwnProperty('sign1')) {
                obj['sign1'] = ApiClient.convertToType(data['sign1'], 'String');
            }
            if (data.hasOwnProperty('sign2')) {
                obj['sign2'] = ApiClient.convertToType(data['sign2'], 'String');
            }
            if (data.hasOwnProperty('scoreBasedOnElement')) {
                obj['scoreBasedOnElement'] = ApiClient.convertToType(data['scoreBasedOnElement'], 'Number');
            }
            if (data.hasOwnProperty('scoreBasedOnSunAspect')) {
                obj['scoreBasedOnSunAspect'] = ApiClient.convertToType(data['scoreBasedOnSunAspect'], 'Number');
            }
            if (data.hasOwnProperty('text')) {
                obj['text'] = ApiClient.convertToType(data['text'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CompatibilityData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CompatibilityData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CompatibilityData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['sign1'] && !(typeof data['sign1'] === 'string' || data['sign1'] instanceof String)) {
            throw new Error("Expected the field `sign1` to be a primitive type in the JSON string but got " + data['sign1']);
        }
        // ensure the json data is a string
        if (data['sign2'] && !(typeof data['sign2'] === 'string' || data['sign2'] instanceof String)) {
            throw new Error("Expected the field `sign2` to be a primitive type in the JSON string but got " + data['sign2']);
        }
        // ensure the json data is a string
        if (data['text'] && !(typeof data['text'] === 'string' || data['text'] instanceof String)) {
            throw new Error("Expected the field `text` to be a primitive type in the JSON string but got " + data['text']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getSign1() {
        return this.sign1;
    }

    /**
     * @param {String} sign1
     */
    setSign1(sign1) {
        this['sign1'] = sign1;
    }
/**
     * @return {String}
     */
    getSign2() {
        return this.sign2;
    }

    /**
     * @param {String} sign2
     */
    setSign2(sign2) {
        this['sign2'] = sign2;
    }
/**
     * @return {Number}
     */
    getScoreBasedOnElement() {
        return this.scoreBasedOnElement;
    }

    /**
     * @param {Number} scoreBasedOnElement
     */
    setScoreBasedOnElement(scoreBasedOnElement) {
        this['scoreBasedOnElement'] = scoreBasedOnElement;
    }
/**
     * @return {Number}
     */
    getScoreBasedOnSunAspect() {
        return this.scoreBasedOnSunAspect;
    }

    /**
     * @param {Number} scoreBasedOnSunAspect
     */
    setScoreBasedOnSunAspect(scoreBasedOnSunAspect) {
        this['scoreBasedOnSunAspect'] = scoreBasedOnSunAspect;
    }
/**
     * @return {String}
     */
    getText() {
        return this.text;
    }

    /**
     * @param {String} text
     */
    setText(text) {
        this['text'] = text;
    }

}

CompatibilityData.RequiredProperties = ["sign1", "sign2", "scoreBasedOnElement", "scoreBasedOnSunAspect"];

/**
 * @member {String} sign1
 */
CompatibilityData.prototype['sign1'] = undefined;

/**
 * @member {String} sign2
 */
CompatibilityData.prototype['sign2'] = undefined;

/**
 * @member {Number} scoreBasedOnElement
 */
CompatibilityData.prototype['scoreBasedOnElement'] = undefined;

/**
 * @member {Number} scoreBasedOnSunAspect
 */
CompatibilityData.prototype['scoreBasedOnSunAspect'] = undefined;

/**
 * @member {String} text
 */
CompatibilityData.prototype['text'] = undefined;






export default CompatibilityData;

