/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Location from './Location';

/**
 * The CompatibilityRequest model module.
 * @module model/CompatibilityRequest
 * @version 25.12.4
 */
class CompatibilityRequest {
    /**
     * Constructs a new <code>CompatibilityRequest</code>.
     * @alias module:model/CompatibilityRequest
     * @param dateTime1 {String} First person birth date/time in YYYY-MM-DDTHH:mm format
     * @param location1 {module:model/Location} 
     * @param dateTime2 {String} Second person birth date/time in YYYY-MM-DDTHH:mm format
     * @param location2 {module:model/Location} 
     */
    constructor(dateTime1, location1, dateTime2, location2) { 
        
        CompatibilityRequest.initialize(this, dateTime1, location1, dateTime2, location2);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, dateTime1, location1, dateTime2, location2) { 
        obj['dateTime1'] = dateTime1;
        obj['location1'] = location1;
        obj['dateTime2'] = dateTime2;
        obj['location2'] = location2;
        obj['language'] = 'en';
        obj['includeText'] = true;
        obj['includeReadableEntities'] = false;
    }

    /**
     * Constructs a <code>CompatibilityRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CompatibilityRequest} obj Optional instance to populate.
     * @return {module:model/CompatibilityRequest} The populated <code>CompatibilityRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CompatibilityRequest();

            if (data.hasOwnProperty('dateTime1')) {
                obj['dateTime1'] = ApiClient.convertToType(data['dateTime1'], 'String');
            }
            if (data.hasOwnProperty('location1')) {
                obj['location1'] = Location.constructFromObject(data['location1']);
            }
            if (data.hasOwnProperty('dateTime2')) {
                obj['dateTime2'] = ApiClient.convertToType(data['dateTime2'], 'String');
            }
            if (data.hasOwnProperty('location2')) {
                obj['location2'] = Location.constructFromObject(data['location2']);
            }
            if (data.hasOwnProperty('language')) {
                obj['language'] = ApiClient.convertToType(data['language'], 'String');
            }
            if (data.hasOwnProperty('includeText')) {
                obj['includeText'] = ApiClient.convertToType(data['includeText'], 'Boolean');
            }
            if (data.hasOwnProperty('includeReadableEntities')) {
                obj['includeReadableEntities'] = ApiClient.convertToType(data['includeReadableEntities'], 'Boolean');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CompatibilityRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CompatibilityRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CompatibilityRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['dateTime1'] && !(typeof data['dateTime1'] === 'string' || data['dateTime1'] instanceof String)) {
            throw new Error("Expected the field `dateTime1` to be a primitive type in the JSON string but got " + data['dateTime1']);
        }
        // validate the optional field `location1`
        if (data['location1']) { // data not null
          Location.validateJSON(data['location1']);
        }
        // ensure the json data is a string
        if (data['dateTime2'] && !(typeof data['dateTime2'] === 'string' || data['dateTime2'] instanceof String)) {
            throw new Error("Expected the field `dateTime2` to be a primitive type in the JSON string but got " + data['dateTime2']);
        }
        // validate the optional field `location2`
        if (data['location2']) { // data not null
          Location.validateJSON(data['location2']);
        }
        // ensure the json data is a string
        if (data['language'] && !(typeof data['language'] === 'string' || data['language'] instanceof String)) {
            throw new Error("Expected the field `language` to be a primitive type in the JSON string but got " + data['language']);
        }

        return true;
    }

/**
     * Returns First person birth date/time in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getDateTime1() {
        return this.dateTime1;
    }

    /**
     * Sets First person birth date/time in YYYY-MM-DDTHH:mm format
     * @param {String} dateTime1 First person birth date/time in YYYY-MM-DDTHH:mm format
     */
    setDateTime1(dateTime1) {
        this['dateTime1'] = dateTime1;
    }
/**
     * @return {module:model/Location}
     */
    getLocation1() {
        return this.location1;
    }

    /**
     * @param {module:model/Location} location1
     */
    setLocation1(location1) {
        this['location1'] = location1;
    }
/**
     * Returns Second person birth date/time in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getDateTime2() {
        return this.dateTime2;
    }

    /**
     * Sets Second person birth date/time in YYYY-MM-DDTHH:mm format
     * @param {String} dateTime2 Second person birth date/time in YYYY-MM-DDTHH:mm format
     */
    setDateTime2(dateTime2) {
        this['dateTime2'] = dateTime2;
    }
/**
     * @return {module:model/Location}
     */
    getLocation2() {
        return this.location2;
    }

    /**
     * @param {module:model/Location} location2
     */
    setLocation2(location2) {
        this['location2'] = location2;
    }
/**
     * Returns Language code for text content
     * @return {String}
     */
    getLanguage() {
        return this.language;
    }

    /**
     * Sets Language code for text content
     * @param {String} language Language code for text content
     */
    setLanguage(language) {
        this['language'] = language;
    }
/**
     * Returns Include interpretation text
     * @return {Boolean}
     */
    getIncludeText() {
        return this.includeText;
    }

    /**
     * Sets Include interpretation text
     * @param {Boolean} includeText Include interpretation text
     */
    setIncludeText(includeText) {
        this['includeText'] = includeText;
    }
/**
     * Returns Include human-readable entity titles
     * @return {Boolean}
     */
    getIncludeReadableEntities() {
        return this.includeReadableEntities;
    }

    /**
     * Sets Include human-readable entity titles
     * @param {Boolean} includeReadableEntities Include human-readable entity titles
     */
    setIncludeReadableEntities(includeReadableEntities) {
        this['includeReadableEntities'] = includeReadableEntities;
    }

}

CompatibilityRequest.RequiredProperties = ["dateTime1", "location1", "dateTime2", "location2"];

/**
 * First person birth date/time in YYYY-MM-DDTHH:mm format
 * @member {String} dateTime1
 */
CompatibilityRequest.prototype['dateTime1'] = undefined;

/**
 * @member {module:model/Location} location1
 */
CompatibilityRequest.prototype['location1'] = undefined;

/**
 * Second person birth date/time in YYYY-MM-DDTHH:mm format
 * @member {String} dateTime2
 */
CompatibilityRequest.prototype['dateTime2'] = undefined;

/**
 * @member {module:model/Location} location2
 */
CompatibilityRequest.prototype['location2'] = undefined;

/**
 * Language code for text content
 * @member {String} language
 * @default 'en'
 */
CompatibilityRequest.prototype['language'] = 'en';

/**
 * Include interpretation text
 * @member {Boolean} includeText
 * @default true
 */
CompatibilityRequest.prototype['includeText'] = true;

/**
 * Include human-readable entity titles
 * @member {Boolean} includeReadableEntities
 * @default false
 */
CompatibilityRequest.prototype['includeReadableEntities'] = false;






export default CompatibilityRequest;

