/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Aspect1 from './Aspect1';
import CelestialPoint1 from './CelestialPoint1';
import ChartEntry1 from './ChartEntry1';

/**
 * The CompositeData model module.
 * @module model/CompositeData
 * @version 25.12.4
 */
class CompositeData {
    /**
     * Constructs a new <code>CompositeData</code>.
     * @alias module:model/CompositeData
     * @param points {Object.<String, module:model/CelestialPoint1>} 
     * @param aspects {Array.<module:model/Aspect1>} 
     * @param charts {Object.<String, module:model/ChartEntry1>} 
     */
    constructor(points, aspects, charts) { 
        
        CompositeData.initialize(this, points, aspects, charts);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, points, aspects, charts) { 
        obj['points'] = points;
        obj['aspects'] = aspects;
        obj['charts'] = charts;
    }

    /**
     * Constructs a <code>CompositeData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CompositeData} obj Optional instance to populate.
     * @return {module:model/CompositeData} The populated <code>CompositeData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CompositeData();

            if (data.hasOwnProperty('points')) {
                obj['points'] = ApiClient.convertToType(data['points'], {'String': CelestialPoint1});
            }
            if (data.hasOwnProperty('aspects')) {
                obj['aspects'] = ApiClient.convertToType(data['aspects'], [Aspect1]);
            }
            if (data.hasOwnProperty('charts')) {
                obj['charts'] = ApiClient.convertToType(data['charts'], {'String': ChartEntry1});
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CompositeData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CompositeData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CompositeData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        if (data['aspects']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['aspects'])) {
                throw new Error("Expected the field `aspects` to be an array in the JSON data but got " + data['aspects']);
            }
            // validate the optional field `aspects` (array)
            for (const item of data['aspects']) {
                Aspect1.validateJSON(item);
            };
        }

        return true;
    }

/**
     * @return {Object.<String, module:model/CelestialPoint1>}
     */
    getPoints() {
        return this.points;
    }

    /**
     * @param {Object.<String, module:model/CelestialPoint1>} points
     */
    setPoints(points) {
        this['points'] = points;
    }
/**
     * @return {Array.<module:model/Aspect1>}
     */
    getAspects() {
        return this.aspects;
    }

    /**
     * @param {Array.<module:model/Aspect1>} aspects
     */
    setAspects(aspects) {
        this['aspects'] = aspects;
    }
/**
     * @return {Object.<String, module:model/ChartEntry1>}
     */
    getCharts() {
        return this.charts;
    }

    /**
     * @param {Object.<String, module:model/ChartEntry1>} charts
     */
    setCharts(charts) {
        this['charts'] = charts;
    }

}

CompositeData.RequiredProperties = ["points", "aspects", "charts"];

/**
 * @member {Object.<String, module:model/CelestialPoint1>} points
 */
CompositeData.prototype['points'] = undefined;

/**
 * @member {Array.<module:model/Aspect1>} aspects
 */
CompositeData.prototype['aspects'] = undefined;

/**
 * @member {Object.<String, module:model/ChartEntry1>} charts
 */
CompositeData.prototype['charts'] = undefined;






export default CompositeData;

