/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import ContentAttributes from './ContentAttributes';
import ContentLinks from './ContentLinks';

/**
 * The Content model module.
 * @module model/Content
 * @version 25.12.4
 */
class Content {
    /**
     * Constructs a new <code>Content</code>.
     * @alias module:model/Content
     * @param type {Object} 
     * @param id {String} 
     * @param attributes {module:model/ContentAttributes} 
     */
    constructor(type, id, attributes) { 
        
        Content.initialize(this, type, id, attributes);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, type, id, attributes) { 
        obj['type'] = type;
        obj['id'] = id;
        obj['attributes'] = attributes;
    }

    /**
     * Constructs a <code>Content</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/Content} obj Optional instance to populate.
     * @return {module:model/Content} The populated <code>Content</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new Content();

            if (data.hasOwnProperty('type')) {
                obj['type'] = ApiClient.convertToType(data['type'], Object);
            }
            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'String');
            }
            if (data.hasOwnProperty('attributes')) {
                obj['attributes'] = ContentAttributes.constructFromObject(data['attributes']);
            }
            if (data.hasOwnProperty('links')) {
                obj['links'] = ContentLinks.constructFromObject(data['links']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>Content</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>Content</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of Content.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['id'] && !(typeof data['id'] === 'string' || data['id'] instanceof String)) {
            throw new Error("Expected the field `id` to be a primitive type in the JSON string but got " + data['id']);
        }
        // validate the optional field `attributes`
        if (data['attributes']) { // data not null
          ContentAttributes.validateJSON(data['attributes']);
        }
        // validate the optional field `links`
        if (data['links']) { // data not null
          ContentLinks.validateJSON(data['links']);
        }

        return true;
    }

/**
     * @return {Object}
     */
    getType() {
        return this.type;
    }

    /**
     * @param {Object} type
     */
    setType(type) {
        this['type'] = type;
    }
/**
     * @return {String}
     */
    getId() {
        return this.id;
    }

    /**
     * @param {String} id
     */
    setId(id) {
        this['id'] = id;
    }
/**
     * @return {module:model/ContentAttributes}
     */
    getAttributes() {
        return this.attributes;
    }

    /**
     * @param {module:model/ContentAttributes} attributes
     */
    setAttributes(attributes) {
        this['attributes'] = attributes;
    }
/**
     * @return {module:model/ContentLinks}
     */
    getLinks() {
        return this.links;
    }

    /**
     * @param {module:model/ContentLinks} links
     */
    setLinks(links) {
        this['links'] = links;
    }

}

Content.RequiredProperties = ["type", "id", "attributes"];

/**
 * @member {Object} type
 */
Content.prototype['type'] = undefined;

/**
 * @member {String} id
 */
Content.prototype['id'] = undefined;

/**
 * @member {module:model/ContentAttributes} attributes
 */
Content.prototype['attributes'] = undefined;

/**
 * @member {module:model/ContentLinks} links
 */
Content.prototype['links'] = undefined;






export default Content;

