/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import AnyOf from './AnyOf';

/**
 * The ContentAttributes model module.
 * @module model/ContentAttributes
 * @version 25.12.4
 */
class ContentAttributes {
    /**
     * Constructs a new <code>ContentAttributes</code>.
     * @alias module:model/ContentAttributes
     * @param urn {String} 
     */
    constructor(urn) { 
        
        ContentAttributes.initialize(this, urn);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, urn) { 
        obj['urn'] = urn;
    }

    /**
     * Constructs a <code>ContentAttributes</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ContentAttributes} obj Optional instance to populate.
     * @return {module:model/ContentAttributes} The populated <code>ContentAttributes</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ContentAttributes();

            if (data.hasOwnProperty('urn')) {
                obj['urn'] = ApiClient.convertToType(data['urn'], 'String');
            }
            if (data.hasOwnProperty('title')) {
                obj['title'] = ApiClient.convertToType(data['title'], 'String');
            }
            if (data.hasOwnProperty('body')) {
                obj['body'] = ApiClient.convertToType(data['body'], 'String');
            }
            if (data.hasOwnProperty('metadata')) {
                obj['metadata'] = ApiClient.convertToType(data['metadata'], AnyOf);
            }
            if (data.hasOwnProperty('owner_type')) {
                obj['owner_type'] = ApiClient.convertToType(data['owner_type'], 'String');
            }
            if (data.hasOwnProperty('owner_id')) {
                obj['owner_id'] = ApiClient.convertToType(data['owner_id'], 'String');
            }
            if (data.hasOwnProperty('base_content_id')) {
                obj['base_content_id'] = ApiClient.convertToType(data['base_content_id'], 'String');
            }
            if (data.hasOwnProperty('created_at')) {
                obj['created_at'] = ApiClient.convertToType(data['created_at'], 'String');
            }
            if (data.hasOwnProperty('updated_at')) {
                obj['updated_at'] = ApiClient.convertToType(data['updated_at'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ContentAttributes</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ContentAttributes</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ContentAttributes.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['urn'] && !(typeof data['urn'] === 'string' || data['urn'] instanceof String)) {
            throw new Error("Expected the field `urn` to be a primitive type in the JSON string but got " + data['urn']);
        }
        // ensure the json data is a string
        if (data['title'] && !(typeof data['title'] === 'string' || data['title'] instanceof String)) {
            throw new Error("Expected the field `title` to be a primitive type in the JSON string but got " + data['title']);
        }
        // ensure the json data is a string
        if (data['body'] && !(typeof data['body'] === 'string' || data['body'] instanceof String)) {
            throw new Error("Expected the field `body` to be a primitive type in the JSON string but got " + data['body']);
        }
        // validate the optional field `metadata`
        if (data['metadata']) { // data not null
          AnyOf.validateJSON(data['metadata']);
        }
        // ensure the json data is a string
        if (data['owner_type'] && !(typeof data['owner_type'] === 'string' || data['owner_type'] instanceof String)) {
            throw new Error("Expected the field `owner_type` to be a primitive type in the JSON string but got " + data['owner_type']);
        }
        // ensure the json data is a string
        if (data['owner_id'] && !(typeof data['owner_id'] === 'string' || data['owner_id'] instanceof String)) {
            throw new Error("Expected the field `owner_id` to be a primitive type in the JSON string but got " + data['owner_id']);
        }
        // ensure the json data is a string
        if (data['base_content_id'] && !(typeof data['base_content_id'] === 'string' || data['base_content_id'] instanceof String)) {
            throw new Error("Expected the field `base_content_id` to be a primitive type in the JSON string but got " + data['base_content_id']);
        }
        // ensure the json data is a string
        if (data['created_at'] && !(typeof data['created_at'] === 'string' || data['created_at'] instanceof String)) {
            throw new Error("Expected the field `created_at` to be a primitive type in the JSON string but got " + data['created_at']);
        }
        // ensure the json data is a string
        if (data['updated_at'] && !(typeof data['updated_at'] === 'string' || data['updated_at'] instanceof String)) {
            throw new Error("Expected the field `updated_at` to be a primitive type in the JSON string but got " + data['updated_at']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getUrn() {
        return this.urn;
    }

    /**
     * @param {String} urn
     */
    setUrn(urn) {
        this['urn'] = urn;
    }
/**
     * @return {String}
     */
    getTitle() {
        return this.title;
    }

    /**
     * @param {String} title
     */
    setTitle(title) {
        this['title'] = title;
    }
/**
     * @return {String}
     */
    getBody() {
        return this.body;
    }

    /**
     * @param {String} body
     */
    setBody(body) {
        this['body'] = body;
    }
/**
     * @return {module:model/AnyOf}
     */
    getMetadata() {
        return this.metadata;
    }

    /**
     * @param {module:model/AnyOf} metadata
     */
    setMetadata(metadata) {
        this['metadata'] = metadata;
    }
/**
     * @return {String}
     */
    getOwnerType() {
        return this.owner_type;
    }

    /**
     * @param {String} ownerType
     */
    setOwnerType(ownerType) {
        this['owner_type'] = ownerType;
    }
/**
     * @return {String}
     */
    getOwnerId() {
        return this.owner_id;
    }

    /**
     * @param {String} ownerId
     */
    setOwnerId(ownerId) {
        this['owner_id'] = ownerId;
    }
/**
     * @return {String}
     */
    getBaseContentId() {
        return this.base_content_id;
    }

    /**
     * @param {String} baseContentId
     */
    setBaseContentId(baseContentId) {
        this['base_content_id'] = baseContentId;
    }
/**
     * @return {String}
     */
    getCreatedAt() {
        return this.created_at;
    }

    /**
     * @param {String} createdAt
     */
    setCreatedAt(createdAt) {
        this['created_at'] = createdAt;
    }
/**
     * @return {String}
     */
    getUpdatedAt() {
        return this.updated_at;
    }

    /**
     * @param {String} updatedAt
     */
    setUpdatedAt(updatedAt) {
        this['updated_at'] = updatedAt;
    }

}

ContentAttributes.RequiredProperties = ["urn"];

/**
 * @member {String} urn
 */
ContentAttributes.prototype['urn'] = undefined;

/**
 * @member {String} title
 */
ContentAttributes.prototype['title'] = undefined;

/**
 * @member {String} body
 */
ContentAttributes.prototype['body'] = undefined;

/**
 * @member {module:model/AnyOf} metadata
 */
ContentAttributes.prototype['metadata'] = undefined;

/**
 * @member {String} owner_type
 */
ContentAttributes.prototype['owner_type'] = undefined;

/**
 * @member {String} owner_id
 */
ContentAttributes.prototype['owner_id'] = undefined;

/**
 * @member {String} base_content_id
 */
ContentAttributes.prototype['base_content_id'] = undefined;

/**
 * @member {String} created_at
 */
ContentAttributes.prototype['created_at'] = undefined;

/**
 * @member {String} updated_at
 */
ContentAttributes.prototype['updated_at'] = undefined;






export default ContentAttributes;

