/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The CreateApiKeyRequest model module.
 * @module model/CreateApiKeyRequest
 * @version 25.12.4
 */
class CreateApiKeyRequest {
    /**
     * Constructs a new <code>CreateApiKeyRequest</code>.
     * @alias module:model/CreateApiKeyRequest
     */
    constructor() { 
        
        CreateApiKeyRequest.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>CreateApiKeyRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CreateApiKeyRequest} obj Optional instance to populate.
     * @return {module:model/CreateApiKeyRequest} The populated <code>CreateApiKeyRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CreateApiKeyRequest();

            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('organizationId')) {
                obj['organizationId'] = ApiClient.convertToType(data['organizationId'], 'String');
            }
            if (data.hasOwnProperty('permissions')) {
                obj['permissions'] = ApiClient.convertToType(data['permissions'], ['String']);
            }
            if (data.hasOwnProperty('modules')) {
                obj['modules'] = ApiClient.convertToType(data['modules'], ['String']);
            }
            if (data.hasOwnProperty('expiresIn')) {
                obj['expiresIn'] = ApiClient.convertToType(data['expiresIn'], 'Number');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CreateApiKeyRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CreateApiKeyRequest</code>.
     */
    static validateJSON(data) {
        // ensure the json data is a string
        if (data['name'] && !(typeof data['name'] === 'string' || data['name'] instanceof String)) {
            throw new Error("Expected the field `name` to be a primitive type in the JSON string but got " + data['name']);
        }
        // ensure the json data is a string
        if (data['organizationId'] && !(typeof data['organizationId'] === 'string' || data['organizationId'] instanceof String)) {
            throw new Error("Expected the field `organizationId` to be a primitive type in the JSON string but got " + data['organizationId']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['permissions'])) {
            throw new Error("Expected the field `permissions` to be an array in the JSON data but got " + data['permissions']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['modules'])) {
            throw new Error("Expected the field `modules` to be an array in the JSON data but got " + data['modules']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getName() {
        return this.name;
    }

    /**
     * @param {String} name
     */
    setName(name) {
        this['name'] = name;
    }
/**
     * @return {String}
     */
    getOrganizationId() {
        return this.organizationId;
    }

    /**
     * @param {String} organizationId
     */
    setOrganizationId(organizationId) {
        this['organizationId'] = organizationId;
    }
/**
     * @return {Array.<String>}
     */
    getPermissions() {
        return this.permissions;
    }

    /**
     * @param {Array.<String>} permissions
     */
    setPermissions(permissions) {
        this['permissions'] = permissions;
    }
/**
     * @return {Array.<String>}
     */
    getModules() {
        return this.modules;
    }

    /**
     * @param {Array.<String>} modules
     */
    setModules(modules) {
        this['modules'] = modules;
    }
/**
     * @return {Number}
     */
    getExpiresIn() {
        return this.expiresIn;
    }

    /**
     * @param {Number} expiresIn
     */
    setExpiresIn(expiresIn) {
        this['expiresIn'] = expiresIn;
    }

}



/**
 * @member {String} name
 */
CreateApiKeyRequest.prototype['name'] = undefined;

/**
 * @member {String} organizationId
 */
CreateApiKeyRequest.prototype['organizationId'] = undefined;

/**
 * @member {Array.<String>} permissions
 */
CreateApiKeyRequest.prototype['permissions'] = undefined;

/**
 * @member {Array.<String>} modules
 */
CreateApiKeyRequest.prototype['modules'] = undefined;

/**
 * @member {Number} expiresIn
 */
CreateApiKeyRequest.prototype['expiresIn'] = undefined;






export default CreateApiKeyRequest;

