/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The CreateChatProfileRequestDataAttributes model module.
 * @module model/CreateChatProfileRequestDataAttributes
 * @version 25.12.4
 */
class CreateChatProfileRequestDataAttributes {
    /**
     * Constructs a new <code>CreateChatProfileRequestDataAttributes</code>.
     * @alias module:model/CreateChatProfileRequestDataAttributes
     * @param birthDate {String} 
     * @param birthPlaceLat {Number} 
     * @param birthPlaceLng {Number} 
     * @param timezone {String} 
     */
    constructor(birthDate, birthPlaceLat, birthPlaceLng, timezone) { 
        
        CreateChatProfileRequestDataAttributes.initialize(this, birthDate, birthPlaceLat, birthPlaceLng, timezone);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, birthDate, birthPlaceLat, birthPlaceLng, timezone) { 
        obj['birthDate'] = birthDate;
        obj['birthPlaceLat'] = birthPlaceLat;
        obj['birthPlaceLng'] = birthPlaceLng;
        obj['timezone'] = timezone;
    }

    /**
     * Constructs a <code>CreateChatProfileRequestDataAttributes</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CreateChatProfileRequestDataAttributes} obj Optional instance to populate.
     * @return {module:model/CreateChatProfileRequestDataAttributes} The populated <code>CreateChatProfileRequestDataAttributes</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CreateChatProfileRequestDataAttributes();

            if (data.hasOwnProperty('externalUserId')) {
                obj['externalUserId'] = ApiClient.convertToType(data['externalUserId'], 'String');
            }
            if (data.hasOwnProperty('birthDate')) {
                obj['birthDate'] = ApiClient.convertToType(data['birthDate'], 'String');
            }
            if (data.hasOwnProperty('birthTime')) {
                obj['birthTime'] = ApiClient.convertToType(data['birthTime'], 'String');
            }
            if (data.hasOwnProperty('birthPlaceLat')) {
                obj['birthPlaceLat'] = ApiClient.convertToType(data['birthPlaceLat'], 'Number');
            }
            if (data.hasOwnProperty('birthPlaceLng')) {
                obj['birthPlaceLng'] = ApiClient.convertToType(data['birthPlaceLng'], 'Number');
            }
            if (data.hasOwnProperty('birthPlaceName')) {
                obj['birthPlaceName'] = ApiClient.convertToType(data['birthPlaceName'], 'String');
            }
            if (data.hasOwnProperty('timezone')) {
                obj['timezone'] = ApiClient.convertToType(data['timezone'], 'String');
            }
            if (data.hasOwnProperty('metadata')) {
                obj['metadata'] = ApiClient.convertToType(data['metadata'], {'String': Object});
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CreateChatProfileRequestDataAttributes</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CreateChatProfileRequestDataAttributes</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CreateChatProfileRequestDataAttributes.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['externalUserId'] && !(typeof data['externalUserId'] === 'string' || data['externalUserId'] instanceof String)) {
            throw new Error("Expected the field `externalUserId` to be a primitive type in the JSON string but got " + data['externalUserId']);
        }
        // ensure the json data is a string
        if (data['birthDate'] && !(typeof data['birthDate'] === 'string' || data['birthDate'] instanceof String)) {
            throw new Error("Expected the field `birthDate` to be a primitive type in the JSON string but got " + data['birthDate']);
        }
        // ensure the json data is a string
        if (data['birthTime'] && !(typeof data['birthTime'] === 'string' || data['birthTime'] instanceof String)) {
            throw new Error("Expected the field `birthTime` to be a primitive type in the JSON string but got " + data['birthTime']);
        }
        // ensure the json data is a string
        if (data['birthPlaceName'] && !(typeof data['birthPlaceName'] === 'string' || data['birthPlaceName'] instanceof String)) {
            throw new Error("Expected the field `birthPlaceName` to be a primitive type in the JSON string but got " + data['birthPlaceName']);
        }
        // ensure the json data is a string
        if (data['timezone'] && !(typeof data['timezone'] === 'string' || data['timezone'] instanceof String)) {
            throw new Error("Expected the field `timezone` to be a primitive type in the JSON string but got " + data['timezone']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getExternalUserId() {
        return this.externalUserId;
    }

    /**
     * @param {String} externalUserId
     */
    setExternalUserId(externalUserId) {
        this['externalUserId'] = externalUserId;
    }
/**
     * @return {String}
     */
    getBirthDate() {
        return this.birthDate;
    }

    /**
     * @param {String} birthDate
     */
    setBirthDate(birthDate) {
        this['birthDate'] = birthDate;
    }
/**
     * @return {String}
     */
    getBirthTime() {
        return this.birthTime;
    }

    /**
     * @param {String} birthTime
     */
    setBirthTime(birthTime) {
        this['birthTime'] = birthTime;
    }
/**
     * @return {Number}
     */
    getBirthPlaceLat() {
        return this.birthPlaceLat;
    }

    /**
     * @param {Number} birthPlaceLat
     */
    setBirthPlaceLat(birthPlaceLat) {
        this['birthPlaceLat'] = birthPlaceLat;
    }
/**
     * @return {Number}
     */
    getBirthPlaceLng() {
        return this.birthPlaceLng;
    }

    /**
     * @param {Number} birthPlaceLng
     */
    setBirthPlaceLng(birthPlaceLng) {
        this['birthPlaceLng'] = birthPlaceLng;
    }
/**
     * @return {String}
     */
    getBirthPlaceName() {
        return this.birthPlaceName;
    }

    /**
     * @param {String} birthPlaceName
     */
    setBirthPlaceName(birthPlaceName) {
        this['birthPlaceName'] = birthPlaceName;
    }
/**
     * @return {String}
     */
    getTimezone() {
        return this.timezone;
    }

    /**
     * @param {String} timezone
     */
    setTimezone(timezone) {
        this['timezone'] = timezone;
    }
/**
     * @return {Object.<String, Object>}
     */
    getMetadata() {
        return this.metadata;
    }

    /**
     * @param {Object.<String, Object>} metadata
     */
    setMetadata(metadata) {
        this['metadata'] = metadata;
    }

}

CreateChatProfileRequestDataAttributes.RequiredProperties = ["birthDate", "birthPlaceLat", "birthPlaceLng", "timezone"];

/**
 * @member {String} externalUserId
 */
CreateChatProfileRequestDataAttributes.prototype['externalUserId'] = undefined;

/**
 * @member {String} birthDate
 */
CreateChatProfileRequestDataAttributes.prototype['birthDate'] = undefined;

/**
 * @member {String} birthTime
 */
CreateChatProfileRequestDataAttributes.prototype['birthTime'] = undefined;

/**
 * @member {Number} birthPlaceLat
 */
CreateChatProfileRequestDataAttributes.prototype['birthPlaceLat'] = undefined;

/**
 * @member {Number} birthPlaceLng
 */
CreateChatProfileRequestDataAttributes.prototype['birthPlaceLng'] = undefined;

/**
 * @member {String} birthPlaceName
 */
CreateChatProfileRequestDataAttributes.prototype['birthPlaceName'] = undefined;

/**
 * @member {String} timezone
 */
CreateChatProfileRequestDataAttributes.prototype['timezone'] = undefined;

/**
 * @member {Object.<String, Object>} metadata
 */
CreateChatProfileRequestDataAttributes.prototype['metadata'] = undefined;






export default CreateChatProfileRequestDataAttributes;

