/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The CreateChatbotRequestDataAttributes model module.
 * @module model/CreateChatbotRequestDataAttributes
 * @version 25.12.4
 */
class CreateChatbotRequestDataAttributes {
    /**
     * Constructs a new <code>CreateChatbotRequestDataAttributes</code>.
     * @alias module:model/CreateChatbotRequestDataAttributes
     * @param name {String} 
     */
    constructor(name) { 
        
        CreateChatbotRequestDataAttributes.initialize(this, name);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, name) { 
        obj['name'] = name;
    }

    /**
     * Constructs a <code>CreateChatbotRequestDataAttributes</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CreateChatbotRequestDataAttributes} obj Optional instance to populate.
     * @return {module:model/CreateChatbotRequestDataAttributes} The populated <code>CreateChatbotRequestDataAttributes</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CreateChatbotRequestDataAttributes();

            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('description')) {
                obj['description'] = ApiClient.convertToType(data['description'], 'String');
            }
            if (data.hasOwnProperty('enabledPlugins')) {
                obj['enabledPlugins'] = ApiClient.convertToType(data['enabledPlugins'], ['String']);
            }
            if (data.hasOwnProperty('settings')) {
                obj['settings'] = ApiClient.convertToType(data['settings'], {'String': Object});
            }
            if (data.hasOwnProperty('widgetConfig')) {
                obj['widgetConfig'] = ApiClient.convertToType(data['widgetConfig'], {'String': Object});
            }
            if (data.hasOwnProperty('allowedDomains')) {
                obj['allowedDomains'] = ApiClient.convertToType(data['allowedDomains'], ['String']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CreateChatbotRequestDataAttributes</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CreateChatbotRequestDataAttributes</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CreateChatbotRequestDataAttributes.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['name'] && !(typeof data['name'] === 'string' || data['name'] instanceof String)) {
            throw new Error("Expected the field `name` to be a primitive type in the JSON string but got " + data['name']);
        }
        // ensure the json data is a string
        if (data['description'] && !(typeof data['description'] === 'string' || data['description'] instanceof String)) {
            throw new Error("Expected the field `description` to be a primitive type in the JSON string but got " + data['description']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['enabledPlugins'])) {
            throw new Error("Expected the field `enabledPlugins` to be an array in the JSON data but got " + data['enabledPlugins']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['allowedDomains'])) {
            throw new Error("Expected the field `allowedDomains` to be an array in the JSON data but got " + data['allowedDomains']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getName() {
        return this.name;
    }

    /**
     * @param {String} name
     */
    setName(name) {
        this['name'] = name;
    }
/**
     * @return {String}
     */
    getDescription() {
        return this.description;
    }

    /**
     * @param {String} description
     */
    setDescription(description) {
        this['description'] = description;
    }
/**
     * @return {Array.<String>}
     */
    getEnabledPlugins() {
        return this.enabledPlugins;
    }

    /**
     * @param {Array.<String>} enabledPlugins
     */
    setEnabledPlugins(enabledPlugins) {
        this['enabledPlugins'] = enabledPlugins;
    }
/**
     * @return {Object.<String, Object>}
     */
    getSettings() {
        return this.settings;
    }

    /**
     * @param {Object.<String, Object>} settings
     */
    setSettings(settings) {
        this['settings'] = settings;
    }
/**
     * @return {Object.<String, Object>}
     */
    getWidgetConfig() {
        return this.widgetConfig;
    }

    /**
     * @param {Object.<String, Object>} widgetConfig
     */
    setWidgetConfig(widgetConfig) {
        this['widgetConfig'] = widgetConfig;
    }
/**
     * @return {Array.<String>}
     */
    getAllowedDomains() {
        return this.allowedDomains;
    }

    /**
     * @param {Array.<String>} allowedDomains
     */
    setAllowedDomains(allowedDomains) {
        this['allowedDomains'] = allowedDomains;
    }

}

CreateChatbotRequestDataAttributes.RequiredProperties = ["name"];

/**
 * @member {String} name
 */
CreateChatbotRequestDataAttributes.prototype['name'] = undefined;

/**
 * @member {String} description
 */
CreateChatbotRequestDataAttributes.prototype['description'] = undefined;

/**
 * @member {Array.<String>} enabledPlugins
 */
CreateChatbotRequestDataAttributes.prototype['enabledPlugins'] = undefined;

/**
 * @member {Object.<String, Object>} settings
 */
CreateChatbotRequestDataAttributes.prototype['settings'] = undefined;

/**
 * @member {Object.<String, Object>} widgetConfig
 */
CreateChatbotRequestDataAttributes.prototype['widgetConfig'] = undefined;

/**
 * @member {Array.<String>} allowedDomains
 */
CreateChatbotRequestDataAttributes.prototype['allowedDomains'] = undefined;






export default CreateChatbotRequestDataAttributes;

