/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import DailyHoroscopeItem from './DailyHoroscopeItem';

/**
 * The DailyHoroscopeAttributes model module.
 * @module model/DailyHoroscopeAttributes
 * @version 25.12.4
 */
class DailyHoroscopeAttributes {
    /**
     * Constructs a new <code>DailyHoroscopeAttributes</code>.
     * @alias module:model/DailyHoroscopeAttributes
     * @param date {String} 
     * @param language {String} 
     * @param horoscopes {Object.<String, module:model/DailyHoroscopeItem>} 
     */
    constructor(date, language, horoscopes) { 
        
        DailyHoroscopeAttributes.initialize(this, date, language, horoscopes);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, date, language, horoscopes) { 
        obj['date'] = date;
        obj['language'] = language;
        obj['horoscopes'] = horoscopes;
    }

    /**
     * Constructs a <code>DailyHoroscopeAttributes</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/DailyHoroscopeAttributes} obj Optional instance to populate.
     * @return {module:model/DailyHoroscopeAttributes} The populated <code>DailyHoroscopeAttributes</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new DailyHoroscopeAttributes();

            if (data.hasOwnProperty('date')) {
                obj['date'] = ApiClient.convertToType(data['date'], 'String');
            }
            if (data.hasOwnProperty('language')) {
                obj['language'] = ApiClient.convertToType(data['language'], 'String');
            }
            if (data.hasOwnProperty('horoscopes')) {
                obj['horoscopes'] = ApiClient.convertToType(data['horoscopes'], {'String': DailyHoroscopeItem});
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>DailyHoroscopeAttributes</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>DailyHoroscopeAttributes</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of DailyHoroscopeAttributes.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['date'] && !(typeof data['date'] === 'string' || data['date'] instanceof String)) {
            throw new Error("Expected the field `date` to be a primitive type in the JSON string but got " + data['date']);
        }
        // ensure the json data is a string
        if (data['language'] && !(typeof data['language'] === 'string' || data['language'] instanceof String)) {
            throw new Error("Expected the field `language` to be a primitive type in the JSON string but got " + data['language']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getDate() {
        return this.date;
    }

    /**
     * @param {String} date
     */
    setDate(date) {
        this['date'] = date;
    }
/**
     * @return {String}
     */
    getLanguage() {
        return this.language;
    }

    /**
     * @param {String} language
     */
    setLanguage(language) {
        this['language'] = language;
    }
/**
     * @return {Object.<String, module:model/DailyHoroscopeItem>}
     */
    getHoroscopes() {
        return this.horoscopes;
    }

    /**
     * @param {Object.<String, module:model/DailyHoroscopeItem>} horoscopes
     */
    setHoroscopes(horoscopes) {
        this['horoscopes'] = horoscopes;
    }

}

DailyHoroscopeAttributes.RequiredProperties = ["date", "language", "horoscopes"];

/**
 * @member {String} date
 */
DailyHoroscopeAttributes.prototype['date'] = undefined;

/**
 * @member {String} language
 */
DailyHoroscopeAttributes.prototype['language'] = undefined;

/**
 * @member {Object.<String, module:model/DailyHoroscopeItem>} horoscopes
 */
DailyHoroscopeAttributes.prototype['horoscopes'] = undefined;






export default DailyHoroscopeAttributes;

