/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import AnyOf from './AnyOf';

/**
 * The DailyHoroscopeItem model module.
 * @module model/DailyHoroscopeItem
 * @version 25.12.4
 */
class DailyHoroscopeItem {
    /**
     * Constructs a new <code>DailyHoroscopeItem</code>.
     * @alias module:model/DailyHoroscopeItem
     * @param sign {String} 
     */
    constructor(sign) { 
        
        DailyHoroscopeItem.initialize(this, sign);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, sign) { 
        obj['sign'] = sign;
    }

    /**
     * Constructs a <code>DailyHoroscopeItem</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/DailyHoroscopeItem} obj Optional instance to populate.
     * @return {module:model/DailyHoroscopeItem} The populated <code>DailyHoroscopeItem</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new DailyHoroscopeItem();

            if (data.hasOwnProperty('sign')) {
                obj['sign'] = ApiClient.convertToType(data['sign'], 'String');
            }
            if (data.hasOwnProperty('title')) {
                obj['title'] = ApiClient.convertToType(data['title'], 'String');
            }
            if (data.hasOwnProperty('body')) {
                obj['body'] = ApiClient.convertToType(data['body'], 'String');
            }
            if (data.hasOwnProperty('metadata')) {
                obj['metadata'] = ApiClient.convertToType(data['metadata'], AnyOf);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>DailyHoroscopeItem</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>DailyHoroscopeItem</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of DailyHoroscopeItem.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['sign'] && !(typeof data['sign'] === 'string' || data['sign'] instanceof String)) {
            throw new Error("Expected the field `sign` to be a primitive type in the JSON string but got " + data['sign']);
        }
        // ensure the json data is a string
        if (data['title'] && !(typeof data['title'] === 'string' || data['title'] instanceof String)) {
            throw new Error("Expected the field `title` to be a primitive type in the JSON string but got " + data['title']);
        }
        // ensure the json data is a string
        if (data['body'] && !(typeof data['body'] === 'string' || data['body'] instanceof String)) {
            throw new Error("Expected the field `body` to be a primitive type in the JSON string but got " + data['body']);
        }
        // validate the optional field `metadata`
        if (data['metadata']) { // data not null
          AnyOf.validateJSON(data['metadata']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getSign() {
        return this.sign;
    }

    /**
     * @param {String} sign
     */
    setSign(sign) {
        this['sign'] = sign;
    }
/**
     * @return {String}
     */
    getTitle() {
        return this.title;
    }

    /**
     * @param {String} title
     */
    setTitle(title) {
        this['title'] = title;
    }
/**
     * @return {String}
     */
    getBody() {
        return this.body;
    }

    /**
     * @param {String} body
     */
    setBody(body) {
        this['body'] = body;
    }
/**
     * @return {module:model/AnyOf}
     */
    getMetadata() {
        return this.metadata;
    }

    /**
     * @param {module:model/AnyOf} metadata
     */
    setMetadata(metadata) {
        this['metadata'] = metadata;
    }

}

DailyHoroscopeItem.RequiredProperties = ["sign"];

/**
 * @member {String} sign
 */
DailyHoroscopeItem.prototype['sign'] = undefined;

/**
 * @member {String} title
 */
DailyHoroscopeItem.prototype['title'] = undefined;

/**
 * @member {String} body
 */
DailyHoroscopeItem.prototype['body'] = undefined;

/**
 * @member {module:model/AnyOf} metadata
 */
DailyHoroscopeItem.prototype['metadata'] = undefined;






export default DailyHoroscopeItem;

