/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import DailyHoroscopeAttributes from './DailyHoroscopeAttributes';

/**
 * The DailyHoroscopeResponseData model module.
 * @module model/DailyHoroscopeResponseData
 * @version 25.12.4
 */
class DailyHoroscopeResponseData {
    /**
     * Constructs a new <code>DailyHoroscopeResponseData</code>.
     * @alias module:model/DailyHoroscopeResponseData
     * @param type {Object} 
     * @param attributes {module:model/DailyHoroscopeAttributes} 
     */
    constructor(type, attributes) { 
        
        DailyHoroscopeResponseData.initialize(this, type, attributes);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, type, attributes) { 
        obj['type'] = type;
        obj['attributes'] = attributes;
    }

    /**
     * Constructs a <code>DailyHoroscopeResponseData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/DailyHoroscopeResponseData} obj Optional instance to populate.
     * @return {module:model/DailyHoroscopeResponseData} The populated <code>DailyHoroscopeResponseData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new DailyHoroscopeResponseData();

            if (data.hasOwnProperty('type')) {
                obj['type'] = ApiClient.convertToType(data['type'], Object);
            }
            if (data.hasOwnProperty('attributes')) {
                obj['attributes'] = DailyHoroscopeAttributes.constructFromObject(data['attributes']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>DailyHoroscopeResponseData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>DailyHoroscopeResponseData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of DailyHoroscopeResponseData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // validate the optional field `attributes`
        if (data['attributes']) { // data not null
          DailyHoroscopeAttributes.validateJSON(data['attributes']);
        }

        return true;
    }

/**
     * @return {Object}
     */
    getType() {
        return this.type;
    }

    /**
     * @param {Object} type
     */
    setType(type) {
        this['type'] = type;
    }
/**
     * @return {module:model/DailyHoroscopeAttributes}
     */
    getAttributes() {
        return this.attributes;
    }

    /**
     * @param {module:model/DailyHoroscopeAttributes} attributes
     */
    setAttributes(attributes) {
        this['attributes'] = attributes;
    }

}

DailyHoroscopeResponseData.RequiredProperties = ["type", "attributes"];

/**
 * @member {Object} type
 */
DailyHoroscopeResponseData.prototype['type'] = undefined;

/**
 * @member {module:model/DailyHoroscopeAttributes} attributes
 */
DailyHoroscopeResponseData.prototype['attributes'] = undefined;






export default DailyHoroscopeResponseData;

