/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import GetApiOrgUsers200ResponseDataInner from './GetApiOrgUsers200ResponseDataInner';
import GetApiOrgUsers200ResponseLinks from './GetApiOrgUsers200ResponseLinks';
import GetApiOrgUsers200ResponseMeta from './GetApiOrgUsers200ResponseMeta';

/**
 * The GetApiOrgUsers200Response model module.
 * @module model/GetApiOrgUsers200Response
 * @version 25.12.4
 */
class GetApiOrgUsers200Response {
    /**
     * Constructs a new <code>GetApiOrgUsers200Response</code>.
     * @alias module:model/GetApiOrgUsers200Response
     * @param links {module:model/GetApiOrgUsers200ResponseLinks} 
     * @param data {Array.<module:model/GetApiOrgUsers200ResponseDataInner>} 
     * @param meta {module:model/GetApiOrgUsers200ResponseMeta} 
     */
    constructor(links, data, meta) { 
        
        GetApiOrgUsers200Response.initialize(this, links, data, meta);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, links, data, meta) { 
        obj['links'] = links;
        obj['data'] = data;
        obj['meta'] = meta;
    }

    /**
     * Constructs a <code>GetApiOrgUsers200Response</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/GetApiOrgUsers200Response} obj Optional instance to populate.
     * @return {module:model/GetApiOrgUsers200Response} The populated <code>GetApiOrgUsers200Response</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new GetApiOrgUsers200Response();

            if (data.hasOwnProperty('links')) {
                obj['links'] = GetApiOrgUsers200ResponseLinks.constructFromObject(data['links']);
            }
            if (data.hasOwnProperty('data')) {
                obj['data'] = ApiClient.convertToType(data['data'], [GetApiOrgUsers200ResponseDataInner]);
            }
            if (data.hasOwnProperty('meta')) {
                obj['meta'] = GetApiOrgUsers200ResponseMeta.constructFromObject(data['meta']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>GetApiOrgUsers200Response</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>GetApiOrgUsers200Response</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of GetApiOrgUsers200Response.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // validate the optional field `links`
        if (data['links']) { // data not null
          GetApiOrgUsers200ResponseLinks.validateJSON(data['links']);
        }
        if (data['data']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['data'])) {
                throw new Error("Expected the field `data` to be an array in the JSON data but got " + data['data']);
            }
            // validate the optional field `data` (array)
            for (const item of data['data']) {
                GetApiOrgUsers200ResponseDataInner.validateJSON(item);
            };
        }
        // validate the optional field `meta`
        if (data['meta']) { // data not null
          GetApiOrgUsers200ResponseMeta.validateJSON(data['meta']);
        }

        return true;
    }

/**
     * @return {module:model/GetApiOrgUsers200ResponseLinks}
     */
    getLinks() {
        return this.links;
    }

    /**
     * @param {module:model/GetApiOrgUsers200ResponseLinks} links
     */
    setLinks(links) {
        this['links'] = links;
    }
/**
     * @return {Array.<module:model/GetApiOrgUsers200ResponseDataInner>}
     */
    getData() {
        return this.data;
    }

    /**
     * @param {Array.<module:model/GetApiOrgUsers200ResponseDataInner>} data
     */
    setData(data) {
        this['data'] = data;
    }
/**
     * @return {module:model/GetApiOrgUsers200ResponseMeta}
     */
    getMeta() {
        return this.meta;
    }

    /**
     * @param {module:model/GetApiOrgUsers200ResponseMeta} meta
     */
    setMeta(meta) {
        this['meta'] = meta;
    }

}

GetApiOrgUsers200Response.RequiredProperties = ["links", "data", "meta"];

/**
 * @member {module:model/GetApiOrgUsers200ResponseLinks} links
 */
GetApiOrgUsers200Response.prototype['links'] = undefined;

/**
 * @member {Array.<module:model/GetApiOrgUsers200ResponseDataInner>} data
 */
GetApiOrgUsers200Response.prototype['data'] = undefined;

/**
 * @member {module:model/GetApiOrgUsers200ResponseMeta} meta
 */
GetApiOrgUsers200Response.prototype['meta'] = undefined;






export default GetApiOrgUsers200Response;

