/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The GetApiOrgUsers200ResponseDataInnerAttributes model module.
 * @module model/GetApiOrgUsers200ResponseDataInnerAttributes
 * @version 25.12.4
 */
class GetApiOrgUsers200ResponseDataInnerAttributes {
    /**
     * Constructs a new <code>GetApiOrgUsers200ResponseDataInnerAttributes</code>.
     * @alias module:model/GetApiOrgUsers200ResponseDataInnerAttributes
     * @param email {String} 
     * @param name {String} 
     * @param role {String} 
     */
    constructor(email, name, role) { 
        
        GetApiOrgUsers200ResponseDataInnerAttributes.initialize(this, email, name, role);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, email, name, role) { 
        obj['email'] = email;
        obj['name'] = name;
        obj['role'] = role;
    }

    /**
     * Constructs a <code>GetApiOrgUsers200ResponseDataInnerAttributes</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/GetApiOrgUsers200ResponseDataInnerAttributes} obj Optional instance to populate.
     * @return {module:model/GetApiOrgUsers200ResponseDataInnerAttributes} The populated <code>GetApiOrgUsers200ResponseDataInnerAttributes</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new GetApiOrgUsers200ResponseDataInnerAttributes();

            if (data.hasOwnProperty('email')) {
                obj['email'] = ApiClient.convertToType(data['email'], 'String');
            }
            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('role')) {
                obj['role'] = ApiClient.convertToType(data['role'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>GetApiOrgUsers200ResponseDataInnerAttributes</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>GetApiOrgUsers200ResponseDataInnerAttributes</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of GetApiOrgUsers200ResponseDataInnerAttributes.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['email'] && !(typeof data['email'] === 'string' || data['email'] instanceof String)) {
            throw new Error("Expected the field `email` to be a primitive type in the JSON string but got " + data['email']);
        }
        // ensure the json data is a string
        if (data['name'] && !(typeof data['name'] === 'string' || data['name'] instanceof String)) {
            throw new Error("Expected the field `name` to be a primitive type in the JSON string but got " + data['name']);
        }
        // ensure the json data is a string
        if (data['role'] && !(typeof data['role'] === 'string' || data['role'] instanceof String)) {
            throw new Error("Expected the field `role` to be a primitive type in the JSON string but got " + data['role']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getEmail() {
        return this.email;
    }

    /**
     * @param {String} email
     */
    setEmail(email) {
        this['email'] = email;
    }
/**
     * @return {String}
     */
    getName() {
        return this.name;
    }

    /**
     * @param {String} name
     */
    setName(name) {
        this['name'] = name;
    }
/**
     * @return {String}
     */
    getRole() {
        return this.role;
    }

    /**
     * @param {String} role
     */
    setRole(role) {
        this['role'] = role;
    }

}

GetApiOrgUsers200ResponseDataInnerAttributes.RequiredProperties = ["email", "name", "role"];

/**
 * @member {String} email
 */
GetApiOrgUsers200ResponseDataInnerAttributes.prototype['email'] = undefined;

/**
 * @member {String} name
 */
GetApiOrgUsers200ResponseDataInnerAttributes.prototype['name'] = undefined;

/**
 * @member {String} role
 */
GetApiOrgUsers200ResponseDataInnerAttributes.prototype['role'] = undefined;






export default GetApiOrgUsers200ResponseDataInnerAttributes;

