/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import AnyOf from './AnyOf';
import ReportPeriod from './ReportPeriod';

/**
 * The HoroscopeReportAttributes model module.
 * @module model/HoroscopeReportAttributes
 * @version 25.12.4
 */
class HoroscopeReportAttributes {
    /**
     * Constructs a new <code>HoroscopeReportAttributes</code>.
     * @alias module:model/HoroscopeReportAttributes
     * @param reportType {String} 
     * @param zodiacSign {String} 
     * @param period {module:model/ReportPeriod} 
     * @param language {String} 
     */
    constructor(reportType, zodiacSign, period, language) { 
        
        HoroscopeReportAttributes.initialize(this, reportType, zodiacSign, period, language);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, reportType, zodiacSign, period, language) { 
        obj['reportType'] = reportType;
        obj['zodiacSign'] = zodiacSign;
        obj['period'] = period;
        obj['language'] = language;
    }

    /**
     * Constructs a <code>HoroscopeReportAttributes</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/HoroscopeReportAttributes} obj Optional instance to populate.
     * @return {module:model/HoroscopeReportAttributes} The populated <code>HoroscopeReportAttributes</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new HoroscopeReportAttributes();

            if (data.hasOwnProperty('reportType')) {
                obj['reportType'] = ApiClient.convertToType(data['reportType'], 'String');
            }
            if (data.hasOwnProperty('zodiacSign')) {
                obj['zodiacSign'] = ApiClient.convertToType(data['zodiacSign'], 'String');
            }
            if (data.hasOwnProperty('period')) {
                obj['period'] = ReportPeriod.constructFromObject(data['period']);
            }
            if (data.hasOwnProperty('language')) {
                obj['language'] = ApiClient.convertToType(data['language'], 'String');
            }
            if (data.hasOwnProperty('title')) {
                obj['title'] = ApiClient.convertToType(data['title'], 'String');
            }
            if (data.hasOwnProperty('body')) {
                obj['body'] = ApiClient.convertToType(data['body'], 'String');
            }
            if (data.hasOwnProperty('metadata')) {
                obj['metadata'] = ApiClient.convertToType(data['metadata'], AnyOf);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>HoroscopeReportAttributes</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>HoroscopeReportAttributes</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of HoroscopeReportAttributes.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['reportType'] && !(typeof data['reportType'] === 'string' || data['reportType'] instanceof String)) {
            throw new Error("Expected the field `reportType` to be a primitive type in the JSON string but got " + data['reportType']);
        }
        // ensure the json data is a string
        if (data['zodiacSign'] && !(typeof data['zodiacSign'] === 'string' || data['zodiacSign'] instanceof String)) {
            throw new Error("Expected the field `zodiacSign` to be a primitive type in the JSON string but got " + data['zodiacSign']);
        }
        // validate the optional field `period`
        if (data['period']) { // data not null
          ReportPeriod.validateJSON(data['period']);
        }
        // ensure the json data is a string
        if (data['language'] && !(typeof data['language'] === 'string' || data['language'] instanceof String)) {
            throw new Error("Expected the field `language` to be a primitive type in the JSON string but got " + data['language']);
        }
        // ensure the json data is a string
        if (data['title'] && !(typeof data['title'] === 'string' || data['title'] instanceof String)) {
            throw new Error("Expected the field `title` to be a primitive type in the JSON string but got " + data['title']);
        }
        // ensure the json data is a string
        if (data['body'] && !(typeof data['body'] === 'string' || data['body'] instanceof String)) {
            throw new Error("Expected the field `body` to be a primitive type in the JSON string but got " + data['body']);
        }
        // validate the optional field `metadata`
        if (data['metadata']) { // data not null
          AnyOf.validateJSON(data['metadata']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getReportType() {
        return this.reportType;
    }

    /**
     * @param {String} reportType
     */
    setReportType(reportType) {
        this['reportType'] = reportType;
    }
/**
     * @return {String}
     */
    getZodiacSign() {
        return this.zodiacSign;
    }

    /**
     * @param {String} zodiacSign
     */
    setZodiacSign(zodiacSign) {
        this['zodiacSign'] = zodiacSign;
    }
/**
     * @return {module:model/ReportPeriod}
     */
    getPeriod() {
        return this.period;
    }

    /**
     * @param {module:model/ReportPeriod} period
     */
    setPeriod(period) {
        this['period'] = period;
    }
/**
     * @return {String}
     */
    getLanguage() {
        return this.language;
    }

    /**
     * @param {String} language
     */
    setLanguage(language) {
        this['language'] = language;
    }
/**
     * @return {String}
     */
    getTitle() {
        return this.title;
    }

    /**
     * @param {String} title
     */
    setTitle(title) {
        this['title'] = title;
    }
/**
     * @return {String}
     */
    getBody() {
        return this.body;
    }

    /**
     * @param {String} body
     */
    setBody(body) {
        this['body'] = body;
    }
/**
     * @return {module:model/AnyOf}
     */
    getMetadata() {
        return this.metadata;
    }

    /**
     * @param {module:model/AnyOf} metadata
     */
    setMetadata(metadata) {
        this['metadata'] = metadata;
    }

}

HoroscopeReportAttributes.RequiredProperties = ["reportType", "zodiacSign", "period", "language"];

/**
 * @member {String} reportType
 */
HoroscopeReportAttributes.prototype['reportType'] = undefined;

/**
 * @member {String} zodiacSign
 */
HoroscopeReportAttributes.prototype['zodiacSign'] = undefined;

/**
 * @member {module:model/ReportPeriod} period
 */
HoroscopeReportAttributes.prototype['period'] = undefined;

/**
 * @member {String} language
 */
HoroscopeReportAttributes.prototype['language'] = undefined;

/**
 * @member {String} title
 */
HoroscopeReportAttributes.prototype['title'] = undefined;

/**
 * @member {String} body
 */
HoroscopeReportAttributes.prototype['body'] = undefined;

/**
 * @member {module:model/AnyOf} metadata
 */
HoroscopeReportAttributes.prototype['metadata'] = undefined;






export default HoroscopeReportAttributes;

