/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import HoroscopeReportAttributes from './HoroscopeReportAttributes';

/**
 * The HoroscopeReportResponseData model module.
 * @module model/HoroscopeReportResponseData
 * @version 25.12.4
 */
class HoroscopeReportResponseData {
    /**
     * Constructs a new <code>HoroscopeReportResponseData</code>.
     * @alias module:model/HoroscopeReportResponseData
     * @param type {String} 
     * @param attributes {module:model/HoroscopeReportAttributes} 
     */
    constructor(type, attributes) { 
        
        HoroscopeReportResponseData.initialize(this, type, attributes);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, type, attributes) { 
        obj['type'] = type;
        obj['attributes'] = attributes;
    }

    /**
     * Constructs a <code>HoroscopeReportResponseData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/HoroscopeReportResponseData} obj Optional instance to populate.
     * @return {module:model/HoroscopeReportResponseData} The populated <code>HoroscopeReportResponseData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new HoroscopeReportResponseData();

            if (data.hasOwnProperty('type')) {
                obj['type'] = ApiClient.convertToType(data['type'], 'String');
            }
            if (data.hasOwnProperty('attributes')) {
                obj['attributes'] = HoroscopeReportAttributes.constructFromObject(data['attributes']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>HoroscopeReportResponseData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>HoroscopeReportResponseData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of HoroscopeReportResponseData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['type'] && !(typeof data['type'] === 'string' || data['type'] instanceof String)) {
            throw new Error("Expected the field `type` to be a primitive type in the JSON string but got " + data['type']);
        }
        // validate the optional field `attributes`
        if (data['attributes']) { // data not null
          HoroscopeReportAttributes.validateJSON(data['attributes']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getType() {
        return this.type;
    }

    /**
     * @param {String} type
     */
    setType(type) {
        this['type'] = type;
    }
/**
     * @return {module:model/HoroscopeReportAttributes}
     */
    getAttributes() {
        return this.attributes;
    }

    /**
     * @param {module:model/HoroscopeReportAttributes} attributes
     */
    setAttributes(attributes) {
        this['attributes'] = attributes;
    }

}

HoroscopeReportResponseData.RequiredProperties = ["type", "attributes"];

/**
 * @member {String} type
 */
HoroscopeReportResponseData.prototype['type'] = undefined;

/**
 * @member {module:model/HoroscopeReportAttributes} attributes
 */
HoroscopeReportResponseData.prototype['attributes'] = undefined;






export default HoroscopeReportResponseData;

