/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The Houses model module.
 * @module model/Houses
 * @version 25.12.4
 */
class Houses {
    /**
     * Constructs a new <code>Houses</code>.
     * @alias module:model/Houses
     * @param cusps {Array.<Number>} 
     * @param ascmc {Array.<Number>} 
     */
    constructor(cusps, ascmc) { 
        
        Houses.initialize(this, cusps, ascmc);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, cusps, ascmc) { 
        obj['cusps'] = cusps;
        obj['ascmc'] = ascmc;
    }

    /**
     * Constructs a <code>Houses</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/Houses} obj Optional instance to populate.
     * @return {module:model/Houses} The populated <code>Houses</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new Houses();

            if (data.hasOwnProperty('cusps')) {
                obj['cusps'] = ApiClient.convertToType(data['cusps'], ['Number']);
            }
            if (data.hasOwnProperty('ascmc')) {
                obj['ascmc'] = ApiClient.convertToType(data['ascmc'], ['Number']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>Houses</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>Houses</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of Houses.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is an array
        if (!Array.isArray(data['cusps'])) {
            throw new Error("Expected the field `cusps` to be an array in the JSON data but got " + data['cusps']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['ascmc'])) {
            throw new Error("Expected the field `ascmc` to be an array in the JSON data but got " + data['ascmc']);
        }

        return true;
    }

/**
     * @return {Array.<Number>}
     */
    getCusps() {
        return this.cusps;
    }

    /**
     * @param {Array.<Number>} cusps
     */
    setCusps(cusps) {
        this['cusps'] = cusps;
    }
/**
     * @return {Array.<Number>}
     */
    getAscmc() {
        return this.ascmc;
    }

    /**
     * @param {Array.<Number>} ascmc
     */
    setAscmc(ascmc) {
        this['ascmc'] = ascmc;
    }

}

Houses.RequiredProperties = ["cusps", "ascmc"];

/**
 * @member {Array.<Number>} cusps
 */
Houses.prototype['cusps'] = undefined;

/**
 * @member {Array.<Number>} ascmc
 */
Houses.prototype['ascmc'] = undefined;






export default Houses;

