/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The Location model module.
 * @module model/Location
 * @version 25.12.4
 */
class Location {
    /**
     * Constructs a new <code>Location</code>.
     * @alias module:model/Location
     * @param longitude {Number} Longitude in decimal degrees (-180 to 180)
     * @param latitude {Number} Latitude in decimal degrees (-90 to 90)
     * @param timezone {String} IANA timezone identifier (e.g., \"Europe/Amsterdam\")
     */
    constructor(longitude, latitude, timezone) { 
        
        Location.initialize(this, longitude, latitude, timezone);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, longitude, latitude, timezone) { 
        obj['longitude'] = longitude;
        obj['latitude'] = latitude;
        obj['timezone'] = timezone;
    }

    /**
     * Constructs a <code>Location</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/Location} obj Optional instance to populate.
     * @return {module:model/Location} The populated <code>Location</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new Location();

            if (data.hasOwnProperty('longitude')) {
                obj['longitude'] = ApiClient.convertToType(data['longitude'], 'Number');
            }
            if (data.hasOwnProperty('latitude')) {
                obj['latitude'] = ApiClient.convertToType(data['latitude'], 'Number');
            }
            if (data.hasOwnProperty('timezone')) {
                obj['timezone'] = ApiClient.convertToType(data['timezone'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>Location</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>Location</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of Location.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['timezone'] && !(typeof data['timezone'] === 'string' || data['timezone'] instanceof String)) {
            throw new Error("Expected the field `timezone` to be a primitive type in the JSON string but got " + data['timezone']);
        }

        return true;
    }

/**
     * Returns Longitude in decimal degrees (-180 to 180)
     * @return {Number}
     */
    getLongitude() {
        return this.longitude;
    }

    /**
     * Sets Longitude in decimal degrees (-180 to 180)
     * @param {Number} longitude Longitude in decimal degrees (-180 to 180)
     */
    setLongitude(longitude) {
        this['longitude'] = longitude;
    }
/**
     * Returns Latitude in decimal degrees (-90 to 90)
     * @return {Number}
     */
    getLatitude() {
        return this.latitude;
    }

    /**
     * Sets Latitude in decimal degrees (-90 to 90)
     * @param {Number} latitude Latitude in decimal degrees (-90 to 90)
     */
    setLatitude(latitude) {
        this['latitude'] = latitude;
    }
/**
     * Returns IANA timezone identifier (e.g., \"Europe/Amsterdam\")
     * @return {String}
     */
    getTimezone() {
        return this.timezone;
    }

    /**
     * Sets IANA timezone identifier (e.g., \"Europe/Amsterdam\")
     * @param {String} timezone IANA timezone identifier (e.g., \"Europe/Amsterdam\")
     */
    setTimezone(timezone) {
        this['timezone'] = timezone;
    }

}

Location.RequiredProperties = ["longitude", "latitude", "timezone"];

/**
 * Longitude in decimal degrees (-180 to 180)
 * @member {Number} longitude
 */
Location.prototype['longitude'] = undefined;

/**
 * Latitude in decimal degrees (-90 to 90)
 * @member {Number} latitude
 */
Location.prototype['latitude'] = undefined;

/**
 * IANA timezone identifier (e.g., \"Europe/Amsterdam\")
 * @member {String} timezone
 */
Location.prototype['timezone'] = undefined;






export default Location;

