/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Aspect1 from './Aspect1';
import CelestialPoint1 from './CelestialPoint1';
import ChartEntry1 from './ChartEntry1';
import Houses from './Houses';

/**
 * The LunarReturnData model module.
 * @module model/LunarReturnData
 * @version 25.12.4
 */
class LunarReturnData {
    /**
     * Constructs a new <code>LunarReturnData</code>.
     * @alias module:model/LunarReturnData
     * @param returnDate {String} 
     * @param aspects {Array.<module:model/Aspect1>} 
     * @param points {Object.<String, module:model/CelestialPoint1>} 
     * @param houses {module:model/Houses} 
     * @param charts {Object.<String, module:model/ChartEntry1>} 
     */
    constructor(returnDate, aspects, points, houses, charts) { 
        
        LunarReturnData.initialize(this, returnDate, aspects, points, houses, charts);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, returnDate, aspects, points, houses, charts) { 
        obj['returnDate'] = returnDate;
        obj['aspects'] = aspects;
        obj['points'] = points;
        obj['houses'] = houses;
        obj['charts'] = charts;
    }

    /**
     * Constructs a <code>LunarReturnData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/LunarReturnData} obj Optional instance to populate.
     * @return {module:model/LunarReturnData} The populated <code>LunarReturnData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new LunarReturnData();

            if (data.hasOwnProperty('returnDate')) {
                obj['returnDate'] = ApiClient.convertToType(data['returnDate'], 'String');
            }
            if (data.hasOwnProperty('aspects')) {
                obj['aspects'] = ApiClient.convertToType(data['aspects'], [Aspect1]);
            }
            if (data.hasOwnProperty('points')) {
                obj['points'] = ApiClient.convertToType(data['points'], {'String': CelestialPoint1});
            }
            if (data.hasOwnProperty('houses')) {
                obj['houses'] = Houses.constructFromObject(data['houses']);
            }
            if (data.hasOwnProperty('charts')) {
                obj['charts'] = ApiClient.convertToType(data['charts'], {'String': ChartEntry1});
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>LunarReturnData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>LunarReturnData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of LunarReturnData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['returnDate'] && !(typeof data['returnDate'] === 'string' || data['returnDate'] instanceof String)) {
            throw new Error("Expected the field `returnDate` to be a primitive type in the JSON string but got " + data['returnDate']);
        }
        if (data['aspects']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['aspects'])) {
                throw new Error("Expected the field `aspects` to be an array in the JSON data but got " + data['aspects']);
            }
            // validate the optional field `aspects` (array)
            for (const item of data['aspects']) {
                Aspect1.validateJSON(item);
            };
        }
        // validate the optional field `houses`
        if (data['houses']) { // data not null
          Houses.validateJSON(data['houses']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getReturnDate() {
        return this.returnDate;
    }

    /**
     * @param {String} returnDate
     */
    setReturnDate(returnDate) {
        this['returnDate'] = returnDate;
    }
/**
     * @return {Array.<module:model/Aspect1>}
     */
    getAspects() {
        return this.aspects;
    }

    /**
     * @param {Array.<module:model/Aspect1>} aspects
     */
    setAspects(aspects) {
        this['aspects'] = aspects;
    }
/**
     * @return {Object.<String, module:model/CelestialPoint1>}
     */
    getPoints() {
        return this.points;
    }

    /**
     * @param {Object.<String, module:model/CelestialPoint1>} points
     */
    setPoints(points) {
        this['points'] = points;
    }
/**
     * @return {module:model/Houses}
     */
    getHouses() {
        return this.houses;
    }

    /**
     * @param {module:model/Houses} houses
     */
    setHouses(houses) {
        this['houses'] = houses;
    }
/**
     * @return {Object.<String, module:model/ChartEntry1>}
     */
    getCharts() {
        return this.charts;
    }

    /**
     * @param {Object.<String, module:model/ChartEntry1>} charts
     */
    setCharts(charts) {
        this['charts'] = charts;
    }

}

LunarReturnData.RequiredProperties = ["returnDate", "aspects", "points", "houses", "charts"];

/**
 * @member {String} returnDate
 */
LunarReturnData.prototype['returnDate'] = undefined;

/**
 * @member {Array.<module:model/Aspect1>} aspects
 */
LunarReturnData.prototype['aspects'] = undefined;

/**
 * @member {Object.<String, module:model/CelestialPoint1>} points
 */
LunarReturnData.prototype['points'] = undefined;

/**
 * @member {module:model/Houses} houses
 */
LunarReturnData.prototype['houses'] = undefined;

/**
 * @member {Object.<String, module:model/ChartEntry1>} charts
 */
LunarReturnData.prototype['charts'] = undefined;






export default LunarReturnData;

