/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Location from './Location';

/**
 * The LunarReturnRequest model module.
 * @module model/LunarReturnRequest
 * @version 25.12.4
 */
class LunarReturnRequest {
    /**
     * Constructs a new <code>LunarReturnRequest</code>.
     * @alias module:model/LunarReturnRequest
     * @param birthDateTime {String} Birth date and time in YYYY-MM-DDTHH:mm format
     * @param birthLocation {module:model/Location} 
     */
    constructor(birthDateTime, birthLocation) { 
        
        LunarReturnRequest.initialize(this, birthDateTime, birthLocation);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, birthDateTime, birthLocation) { 
        obj['birthDateTime'] = birthDateTime;
        obj['birthLocation'] = birthLocation;
        obj['houseSystem'] = 'placidus';
        obj['language'] = 'en';
        obj['includeText'] = true;
        obj['includeReadableEntities'] = false;
    }

    /**
     * Constructs a <code>LunarReturnRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/LunarReturnRequest} obj Optional instance to populate.
     * @return {module:model/LunarReturnRequest} The populated <code>LunarReturnRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new LunarReturnRequest();

            if (data.hasOwnProperty('birthDateTime')) {
                obj['birthDateTime'] = ApiClient.convertToType(data['birthDateTime'], 'String');
            }
            if (data.hasOwnProperty('birthLocation')) {
                obj['birthLocation'] = Location.constructFromObject(data['birthLocation']);
            }
            if (data.hasOwnProperty('returnDate')) {
                obj['returnDate'] = ApiClient.convertToType(data['returnDate'], 'String');
            }
            if (data.hasOwnProperty('houseSystem')) {
                obj['houseSystem'] = ApiClient.convertToType(data['houseSystem'], 'String');
            }
            if (data.hasOwnProperty('language')) {
                obj['language'] = ApiClient.convertToType(data['language'], 'String');
            }
            if (data.hasOwnProperty('includeText')) {
                obj['includeText'] = ApiClient.convertToType(data['includeText'], 'Boolean');
            }
            if (data.hasOwnProperty('includeReadableEntities')) {
                obj['includeReadableEntities'] = ApiClient.convertToType(data['includeReadableEntities'], 'Boolean');
            }
            if (data.hasOwnProperty('points')) {
                obj['points'] = ApiClient.convertToType(data['points'], ['String']);
            }
            if (data.hasOwnProperty('orbs')) {
                obj['orbs'] = ApiClient.convertToType(data['orbs'], {'String': 'Number'});
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>LunarReturnRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>LunarReturnRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of LunarReturnRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['birthDateTime'] && !(typeof data['birthDateTime'] === 'string' || data['birthDateTime'] instanceof String)) {
            throw new Error("Expected the field `birthDateTime` to be a primitive type in the JSON string but got " + data['birthDateTime']);
        }
        // validate the optional field `birthLocation`
        if (data['birthLocation']) { // data not null
          Location.validateJSON(data['birthLocation']);
        }
        // ensure the json data is a string
        if (data['returnDate'] && !(typeof data['returnDate'] === 'string' || data['returnDate'] instanceof String)) {
            throw new Error("Expected the field `returnDate` to be a primitive type in the JSON string but got " + data['returnDate']);
        }
        // ensure the json data is a string
        if (data['houseSystem'] && !(typeof data['houseSystem'] === 'string' || data['houseSystem'] instanceof String)) {
            throw new Error("Expected the field `houseSystem` to be a primitive type in the JSON string but got " + data['houseSystem']);
        }
        // ensure the json data is a string
        if (data['language'] && !(typeof data['language'] === 'string' || data['language'] instanceof String)) {
            throw new Error("Expected the field `language` to be a primitive type in the JSON string but got " + data['language']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['points'])) {
            throw new Error("Expected the field `points` to be an array in the JSON data but got " + data['points']);
        }

        return true;
    }

/**
     * Returns Birth date and time in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getBirthDateTime() {
        return this.birthDateTime;
    }

    /**
     * Sets Birth date and time in YYYY-MM-DDTHH:mm format
     * @param {String} birthDateTime Birth date and time in YYYY-MM-DDTHH:mm format
     */
    setBirthDateTime(birthDateTime) {
        this['birthDateTime'] = birthDateTime;
    }
/**
     * @return {module:model/Location}
     */
    getBirthLocation() {
        return this.birthLocation;
    }

    /**
     * @param {module:model/Location} birthLocation
     */
    setBirthLocation(birthLocation) {
        this['birthLocation'] = birthLocation;
    }
/**
     * Returns Date to find lunar return from (ISO 8601). Defaults to now.
     * @return {String}
     */
    getReturnDate() {
        return this.returnDate;
    }

    /**
     * Sets Date to find lunar return from (ISO 8601). Defaults to now.
     * @param {String} returnDate Date to find lunar return from (ISO 8601). Defaults to now.
     */
    setReturnDate(returnDate) {
        this['returnDate'] = returnDate;
    }
/**
     * Returns House system for calculations (default: \"placidus\")
     * @return {module:model/LunarReturnRequest.HouseSystemEnum}
     */
    getHouseSystem() {
        return this.houseSystem;
    }

    /**
     * Sets House system for calculations (default: \"placidus\")
     * @param {module:model/LunarReturnRequest.HouseSystemEnum} houseSystem House system for calculations (default: \"placidus\")
     */
    setHouseSystem(houseSystem) {
        this['houseSystem'] = houseSystem;
    }
/**
     * Returns Language code for text content
     * @return {String}
     */
    getLanguage() {
        return this.language;
    }

    /**
     * Sets Language code for text content
     * @param {String} language Language code for text content
     */
    setLanguage(language) {
        this['language'] = language;
    }
/**
     * Returns Include interpretation text
     * @return {Boolean}
     */
    getIncludeText() {
        return this.includeText;
    }

    /**
     * Sets Include interpretation text
     * @param {Boolean} includeText Include interpretation text
     */
    setIncludeText(includeText) {
        this['includeText'] = includeText;
    }
/**
     * Returns Include human-readable entity titles
     * @return {Boolean}
     */
    getIncludeReadableEntities() {
        return this.includeReadableEntities;
    }

    /**
     * Sets Include human-readable entity titles
     * @param {Boolean} includeReadableEntities Include human-readable entity titles
     */
    setIncludeReadableEntities(includeReadableEntities) {
        this['includeReadableEntities'] = includeReadableEntities;
    }
/**
     * Returns Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     * @return {Array.<String>}
     */
    getPoints() {
        return this.points;
    }

    /**
     * Sets Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     * @param {Array.<String>} points Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     */
    setPoints(points) {
        this['points'] = points;
    }
/**
     * Returns Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     * @return {Object.<String, Number>}
     */
    getOrbs() {
        return this.orbs;
    }

    /**
     * Sets Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     * @param {Object.<String, Number>} orbs Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     */
    setOrbs(orbs) {
        this['orbs'] = orbs;
    }

}

LunarReturnRequest.RequiredProperties = ["birthDateTime", "birthLocation"];

/**
 * Birth date and time in YYYY-MM-DDTHH:mm format
 * @member {String} birthDateTime
 */
LunarReturnRequest.prototype['birthDateTime'] = undefined;

/**
 * @member {module:model/Location} birthLocation
 */
LunarReturnRequest.prototype['birthLocation'] = undefined;

/**
 * Date to find lunar return from (ISO 8601). Defaults to now.
 * @member {String} returnDate
 */
LunarReturnRequest.prototype['returnDate'] = undefined;

/**
 * House system for calculations (default: \"placidus\")
 * @member {module:model/LunarReturnRequest.HouseSystemEnum} houseSystem
 * @default 'placidus'
 */
LunarReturnRequest.prototype['houseSystem'] = 'placidus';

/**
 * Language code for text content
 * @member {String} language
 * @default 'en'
 */
LunarReturnRequest.prototype['language'] = 'en';

/**
 * Include interpretation text
 * @member {Boolean} includeText
 * @default true
 */
LunarReturnRequest.prototype['includeText'] = true;

/**
 * Include human-readable entity titles
 * @member {Boolean} includeReadableEntities
 * @default false
 */
LunarReturnRequest.prototype['includeReadableEntities'] = false;

/**
 * Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
 * @member {Array.<String>} points
 */
LunarReturnRequest.prototype['points'] = undefined;

/**
 * Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
 * @member {Object.<String, Number>} orbs
 */
LunarReturnRequest.prototype['orbs'] = undefined;





/**
 * Allowed values for the <code>houseSystem</code> property.
 * @enum {String}
 * @readonly
 */
LunarReturnRequest['HouseSystemEnum'] = {

    /**
     * value: "placidus"
     * @const
     */
    "placidus": "placidus",

    /**
     * value: "koch"
     * @const
     */
    "koch": "koch",

    /**
     * value: "equal"
     * @const
     */
    "equal": "equal",

    /**
     * value: "whole"
     * @const
     */
    "whole": "whole",

    /**
     * value: "campanus"
     * @const
     */
    "campanus": "campanus",

    /**
     * value: "regiomontanus"
     * @const
     */
    "regiomontanus": "regiomontanus",

    /**
     * value: "porphyry"
     * @const
     */
    "porphyry": "porphyry"
};



export default LunarReturnRequest;

