/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The Module model module.
 * @module model/Module
 * @version 25.12.4
 */
class Module {
    /**
     * Constructs a new <code>Module</code>.
     * @alias module:model/Module
     * @param id {String} 
     * @param name {String} 
     * @param category {module:model/Module.CategoryEnum} 
     * @param horoscopeType {String} 
     * @param priceCents {Number} 
     */
    constructor(id, name, category, horoscopeType, priceCents) { 
        
        Module.initialize(this, id, name, category, horoscopeType, priceCents);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, id, name, category, horoscopeType, priceCents) { 
        obj['id'] = id;
        obj['name'] = name;
        obj['category'] = category;
        obj['horoscopeType'] = horoscopeType;
        obj['priceCents'] = priceCents;
    }

    /**
     * Constructs a <code>Module</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/Module} obj Optional instance to populate.
     * @return {module:model/Module} The populated <code>Module</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new Module();

            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'String');
            }
            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('description')) {
                obj['description'] = ApiClient.convertToType(data['description'], 'String');
            }
            if (data.hasOwnProperty('category')) {
                obj['category'] = ApiClient.convertToType(data['category'], 'String');
            }
            if (data.hasOwnProperty('horoscopeType')) {
                obj['horoscopeType'] = ApiClient.convertToType(data['horoscopeType'], 'String');
            }
            if (data.hasOwnProperty('contentType')) {
                obj['contentType'] = ApiClient.convertToType(data['contentType'], 'String');
            }
            if (data.hasOwnProperty('priceCents')) {
                obj['priceCents'] = ApiClient.convertToType(data['priceCents'], 'Number');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>Module</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>Module</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of Module.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['id'] && !(typeof data['id'] === 'string' || data['id'] instanceof String)) {
            throw new Error("Expected the field `id` to be a primitive type in the JSON string but got " + data['id']);
        }
        // ensure the json data is a string
        if (data['name'] && !(typeof data['name'] === 'string' || data['name'] instanceof String)) {
            throw new Error("Expected the field `name` to be a primitive type in the JSON string but got " + data['name']);
        }
        // ensure the json data is a string
        if (data['description'] && !(typeof data['description'] === 'string' || data['description'] instanceof String)) {
            throw new Error("Expected the field `description` to be a primitive type in the JSON string but got " + data['description']);
        }
        // ensure the json data is a string
        if (data['category'] && !(typeof data['category'] === 'string' || data['category'] instanceof String)) {
            throw new Error("Expected the field `category` to be a primitive type in the JSON string but got " + data['category']);
        }
        // ensure the json data is a string
        if (data['horoscopeType'] && !(typeof data['horoscopeType'] === 'string' || data['horoscopeType'] instanceof String)) {
            throw new Error("Expected the field `horoscopeType` to be a primitive type in the JSON string but got " + data['horoscopeType']);
        }
        // ensure the json data is a string
        if (data['contentType'] && !(typeof data['contentType'] === 'string' || data['contentType'] instanceof String)) {
            throw new Error("Expected the field `contentType` to be a primitive type in the JSON string but got " + data['contentType']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getId() {
        return this.id;
    }

    /**
     * @param {String} id
     */
    setId(id) {
        this['id'] = id;
    }
/**
     * @return {String}
     */
    getName() {
        return this.name;
    }

    /**
     * @param {String} name
     */
    setName(name) {
        this['name'] = name;
    }
/**
     * @return {String}
     */
    getDescription() {
        return this.description;
    }

    /**
     * @param {String} description
     */
    setDescription(description) {
        this['description'] = description;
    }
/**
     * @return {module:model/Module.CategoryEnum}
     */
    getCategory() {
        return this.category;
    }

    /**
     * @param {module:model/Module.CategoryEnum} category
     */
    setCategory(category) {
        this['category'] = category;
    }
/**
     * @return {String}
     */
    getHoroscopeType() {
        return this.horoscopeType;
    }

    /**
     * @param {String} horoscopeType
     */
    setHoroscopeType(horoscopeType) {
        this['horoscopeType'] = horoscopeType;
    }
/**
     * @return {String}
     */
    getContentType() {
        return this.contentType;
    }

    /**
     * @param {String} contentType
     */
    setContentType(contentType) {
        this['contentType'] = contentType;
    }
/**
     * @return {Number}
     */
    getPriceCents() {
        return this.priceCents;
    }

    /**
     * @param {Number} priceCents
     */
    setPriceCents(priceCents) {
        this['priceCents'] = priceCents;
    }

}

Module.RequiredProperties = ["id", "name", "category", "horoscopeType", "priceCents"];

/**
 * @member {String} id
 */
Module.prototype['id'] = undefined;

/**
 * @member {String} name
 */
Module.prototype['name'] = undefined;

/**
 * @member {String} description
 */
Module.prototype['description'] = undefined;

/**
 * @member {module:model/Module.CategoryEnum} category
 */
Module.prototype['category'] = undefined;

/**
 * @member {String} horoscopeType
 */
Module.prototype['horoscopeType'] = undefined;

/**
 * @member {String} contentType
 */
Module.prototype['contentType'] = undefined;

/**
 * @member {Number} priceCents
 */
Module.prototype['priceCents'] = undefined;





/**
 * Allowed values for the <code>category</code> property.
 * @enum {String}
 * @readonly
 */
Module['CategoryEnum'] = {

    /**
     * value: "calc"
     * @const
     */
    "calc": "calc",

    /**
     * value: "texts"
     * @const
     */
    "texts": "texts",

    /**
     * value: "charts"
     * @const
     */
    "charts": "charts"
};



export default Module;

